/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.neuron.InputOutputNeuron;
import org.neuroph.nnet.learning.BinaryHebbianLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class BAM
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public BAM(int inputNeuronsCount, int outputNeuronsCount) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("neuronType", InputOutputNeuron.class);
        neuronProperties.setProperty("bias", new Double(0.0));
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        neuronProperties.setProperty("transferFunction.yHigh", new Double(1.0));
        neuronProperties.setProperty("transferFunction.yLow", new Double(0.0));
        this.createNetwork(inputNeuronsCount, outputNeuronsCount, neuronProperties);
    }

    private void createNetwork(int inputNeuronsCount, int outputNeuronsCount, NeuronProperties neuronProperties) {
        this.setNetworkType(NeuralNetworkType.BAM);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsCount, neuronProperties);
        this.addLayer(inputLayer);
        Layer outputLayer = LayerFactory.createLayer(outputNeuronsCount, neuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, outputLayer);
        ConnectionFactory.fullConnect(outputLayer, inputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new BinaryHebbianLearning());
    }
}

