/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.layer.CompetitiveLayer;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class MaxNet
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public MaxNet(int neuronsCount) {
        this.createNetwork(neuronsCount);
    }

    private void createNetwork(int neuronsCount) {
        this.setNetworkType(NeuralNetworkType.MAXNET);
        Layer inputLayer = LayerFactory.createLayer(neuronsCount, new NeuronProperties());
        this.addLayer(inputLayer);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("neuronType", CompetitiveNeuron.class);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.RAMP);
        CompetitiveLayer competitiveLayer = new CompetitiveLayer(neuronsCount, neuronProperties);
        this.addLayer(competitiveLayer);
        double competitiveWeight = -(1.0 / (double)neuronsCount);
        ConnectionFactory.fullConnect((Layer)competitiveLayer, competitiveWeight, 1);
        ConnectionFactory.forwardConnect(inputLayer, competitiveLayer, 1.0);
        NeuralNetworkFactory.setDefaultIO(this);
    }
}

