/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp;

import org.neuroph.nnet.comp.layer.ConvolutionalLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.Layer2D;
import org.neuroph.nnet.comp.layer.PoolingLayer;

public class ConvolutionalUtils {
    public static void fullConnectMapLayers(FeatureMapsLayer fromLayer, FeatureMapsLayer toLayer) {
        block4: {
            block3: {
                if (!(toLayer instanceof ConvolutionalLayer)) break block3;
                for (int i = 0; i < fromLayer.getNumberOfMaps(); ++i) {
                    for (int j = 0; j < toLayer.getNumberOfMaps(); ++j) {
                        Layer2D fromMap = fromLayer.getFeatureMap(i);
                        Layer2D toMap = toLayer.getFeatureMap(j);
                        toLayer.connectMaps(fromMap, toMap);
                    }
                }
                break block4;
            }
            if (!(toLayer instanceof PoolingLayer)) break block4;
            for (int i = 0; i < toLayer.getNumberOfMaps(); ++i) {
                Layer2D fromMap = fromLayer.getFeatureMap(i);
                Layer2D toMap = toLayer.getFeatureMap(i);
                toLayer.connectMaps(fromMap, toMap);
            }
        }
    }

    public static void connectFeatureMaps(FeatureMapsLayer fromLayer, FeatureMapsLayer toLayer, int fromFeatureMapIndex, int toFeatureMapIndex) {
        Layer2D fromMap = fromLayer.getFeatureMap(fromFeatureMapIndex);
        Layer2D toMap = toLayer.getFeatureMap(toFeatureMapIndex);
        toLayer.connectMaps(fromMap, toMap);
    }
}

