/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.Max;
import org.neuroph.core.transfer.Tanh;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.Layer2D;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;

public class PoolingLayer
extends FeatureMapsLayer {
    private static final long serialVersionUID = -6771501759374920877L;
    public static final NeuronProperties DEFAULT_NEURON_PROP = new NeuronProperties();

    public PoolingLayer(FeatureMapsLayer fromLayer, Kernel kernel) {
        super(kernel);
        int numberOfMaps = fromLayer.getNumberOfMaps();
        Layer2D.Dimensions fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() / kernel.getWidth();
        int mapHeight = fromDimension.getHeight() / kernel.getHeight();
        this.mapDimensions = new Layer2D.Dimensions(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, DEFAULT_NEURON_PROP);
    }

    public PoolingLayer(FeatureMapsLayer fromLayer, Kernel kernel, int numberOfMaps, NeuronProperties neuronProp) {
        super(kernel);
        Layer2D.Dimensions fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() / kernel.getWidth();
        int mapHeight = fromDimension.getHeight() / kernel.getHeight();
        this.mapDimensions = new Layer2D.Dimensions(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, neuronProp);
    }

    @Override
    public void connectMaps(Layer2D fromMap, Layer2D toMap) {
        int kernelWidth = this.kernel.getWidth();
        int kernelHeight = this.kernel.getHeight();
        Weight weight = new Weight();
        weight.setValue(1.0);
        for (int x = 0; x < fromMap.getWidth() - kernelWidth + 1; x += kernelWidth) {
            for (int y = 0; y < fromMap.getHeight() - kernelHeight + 1; y += kernelHeight) {
                Neuron toNeuron = toMap.getNeuronAt(x / kernelWidth, y / kernelHeight);
                for (int dy = 0; dy < kernelHeight; ++dy) {
                    for (int dx = 0; dx < kernelWidth; ++dx) {
                        int fromX = x + dx;
                        int fromY = y + dy;
                        Neuron fromNeuron = fromMap.getNeuronAt(fromX, fromY);
                        ConnectionFactory.createConnection(fromNeuron, toNeuron, weight);
                    }
                }
            }
        }
    }

    static {
        DEFAULT_NEURON_PROP.setProperty("useBias", true);
        DEFAULT_NEURON_PROP.setProperty("transferFunction", Tanh.class);
        DEFAULT_NEURON_PROP.setProperty("inputFunction", Max.class);
    }
}

