/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.io.Serializable;
import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.learning.SupervisedLearning;

public class LMS
extends SupervisedLearning
implements Serializable {
    private static final long serialVersionUID = 2L;

    @Override
    protected void updateNetworkWeights(double[] outputError) {
        int i = 0;
        for (Neuron neuron : this.neuralNetwork.getOutputNeurons()) {
            neuron.setError(outputError[i]);
            this.updateNeuronWeights(neuron);
            ++i;
        }
    }

    public void updateNeuronWeights(Neuron neuron) {
        double neuronError = neuron.getError();
        for (Connection connection : neuron.getInputConnections()) {
            double input = connection.getInput();
            double weightChange = this.learningRate * neuronError * input;
            Weight weight = connection.getWeight();
            if (!this.isInBatchMode()) {
                weight.weightChange = weightChange;
                weight.value += weightChange;
                continue;
            }
            weight.weightChange += weightChange;
        }
    }
}

