/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Neuron;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.learning.LMS;

public class SigmoidDeltaRule
extends LMS {
    private static final long serialVersionUID = 1L;

    @Override
    protected void updateNetworkWeights(double[] outputError) {
        int i = 0;
        for (Neuron neuron : this.neuralNetwork.getOutputNeurons()) {
            if (outputError[i] == 0.0) {
                neuron.setError(0.0);
                ++i;
                continue;
            }
            TransferFunction transferFunction = neuron.getTransferFunction();
            double neuronInput = neuron.getNetInput();
            double delta = outputError[i] * transferFunction.getDerivative(neuronInput);
            neuron.setError(delta);
            this.updateNeuronWeights(neuron);
            ++i;
        }
    }
}

