/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.neuroph.core.data.DataSet;
import org.neuroph.util.data.sample.Sampling;

public class SubSampling
implements Sampling {
    private int subSetCount;
    private int[] subSetSizes;
    private boolean allowRepetition = false;

    public SubSampling(int subSetCount) {
        this.subSetCount = subSetCount;
        this.subSetSizes = null;
    }

    public SubSampling(int ... subSetSizes) {
        this.subSetSizes = subSetSizes;
        this.subSetCount = subSetSizes.length;
    }

    @Override
    public List<DataSet> sample(DataSet dataSet) {
        if (this.subSetSizes == null) {
            int singleSubSetSize = dataSet.size() / this.subSetCount;
            this.subSetSizes = new int[this.subSetCount];
            for (int i = 0; i < this.subSetCount; ++i) {
                this.subSetSizes[i] = singleSubSetSize;
            }
        }
        ArrayList<DataSet> subSets = new ArrayList<DataSet>();
        dataSet.shuffle();
        int inputSize = dataSet.getInputSize();
        int outputSize = dataSet.getOutputSize();
        int idxCounter = 0;
        for (int s = 0; s < this.subSetSizes.length; ++s) {
            DataSet newSubSet = new DataSet(inputSize, outputSize);
            if (!this.allowRepetition) {
                int itemCount = (int)((double)this.subSetSizes[s] / 100.0 * (double)dataSet.size());
                for (int i = 0; i < itemCount; ++i) {
                    newSubSet.addRow(dataSet.getRowAt(idxCounter));
                    ++idxCounter;
                }
            } else {
                Random rand = new Random();
                for (int i = 0; i < this.subSetSizes[s] / 100 * dataSet.size(); ++i) {
                    int randomIdx = rand.nextInt(dataSet.size());
                    newSubSet.addRow(dataSet.getRowAt(randomIdx));
                    ++idxCounter;
                }
            }
            subSets.add(newSubSet);
        }
        return subSets;
    }

    public boolean getAllowRepetition() {
        return this.allowRepetition;
    }

    public void setAllowRepetition(boolean allowRepetition) {
        this.allowRepetition = allowRepetition;
    }
}

