/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.StatementSpy;
import net.sf.log4jdbc.sql.resultsetcollector.DefaultResultSetCollector;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollector;

public class ResultSetSpy
implements ResultSet,
Spy {
    private final SpyLogDelegator log;
    private ResultSetCollector resultSetCollector = null;
    private ResultSet realResultSet;
    private StatementSpy parent;
    public static final String classTypeDescription = "ResultSet";

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    private void loadMetaDataIfNeeded() {
        if (this.resultSetCollector != null) {
            this.resultSetCollector.loadMetaDataIfNeeded(this.realResultSet);
        }
    }

    protected void reportAllReturns(String methodCall, Object returnValue, Object ... methodParams) {
        boolean finished;
        if (this.resultSetCollector != null && (finished = this.resultSetCollector.methodReturned(this, methodCall, returnValue, this.realResultSet, methodParams))) {
            this.log.resultSetCollected(this.resultSetCollector);
            this.resultSetCollector.reset();
        }
        String toString = "void";
        if (returnValue != null) {
            toString = returnValue.toString();
        }
        this.log.methodReturned(this, methodCall, toString);
    }

    public ResultSet getRealResultSet() {
        return this.realResultSet;
    }

    public void setResultSetCollector(ResultSetCollector resultSetCollector) {
        this.resultSetCollector = resultSetCollector;
    }

    public ResultSetSpy(StatementSpy parent, ResultSet realResultSet, SpyLogDelegator logDelegator) {
        if (realResultSet == null) {
            throw new IllegalArgumentException("Must provide a non null real ResultSet");
        }
        this.realResultSet = realResultSet;
        this.parent = parent;
        this.log = logDelegator;
        if (this.log.isResultSetCollectionEnabled()) {
            this.resultSetCollector = new DefaultResultSetCollector(this.log.isResultSetCollectionEnabledWithUnreadValueFillIn());
        }
        this.reportReturn("new ResultSet", "", realResultSet);
    }

    @Override
    public String getClassType() {
        return classTypeDescription;
    }

    @Override
    public Integer getConnectionNumber() {
        return this.parent.getConnectionNumber();
    }

    protected <T> T reportReturn(String methodCall, T returnValue, Object ... args) {
        this.reportAllReturns(methodCall, returnValue, args);
        return returnValue;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public int getRow() throws SQLException {
        String methodCall = "getRow()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRow(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        String methodCall = "cancelRowUpdates()";
        try {
            this.realResultSet.cancelRowUpdates();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTime(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        String methodCall = "getTime(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTime(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTime(columnIndex, cal), columnIndex, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTime(columnName, cal), columnName, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        String methodCall = "absolute(" + row + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.absolute(row), row);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnIndex, cal), columnIndex, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnName, cal), columnName, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        String methodCall = "moveToInsertRow()";
        try {
            this.realResultSet.moveToInsertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        String methodCall = "relative(" + rows + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.relative(rows), rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        String methodCall = "previous()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.previous(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        String methodCall = "moveToCurrentRow()";
        try {
            this.realResultSet.moveToCurrentRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        String methodCall = "getRef(" + i + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRef(i), i);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateRef(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        String methodCall = "getRef(" + colName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRef(colName), colName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateRef(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        String methodCall = "getBlob(" + i + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBlob(i), i);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBlob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        String methodCall = "getBlob(" + colName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBlob(colName), colName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBlob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        String methodCall = "getClob(" + i + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getClob(i), i);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateClob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        String methodCall = "getClob(" + colName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getClob(colName), colName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateClob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String methodCall = "getBoolean(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBoolean(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        String methodCall = "getBoolean(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBoolean(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        String methodCall = "getArray(" + i + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getArray(i), i);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateArray(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        String methodCall = "getArray(" + colName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getArray(colName), colName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateArray(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        String methodCall = "getRowId(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRowId(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        String methodCall = "getRowId(" + columnLabel + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRowId(columnLabel), columnLabel);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        String methodCall = "updateRowId(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateRowId(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        String methodCall = "updateRowId(" + columnLabel + ", " + x + ")";
        try {
            this.realResultSet.updateRowId(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodCall = "getHoldability()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getHoldability(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isClosed(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        String methodCall = "updateNString(" + columnIndex + ", " + nString + ")";
        try {
            this.realResultSet.updateNString(columnIndex, nString);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        String methodCall = "updateNString(" + columnLabel + ", " + nString + ")";
        try {
            this.realResultSet.updateNString(columnLabel, nString);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + nClob + ")";
        try {
            this.realResultSet.updateNClob(columnIndex, nClob);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + nClob + ")";
        try {
            this.realResultSet.updateNClob(columnLabel, nClob);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String methodCall = "getNClob(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNClob(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        String methodCall = "getNClob(" + columnLabel + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNClob(columnLabel), columnLabel);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String methodCall = "getSQLXML(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getSQLXML(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        String methodCall = "getSQLXML(" + columnLabel + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getSQLXML(columnLabel), columnLabel);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        String methodCall = "updateSQLXML(" + columnIndex + ", " + xmlObject + ")";
        try {
            this.realResultSet.updateSQLXML(columnIndex, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        String methodCall = "updateSQLXML(" + columnLabel + ", " + xmlObject + ")";
        try {
            this.realResultSet.updateSQLXML(columnLabel, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        String methodCall = "getNString(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNString(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String methodCall = "getNString(" + columnLabel + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNString(columnLabel), columnLabel);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        String methodCall = "getNCharacterStream(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNCharacterStream(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        String methodCall = "getNCharacterStream(" + columnLabel + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getNCharacterStream(columnLabel), columnLabel);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateNCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnLabel + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnLabel + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + inputStream + ", " + length + ")";
        try {
            this.realResultSet.updateBlob(columnIndex, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        String methodCall = "updateBlob(" + columnLabel + ", " + inputStream + ", " + length + ")";
        try {
            this.realResultSet.updateBlob(columnLabel, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateClob(columnIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateClob(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateClob(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateNClob(columnIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateNClob(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnIndex + ", " + reader + ")";
        try {
            this.realResultSet.updateNCharacterStream(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnLabel + ", " + reader + ")";
        try {
            this.realResultSet.updateNCharacterStream(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnLabel + ", " + x + ")";
        try {
            this.realResultSet.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnLabel + ", " + x + ")";
        try {
            this.realResultSet.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnLabel + ", " + reader + ")";
        try {
            this.realResultSet.updateCharacterStream(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + inputStream + ")";
        try {
            this.realResultSet.updateBlob(columnIndex, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        String methodCall = "updateBlob(" + columnLabel + ", " + inputStream + ")";
        try {
            this.realResultSet.updateBlob(columnLabel, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + reader + ")";
        try {
            this.realResultSet.updateClob(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateClob(" + columnLabel + ", " + reader + ")";
        try {
            this.realResultSet.updateClob(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + reader + ")";
        try {
            this.realResultSet.updateNClob(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + reader + ")";
        try {
            this.realResultSet.updateNClob(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        String methodCall = "isBeforeFirst()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isBeforeFirst(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String methodCall = "getShort(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getShort(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        String methodCall = "getShort(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getShort(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String methodCall = "getInt(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getInt(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        String methodCall = "getInt(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getInt(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.loadMetaDataIfNeeded();
            this.realResultSet.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getMetaData(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getType() throws SQLException {
        String methodCall = "getType()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getType(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String methodCall = "getDouble(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDouble(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        String methodCall = "getDouble(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDouble(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        String methodCall = "deleteRow()";
        try {
            this.realResultSet.deleteRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public int getConcurrency() throws SQLException {
        String methodCall = "getConcurrency()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getConcurrency(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        String methodCall = "rowUpdated()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowUpdated(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDate(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        String methodCall = "getDate(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDate(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDate(columnIndex, cal), columnIndex, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDate(columnName, cal), columnName, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean last() throws SQLException {
        String methodCall = "last()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.last(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        String methodCall = "rowInserted()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowInserted(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        String methodCall = "rowDeleted()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowDeleted(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        String methodCall = "updateNull(" + columnIndex + ")";
        try {
            this.realResultSet.updateNull(columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        String methodCall = "updateNull(" + columnName + ")";
        try {
            this.realResultSet.updateNull(columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        String methodCall = "updateShort(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateShort(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        String methodCall = "updateShort(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateShort(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBoolean(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBoolean(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateByte(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateByte(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        String methodCall = "updateInt(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateInt(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        String methodCall = "updateInt(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateInt(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        String methodCall = "getObject(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        String methodCall = "getObject(" + colName + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(colName, map), colName, map);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean next() throws SQLException {
        String methodCall = "next()";
        try {
            if (this.resultSetCollector != null) {
                this.resultSetCollector.preMethod(this, methodCall, null);
            }
            return this.reportReturn(methodCall, this.realResultSet.next(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        String methodCall = "updateLong(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateLong(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        String methodCall = "updateLong(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateLong(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateFloat(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateFloat(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateDouble(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateDouble(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public Statement getStatement() throws SQLException {
        String methodCall = "getStatement()";
        return this.reportReturn(methodCall, this.parent, new Object[0]);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnIndex, map), columnIndex, map);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        String methodCall = "updateString(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateString(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        String methodCall = "updateString(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateString(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String methodCall = "getAsciiStream(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getAsciiStream(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        String methodCall = "getAsciiStream(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getAsciiStream(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String methodCall = "getURL(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getURL(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBigDecimal(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        String methodCall = "getURL(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getURL(columnName), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBytes(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBytes(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getUnicodeStream(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getUnicodeStream(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateDate(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateDate(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public int getFetchSize() throws SQLException {
        String methodCall = "getFetchSize()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFetchSize(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getWarnings(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String methodCall = "getBinaryStream(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBinaryStream(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        String methodCall = "getBinaryStream(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBinaryStream(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.realResultSet.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateTimestamp(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateTimestamp(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public boolean first() throws SQLException {
        String methodCall = "first()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.first(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        String methodCall = "getCursorName()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getCursorName(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        String methodCall = "findColumn(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.findColumn(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        String methodCall = "wasNull()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.wasNull(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String methodCall = "getString(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getString(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        String methodCall = "getString(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getString(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String methodCall = "getCharacterStream(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getCharacterStream(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        String methodCall = "getCharacterStream(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getCharacterStream(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String methodCall = "setFetchDirection(" + direction + ")";
        try {
            this.realResultSet.setFetchDirection(direction);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnName + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String methodCall = "getByte(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getByte(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        String methodCall = "getByte(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getByte(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateTime(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateTime(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String methodCall = "getBytes(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBytes(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        String methodCall = "getBytes(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBytes(columnName), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        String methodCall = "isAfterLast()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isAfterLast(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ", " + scale + ")";
        try {
            this.realResultSet.updateObject(columnIndex, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateObject(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ", " + scale + ")";
        try {
            this.realResultSet.updateObject(columnName, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateObject(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        String methodCall = "getFetchDirection()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFetchDirection(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String methodCall = "getLong(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getLong(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        String methodCall = "getLong(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getLong(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        String methodCall = "isFirst()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isFirst(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        String methodCall = "insertRow()";
        try {
            this.realResultSet.insertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String methodCall = "getFloat(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, Float.valueOf(this.realResultSet.getFloat(columnIndex)), columnIndex).floatValue();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        String methodCall = "getFloat(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, Float.valueOf(this.realResultSet.getFloat(columnName)), columnName).floatValue();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        String methodCall = "isLast()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isLast(), null);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String methodCall = "setFetchSize(" + rows + ")";
        try {
            this.realResultSet.setFetchSize(rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void updateRow() throws SQLException {
        String methodCall = "updateRow()";
        try {
            this.realResultSet.updateRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void beforeFirst() throws SQLException {
        String methodCall = "beforeFirst()";
        try {
            this.realResultSet.beforeFirst();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ", " + scale + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnIndex, scale), columnIndex, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ", " + scale + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnName, scale), columnName, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnIndex), columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnName), columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        String methodCall = "afterLast()";
        try {
            this.realResultSet.afterLast();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall, null, new Object[0]);
    }

    @Override
    public void refreshRow() throws SQLException {
        String methodCall = "refreshRow()";
        try {
            this.realResultSet.refreshRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == ResultSet.class || iface == Spy.class) ? this : this.realResultSet.unwrap(iface), new Object[0]);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == ResultSet.class || iface == Spy.class) || this.realResultSet.isWrapperFor(iface), new Object[0]);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + columnIndex + "," + type + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnIndex, type), new Object[0]);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + columnLabel + "," + type + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnLabel, type), new Object[0]);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

