/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.fixed.FixedSocksSelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import com.github.markusbernhardt.proxy.selector.whitelist.ProxyBypassListSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ProxyUtil {
    public static final int DEFAULT_PROXY_PORT = 80;
    private static List<Proxy> noProxyList;

    public static FixedProxySelector parseProxySettings(String proxyVar) {
        if (proxyVar == null || proxyVar.trim().length() == 0) {
            return null;
        }
        try {
            if (proxyVar.indexOf(":/") == -1) {
                proxyVar = "http://" + proxyVar;
            }
            URL url = new URL(proxyVar);
            String host = ProxyUtil.cleanIPv6(url.getHost());
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            return new FixedProxySelector(host.trim(), port);
        }
        catch (MalformedURLException e) {
            Logger.log(ProxyUtil.class, Logger.LogLevel.WARNING, "Cannot parse Proxy Settings {}", proxyVar);
            return null;
        }
    }

    public static synchronized List<Proxy> noProxyList() {
        if (noProxyList == null) {
            ArrayList<Proxy> list = new ArrayList<Proxy>(1);
            list.add(Proxy.NO_PROXY);
            noProxyList = Collections.unmodifiableList(list);
        }
        return noProxyList;
    }

    public static PacProxySelector buildPacSelectorForUrl(String url) {
        PacProxySelector result = null;
        UrlPacScriptSource pacSource = new UrlPacScriptSource(url);
        if (pacSource.isScriptValid()) {
            result = new PacProxySelector(pacSource);
        }
        return result;
    }

    public static String cleanIPv6(String hostOrIP) {
        if (hostOrIP == null) {
            return null;
        }
        if ((hostOrIP = hostOrIP.trim()).startsWith("[")) {
            hostOrIP = hostOrIP.substring(1);
        }
        if (hostOrIP.endsWith("]")) {
            hostOrIP = hostOrIP.substring(0, hostOrIP.length() - 1);
        }
        return hostOrIP;
    }

    public static ProxySelector setByPassListOnSelector(String bypassList, ProtocolDispatchSelector ps) {
        if (bypassList != null && bypassList.trim().length() > 0) {
            return new ProxyBypassListSelector(bypassList.replace(';', ','), (ProxySelector)ps);
        }
        return ps;
    }

    private static void addFallbackSelector(Properties settings, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty("default");
        if (proxy != null) {
            ps.setFallbackSelector(ProxyUtil.parseProxySettings(proxy));
        }
    }

    private static void addSelectorForProtocol(Properties settings, String protocol, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty(protocol);
        if (proxy != null) {
            FixedProxySelector protocolSelector = ProxyUtil.parseProxySettings(proxy);
            ps.setSelector(protocol, protocolSelector);
        }
    }

    public static Properties parseProxyList(String proxyString) {
        Properties p = new Properties();
        if (proxyString.indexOf(61) == -1) {
            p.setProperty("default", proxyString);
        } else {
            try {
                proxyString = proxyString.replace(';', '\n');
                p.load(new ByteArrayInputStream(proxyString.getBytes("ISO-8859-1")));
            }
            catch (IOException e) {
                Logger.log(ProxyUtil.class, Logger.LogLevel.ERROR, "Error reading IE settings as properties: {0}", e);
            }
        }
        return p;
    }

    public static ProtocolDispatchSelector buildProtocolDispatchSelector(Properties properties) {
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        ProxyUtil.addSelectorForProtocol(properties, "http", ps);
        ProxyUtil.addSelectorForProtocol(properties, "https", ps);
        ProxyUtil.addSelectorForProtocol(properties, "ftp", ps);
        ProxyUtil.addSelectorForProtocol(properties, "gopher", ps);
        ProxyUtil.addFallbackSelector(properties, ps);
        String socksProperties = properties.getProperty("socks");
        if (socksProperties != null) {
            String[] hostAndPort = socksProperties.split(":");
            String host = "";
            int port = 0;
            if (hostAndPort.length > 0) {
                host = hostAndPort[0];
            }
            if (hostAndPort.length > 1) {
                try {
                    port = Integer.parseInt(hostAndPort[1]);
                }
                catch (NumberFormatException e) {
                    Logger.log(ProxyUtil.class, Logger.LogLevel.WARNING, "Cannot parse SOCKS proxy port {0}", hostAndPort[1]);
                }
            }
            ps.setFallbackSelector(new FixedSocksSelector(host, port));
        }
        return ps;
    }
}

