/*
 * Decompiled with CFR 0.152.
 */
package de.root1.rxtxrebundled;

import de.root1.rxtxrebundled.NativeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LibLoader {
    private static final String LIBLOADER_VERSION = "2.2";
    private static final List<String> loadedLibs = new ArrayList<String>();

    private static void logStdOut(String msg) {
        String property = System.getProperty("rxtx.rebundled.debug", "false");
        boolean log = Boolean.parseBoolean(property);
        if (log) {
            System.out.println(msg);
        }
    }

    private static void logStdErr(String msg) {
        String property = System.getProperty("rxtx.rebundled.suppress_error", "false");
        boolean suppress = Boolean.parseBoolean(property);
        if (!suppress) {
            System.err.println(msg);
        }
    }

    private static void logExceptionToStdErr(Exception ex) {
        String property = System.getProperty("rxtx.rebundled.suppress_error", "false");
        boolean suppress = Boolean.parseBoolean(property);
        if (!suppress) {
            ex.printStackTrace();
        }
    }

    public static void loadLibrary(String name) {
        LibLoader.logStdOut("Trying to load '" + name + "' ...");
        if (loadedLibs.contains(name)) {
            LibLoader.logStdOut("Library is already loaded: '" + name + "' ...");
            return;
        }
        String libraryPath = LibLoader.prepareLibraryPath();
        if (libraryPath == null) {
            LibLoader.logStdErr("The required library is not available for your system!");
            return;
        }
        LibLoader.logStdOut("Try to load library from path: " + libraryPath);
        try {
            NativeUtils.loadLibraryFromJar(libraryPath, LIBLOADER_VERSION);
        }
        catch (IOException e1) {
            LibLoader.logStdErr("Load native library failed: " + libraryPath);
            LibLoader.logExceptionToStdErr(e1);
            throw new RuntimeException(e1);
        }
        loadedLibs.add(name);
        LibLoader.logStdOut("...*done*");
    }

    private static String prepareLibraryPath() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        LibLoader.logStdOut("os.name='" + osName + "'");
        LibLoader.logStdOut("os.arch='" + osArch + "'");
        String libraryPath = null;
        if (osName.toLowerCase().contains("linux")) {
            libraryPath = osArch.toLowerCase().contains("amd64") || osArch.toLowerCase().contains("x86_64") ? "/rxtx/linux/x86_64/librxtxSerial64.so" : (osArch.toLowerCase().equals("arm") ? "/rxtx/linux/arm/librxtxSerial.so" : "/rxtx/linux/i386/librxtxSerial.so");
        } else if (osName.toLowerCase().contains("windows")) {
            libraryPath = osArch.toLowerCase().contains("amd64") || osArch.toLowerCase().contains("x86_64") ? "/rxtx/windows/x86_64/rxtxSerial64.dll" : "/rxtx/windows/x86/rxtxSerial.dll";
        } else if (osName.toLowerCase().contains("os x")) {
            libraryPath = osArch.toLowerCase().contains("amd64") || osArch.toLowerCase().contains("x86_64") ? "/rxtx/mac/librxtxSerial64.jnilib" : "/rxtx/mac/librxtxSerial.jnilib";
        } else {
            LibLoader.logStdErr("Sorry, platform '" + osName + "' currently not supported by LibLoader. Please use -Djava.library.path=<insert path to native libs here> as JVM parameter...");
        }
        LibLoader.logStdOut("Prepared library path: " + libraryPath);
        return libraryPath;
    }
}

