/*
 * Decompiled with CFR 0.152.
 */
package de.root1.rxtxrebundled;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NativeUtils {
    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path, String version) throws IOException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (version != null) {
            prefix = prefix + version;
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeUtils.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        System.load(temp.getAbsolutePath());
        final String libraryPrefix = prefix;
        String lockSuffix = ".lock";
        File lock = new File(temp.getAbsolutePath() + ".lock");
        lock.createNewFile();
        lock.deleteOnExit();
        FileFilter tmpDirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(libraryPrefix) && !pathname.getName().endsWith(".lock");
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] tmpFiles = tmpDir.listFiles(tmpDirFilter);
        for (int i = 0; i < tmpFiles.length; ++i) {
            File lockFile = new File(tmpFiles[i].getAbsolutePath() + ".lock");
            if (lockFile.exists()) continue;
            NativeUtils.logStdOut("deleting: " + tmpFiles[i].getAbsolutePath());
            tmpFiles[i].delete();
        }
    }

    private static void logStdOut(String msg) {
        String property = System.getProperty("rxtx.rebundled.debug", "false");
        boolean log = Boolean.parseBoolean(property);
        if (log) {
            System.out.println(msg);
        }
    }
}

