/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.ParallelPort;
import gnu.io.ParallelPortEvent;
import gnu.io.ParallelPortEventListener;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class LPRPort
extends ParallelPort {
    private static final boolean debug = false;
    private int fd;
    private final ParallelOutputStream out = new ParallelOutputStream();
    private final ParallelInputStream in = new ParallelInputStream();
    private int lprmode = 0;
    private int timeout = 0;
    private int threshold = 1;
    private ParallelPortEventListener PPEventListener;
    private MonitorThread monThread;

    private static native void Initialize();

    public LPRPort(String name) throws PortInUseException {
        this.fd = this.open(name);
        this.name = name;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public int getMode() {
        return this.lprmode;
    }

    @Override
    public int setMode(int mode) throws UnsupportedCommOperationException {
        try {
            this.setLPRMode(mode);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return -1;
        }
        this.lprmode = mode;
        return 0;
    }

    @Override
    public void restart() {
        System.out.println("restart() is not implemented");
    }

    @Override
    public void suspend() {
        System.out.println("suspend() is not implemented");
    }

    public native boolean setLPRMode(int var1) throws UnsupportedCommOperationException;

    @Override
    public native boolean isPaperOut();

    @Override
    public native boolean isPrinterBusy();

    @Override
    public native boolean isPrinterError();

    @Override
    public native boolean isPrinterSelected();

    @Override
    public native boolean isPrinterTimedOut();

    private native void nativeClose();

    @Override
    public synchronized void close() {
        if (this.fd < 0) {
            return;
        }
        this.nativeClose();
        super.close();
        this.removeEventListener();
        this.fd = 0;
        Runtime.getRuntime().gc();
    }

    @Override
    public void enableReceiveFraming(int f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    @Override
    public void disableReceiveFraming() {
    }

    @Override
    public boolean isReceiveFramingEnabled() {
        return false;
    }

    @Override
    public int getReceiveFramingByte() {
        return 0;
    }

    @Override
    public void enableReceiveTimeout(int t) {
        this.timeout = t > 0 ? t : 0;
    }

    @Override
    public void disableReceiveTimeout() {
        this.timeout = 0;
    }

    @Override
    public boolean isReceiveTimeoutEnabled() {
        return this.timeout > 0;
    }

    @Override
    public int getReceiveTimeout() {
        return this.timeout;
    }

    @Override
    public void enableReceiveThreshold(int t) {
        this.threshold = t > 1 ? t : 1;
    }

    @Override
    public void disableReceiveThreshold() {
        this.threshold = 1;
    }

    @Override
    public int getReceiveThreshold() {
        return this.threshold;
    }

    @Override
    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 1;
    }

    @Override
    public native void setInputBufferSize(int var1);

    @Override
    public native int getInputBufferSize();

    @Override
    public native void setOutputBufferSize(int var1);

    @Override
    public native int getOutputBufferSize();

    @Override
    public native int getOutputBufferFree();

    protected native void writeByte(int var1) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    protected native void drain() throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public boolean checkMonitorThread() {
        if (this.monThread != null) {
            return this.monThread.isInterrupted();
        }
        return true;
    }

    public synchronized boolean sendEvent(int event, boolean state) {
        if (this.fd == 0 || this.PPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (event) {
            case 2: {
                if (this.monThread.monBuffer) break;
                return false;
            }
            case 1: {
                if (this.monThread.monError) break;
                return false;
            }
            default: {
                System.err.println("unknown event:" + event);
                return false;
            }
        }
        ParallelPortEvent e = new ParallelPortEvent(this, event, !state, state);
        if (this.PPEventListener != null) {
            this.PPEventListener.parallelEvent(e);
        }
        if (this.fd == 0 || this.PPEventListener == null || this.monThread == null) {
            return true;
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exc) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized void addEventListener(ParallelPortEventListener lsnr) throws TooManyListenersException {
        if (this.PPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.PPEventListener = lsnr;
        this.monThread = new MonitorThread();
        this.monThread.setDaemon(true);
        this.monThread.start();
    }

    @Override
    public synchronized void removeEventListener() {
        this.PPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    @Override
    public synchronized void notifyOnError(boolean enable) {
        System.out.println("notifyOnError is not implemented yet");
        this.monThread.monError = enable;
    }

    @Override
    public synchronized void notifyOnBuffer(boolean enable) {
        System.out.println("notifyOnBuffer is not implemented yet");
        this.monThread.monBuffer = enable;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        RXTXVersion.loadLibrary("rxtxParallel");
        LPRPort.Initialize();
    }

    class MonitorThread
    extends Thread {
        private boolean monError = false;
        private boolean monBuffer = false;

        MonitorThread() {
        }

        @Override
        public void run() {
            LPRPort.this.eventLoop();
            MonitorThread.yield();
        }
    }

    class ParallelInputStream
    extends InputStream {
        ParallelInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readByte();
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(b, off, len);
        }

        @Override
        public int available() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.nativeavailable();
        }
    }

    class ParallelOutputStream
    extends OutputStream {
        ParallelOutputStream() {
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeByte(b);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(b, 0, b.length);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(b, off, len);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
        }
    }
}

