package org.bidib.jbidibc.usbstickbasis.adapter;

import org.bidib.jbidibc.messages.message.BidibMessageInterface;

public interface UsbStickBasisResponseInterface {

    /**
     * Add log message.
     * 
     * @param message
     *            the log message
     */
    void addLog(String message);

    /**
     * Publish the response.
     * 
     * @param bidibMessage
     *            the message
     */
    void publishReponse(final BidibMessageInterface bidibMessage);

    /**
     * Publish the product name.
     * 
     * @param productName
     *            the product name
     */
    void publishProductName(String productName);

    /**
     * @return the selected car model
     */
    SelectedCar getSelectedCarModel();

    /**
     * Publish the POM repeat value.
     * 
     * @param pomRepeat
     *            the pom repeat value
     */
    void publishPomRepeat(int pomRepeat);
}
