/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.usbstickbasis;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.message.BidibRequestFactoryMessageMapInitializer;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureGetMessage;
import org.bidib.jbidibc.messages.message.FeatureNotAvailableResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeatureSetMessage;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.StringGetMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.StringSetMessage;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorEnableMessage;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.VendorSetMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.bidib.jbidibc.usbstickbasis.UsbStickBasisMessageReceiver;
import org.bidib.jbidibc.usbstickbasis.adapter.SelectedCar;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisAdapter;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisModel;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisResponseInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbStickBasisBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsbStickBasisBidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private UsbStickBasisAdapter usbStickBasisAdapter;
    private UsbStickBasisModel usbStickBasisModel;
    private UsbStickBasisResponseInterface responseInterface;
    private boolean firstPacketSent = false;
    protected String requestedPortName;
    private final SelectedCar selectedCar = new SelectedCar();
    private boolean initialResetSkipped;
    private long uniqueId = 24769853994832436L;
    private ProtocolVersion protocolVersion = new ProtocolVersion(0, 8);
    private SoftwareVersion softwareVersion = new SoftwareVersion(1, 0, 0);
    private String[] stringValue = new String[]{"", ""};
    private int sendNum;
    private int currentFeature;
    private SortedSet<Feature> features = new TreeSet<Feature>();
    private org.bidib.jbidibc.core.message.BidibRequestFactory requestFactory;
    private Object responseMessageLock = new Object();
    private UsbStickConnector connector;
    private ByteArrayOutputStream sendBuffer = new ByteArrayOutputStream(100);
    private static final int SLEEP_BETWEEN_FUNCTIONS = 10;

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of UsbStickBasisBidib.");
        UsbStickBasisBidib instance = new UsbStickBasisBidib();
        instance.initialize(context);
        return instance;
    }

    public void initialize(Context context) {
        super.initialize(context);
        this.features.add(new Feature(252, 24));
        this.features.add(new Feature(253, 16));
        this.connector = new UsbStickConnector();
        MessageReceiver messageReceiver = this.getMessageReceiver();
        this.connector.setMessageReceiver(messageReceiver);
        this.initializeConnector(this.connector);
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        super.setConnectionListener(connectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open the port, portName: {}, connectionListener: {}", (Object)portName, (Object)connectionListener);
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        this.requestedPortName = portName;
        this.requestFactory = new org.bidib.jbidibc.core.message.BidibRequestFactory();
        this.requestFactory.initialize();
        BidibRequestFactoryMessageMapInitializer.loadMessageTypeMap((BidibRequestFactory)this.requestFactory);
        this.usbStickBasisModel = new UsbStickBasisModel();
        this.usbStickBasisModel.setBaudRate(19200);
        this.usbStickBasisModel.setSelectedPort(portName);
        final Object startupLock = new Object();
        this.responseInterface = new UsbStickBasisResponseInterface(){

            @Override
            public void addLog(String message) {
                LOGGER.info("Received log message: {}", (Object)message.trim());
            }

            @Override
            public void publishReponse(BidibMessageInterface bidibMessage) {
                LOGGER.info("Publish response: {}", (Object)bidibMessage);
                if (bidibMessage instanceof SysSwVersionResponse) {
                    SysSwVersionResponse sysSwVersionResponse = (SysSwVersionResponse)bidibMessage;
                    UsbStickBasisBidib.this.setSoftwareVersion(sysSwVersionResponse.getVersion().toString());
                }
                UsbStickBasisBidib.this.prepareMessage(bidibMessage);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publishProductName(String productName) {
                LOGGER.info("Publish productName: {}", (Object)productName);
                if (StringUtils.isNotBlank((CharSequence)productName)) {
                    UsbStickBasisBidib.this.setProductName(productName);
                }
                Object object = startupLock;
                synchronized (object) {
                    startupLock.notifyAll();
                }
            }

            @Override
            public SelectedCar getSelectedCarModel() {
                return UsbStickBasisBidib.this.selectedCar;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publishPomRepeat(int pomRepeat) {
                LOGGER.info("Publish the POM repeat: {}", (Object)pomRepeat);
                UsbStickBasisBidib.this.setPomRepeat(pomRepeat);
                Object object = startupLock;
                synchronized (object) {
                    startupLock.notifyAll();
                }
            }
        };
        try {
            this.usbStickBasisAdapter = new UsbStickBasisAdapter(this.responseInterface, this.usbStickBasisModel);
            this.usbStickBasisAdapter.openConnection(portName, "rxtx");
        }
        catch (PortNotFoundException | PortNotOpenedException ex) {
            LOGGER.warn("Open connection to USB stick basis failed.", ex);
            throw new PortNotOpenedException("Open connection to USB stick basis failed.", ex);
        }
        LOGGER.info("Opened the connection to the USB Stick Basis.");
        this.connector.startReceiverAndQueues(this.getMessageReceiver(), context);
        try {
            this.usbStickBasisAdapter.clearReceiveBuffer();
            LOGGER.info("Query the info from the usbStickBasis.");
            this.usbStickBasisAdapter.transmit("info");
            Thread.sleep(1000L);
            this.usbStickBasisAdapter.transmit("CP");
        }
        catch (Exception ex) {
            LOGGER.warn("Send 'help' to USB stick basis failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Wait for the startupLock.");
            Object ex = startupLock;
            synchronized (ex) {
                startupLock.wait(2000L);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Wait for notify startup lock was interrupted.", (Throwable)ex);
        }
        if (this.getConnectionListener() != null) {
            LOGGER.info("Notify that the port was opened: {}", (Object)this.requestedPortName);
            this.getConnectionListener().opened(this.requestedPortName);
        }
    }

    protected void setProductName(String productName) {
        LOGGER.info("Set the product name: {}", (Object)productName);
        this.stringValue[0] = productName;
    }

    protected void setSoftwareVersion(String softwareVersion) {
        LOGGER.info("Set the software version: {}", (Object)softwareVersion);
        this.softwareVersion = SoftwareVersion.parse((String)softwareVersion);
    }

    protected void setPomRepeat(int pomRepeat) {
        LOGGER.info("Set the pomRepeat: {}", (Object)pomRepeat);
        try {
            LOGGER.info("Set the FEATURE_GEN_POM_REPEAT: {}", (Object)pomRepeat);
            this.features.add(new Feature(106, pomRepeat));
        }
        catch (Exception ex) {
            LOGGER.warn("Set the feature POM repeat failed.", (Throwable)ex);
        }
    }

    public boolean isOpened() {
        return this.usbStickBasisAdapter != null;
    }

    public void close() {
        LOGGER.info("Close is called, usbStickBasisAdapter: {}", (Object)this.usbStickBasisAdapter);
        if (this.connector.close()) {
            super.close();
            this.requestedPortName = null;
            this.cleanupAfterClose(null);
        }
        LOGGER.info("Close the port finished.");
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    protected MessageReceiver createMessageReceiver(NodeRegistry nodeRegistry, RawMessageListener rawMessageListener, Context context) {
        BidibResponseFactory responseFactory = new BidibResponseFactory();
        responseFactory.initialize();
        UsbStickBasisMessageReceiver messageReceiver = new UsbStickBasisMessageReceiver(nodeRegistry, (ResponseFactory)responseFactory, true);
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        LOGGER.info("Get the root node into the registry.");
        nodeRegistry.getRootNode();
        return messageReceiver;
    }

    protected void cleanupAfterClose(MessageReceiver messageReceiver) {
        this.releaseRootNode();
        this.firstPacketSent = false;
        InvalidConfigurationException ice = null;
        if (messageReceiver instanceof SerialMessageReceiver) {
            SerialMessageReceiver serialMessageReceiver = (SerialMessageReceiver)messageReceiver;
            serialMessageReceiver.clearMessageListeners();
            serialMessageReceiver.clearNodeListeners();
            LOGGER.info("Purge the received data in the message buffer.");
            try {
                serialMessageReceiver.purgeReceivedDataInBuffer();
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Purge output stream has signaled an error.", (Throwable)ex);
                if ("debug-interface-active".equals(ex.getReason())) {
                    ice = ex;
                }
            }
        } else {
            LOGGER.warn("No message receiver to purge received data buffer available.");
        }
        if (this.getConnectionListener() != null) {
            LOGGER.info("Notify that the port was closed: {}", (Object)this.requestedPortName);
            this.getConnectionListener().closed(this.requestedPortName);
        } else {
            LOGGER.info("No connection listener available to publish the closed report for port: {}", (Object)this.requestedPortName);
        }
        this.requestedPortName = null;
        super.cleanupAfterClose(messageReceiver);
        if (ice != null) {
            LOGGER.warn("Signal the invalid configuration exception to the caller.");
            throw ice;
        }
    }

    protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
        if (!this.firstPacketSent) {
            LOGGER.info("Send initial sequence.");
            try {
                byte[] initialSequence = new byte[]{ByteUtils.MAGIC};
                ByteArrayOutputStream firstPacketSendBuffer = new ByteArrayOutputStream(20);
                firstPacketSendBuffer.write(initialSequence);
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)firstPacketSendBuffer));
                }
                this.connector.sendData(firstPacketSendBuffer, rawMessageListener);
                Thread.sleep(10L);
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)firstPacketSendBuffer));
                }
                this.connector.sendData(firstPacketSendBuffer, rawMessageListener);
                this.firstPacketSent = true;
                LOGGER.info("Send initial sequence passed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Send initial sequence failed.", (Throwable)ex);
            }
        }
        this.connector.sendData(data, rawMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareMessage(BidibMessageInterface message) {
        Object object = this.responseMessageLock;
        synchronized (object) {
            message.setSendMsgNum(this.getNextResponseSendNum());
            this.publishResponse(message.getContent());
        }
    }

    protected void publishResponse(byte[] content) {
        LOGGER.info("Publish response: {}", (Object)ByteUtils.bytesToHex((byte[])content));
        this.connector.doReceive(content, content.length);
    }

    protected byte[] processRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 1: {
                response = this.processSysGetMagicRequest(bidibMessage);
                break;
            }
            case 24: {
                this.processSysClockRequest(bidibMessage);
                break;
            }
            case 2: {
                response = this.processSysGetPVersionRequest(bidibMessage);
                break;
            }
            case 6: {
                response = this.processSysGetSwVersionRequest(bidibMessage);
                break;
            }
            case 3: {
                this.processSysEnableRequest(bidibMessage);
                break;
            }
            case 4: {
                this.processSysDisableRequest(bidibMessage);
                break;
            }
            case 5: {
                response = this.processSysGetUniqueIdRequest(bidibMessage);
                break;
            }
            case 98: {
                response = this.processCsSetStateRequest(bidibMessage);
                break;
            }
            case 103: {
                response = this.processCsPomRequest(bidibMessage);
                break;
            }
            case 100: {
                response = this.processCsDriveRequest(bidibMessage);
                break;
            }
            case 106: {
                response = this.processCsQueryRequest(bidibMessage);
                break;
            }
            case 18: {
                response = this.processFeatureGetRequest(bidibMessage);
                break;
            }
            case 19: {
                response = this.processFeatureSetRequest(bidibMessage);
                break;
            }
            case 16: {
                response = this.processFeatureGetAllRequest(bidibMessage);
                break;
            }
            case 17: {
                response = this.processFeatureGetNextRequest(bidibMessage);
                break;
            }
            case 20: {
                response = this.processVendorEnableRequest(bidibMessage);
                break;
            }
            case 21: {
                response = this.processVendorDisableRequest(bidibMessage);
                break;
            }
            case 22: {
                response = this.processVendorSetRequest(bidibMessage);
                break;
            }
            case 23: {
                response = this.processVendorGetRequest(bidibMessage);
                break;
            }
            case 26: {
                response = this.processStringSetRequest(bidibMessage);
                break;
            }
            case 25: {
                response = this.processStringGetRequest(bidibMessage);
                break;
            }
            case 9: {
                this.processResetRequest(bidibMessage);
                break;
            }
            default: {
                LOGGER.warn("Unprocessed bidibMessage: {}", (Object)bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processSysGetUniqueIdRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetUniqueId request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            SysUniqueIdResponse sysUniqueIdResponse = new SysUniqueIdResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), this.getUniqueId());
            response = sysUniqueIdResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysUniqueId response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processSysGetPVersionRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetPVersion request: {}, do nothing ...", (Object)bidibMessage);
        byte[] response = null;
        try {
            LOGGER.info("Current protocolVersion: {}", (Object)this.protocolVersion);
            SysPVersionResponse sysPVersionResponse = new SysPVersionResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), this.protocolVersion.getMajorVersion(), this.protocolVersion.getMinorVersion());
            response = sysPVersionResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysPVersion response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processSysGetSwVersionRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetSwVersion request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LOGGER.info("Current softwareVersion: {}", (Object)this.softwareVersion);
            SysSwVersionResponse sysSwVersionResponse = new SysSwVersionResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), this.softwareVersion.asByteArray());
            response = sysSwVersionResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysSwVersion response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processSysEnableRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysEnable request: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processSysDisableRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysDisable request: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processSysIdentifyRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysIdentify request: {}", (Object)bidibMessage);
    }

    protected byte[] processSysGetMagicRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            LOGGER.info("Reset the sendNum because the SYS_MAGIC is tranferred with 0.");
            this.resetSendNum();
            SysMagicResponse magicResponse = new SysMagicResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), new byte[]{-2, -81});
            response = magicResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create magic response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processSysClockRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysClockMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected byte[] processCsSetStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsSetState request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationSetStateMessage commandStationSetStateMessage = (CommandStationSetStateMessage)bidibMessage;
            CommandStationState state = commandStationSetStateMessage.getState();
            LOGGER.info("The requested command station state is: {}", (Object)state);
            String commandStationStateCommand = null;
            switch (state) {
                case OFF: {
                    commandStationStateCommand = "S 0";
                    break;
                }
                case STOP: 
                case SOFTSTOP: {
                    commandStationStateCommand = "S 0";
                    break;
                }
                case GO: 
                case GO_IGN_WD: {
                    commandStationStateCommand = "S 1";
                    break;
                }
                case PROG: {
                    break;
                }
                case QUERY: {
                    LOGGER.info("Query command station state requested");
                    commandStationStateCommand = "S";
                    break;
                }
                default: {
                    LOGGER.warn("Unprocessed command station state: {}", (Object)state);
                }
            }
            if (commandStationStateCommand != null) {
                this.usbStickBasisAdapter.transmit(commandStationStateCommand);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Create CommandStationState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsDriveRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsDrive request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Integer fVal;
            Integer fKey;
            int newVal;
            int functions;
            CommandStationDriveMessage commandStationDriveMessage = (CommandStationDriveMessage)bidibMessage;
            AddressData addressData = commandStationDriveMessage.getDecoderAddress();
            int speed = commandStationDriveMessage.getSpeed();
            int activeOutputBits = commandStationDriveMessage.getOutputActiveBits();
            LOGGER.info("Received addressData: {}, speed: {}, activeOutputBits: {}", new Object[]{addressData, speed, activeOutputBits});
            Integer currentAddress = this.selectedCar.getDecoderAddress();
            if (currentAddress == null || addressData.getAddress() != currentAddress.intValue()) {
                currentAddress = addressData.getAddress();
                LOGGER.info("Updated the decoder address: {}", (Object)currentAddress);
                this.selectedCar.setDecoderAddress(currentAddress);
            } else {
                currentAddress = null;
            }
            if ((activeOutputBits & 1) == 1) {
                String speedCommand = "A " + addressData.getAddress() + "," + speed;
                LOGGER.info("Prepared speed command: {}", (Object)speedCommand);
                this.usbStickBasisAdapter.transmit(speedCommand);
                Thread.sleep(10L);
            } else if (currentAddress != null) {
                String addressCommand = "A " + currentAddress;
                this.usbStickBasisAdapter.transmit(addressCommand);
                Thread.sleep(10L);
            }
            Map<Integer, Integer> functionMap = this.selectedCar.getFunctionMap();
            LOGGER.info("Current functionMap: {}", functionMap);
            if ((activeOutputBits & 2) == 2) {
                functions = commandStationDriveMessage.getFunctionBits()[0];
                String functionCommand = null;
                newVal = (functions & 0x10) >> 4;
                fKey = 0;
                fVal = functionMap.get(fKey);
                LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                if (fVal == null || fVal != newVal) {
                    functionCommand = "F 0," + newVal;
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
                for (int bit = 3; bit > -1; --bit) {
                    newVal = (functions & 1 << bit) >> bit;
                    fKey = bit + 1;
                    fVal = functionMap.get(fKey);
                    LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                    if (fVal != null && fVal == newVal) continue;
                    functionCommand = "F " + fKey + "," + newVal;
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
            }
            if ((activeOutputBits & 4) == 4) {
                functions = commandStationDriveMessage.getFunctionBits()[1];
                for (int bit = 0; bit < 4; ++bit) {
                    newVal = (functions & 1 << bit) >> bit;
                    fKey = bit + 5;
                    fVal = functionMap.get(fKey);
                    LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                    if (fVal != null && fVal == newVal) continue;
                    String functionCommand = "F " + (bit + 5) + "," + ((functions & 1 << bit) >> bit);
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
            }
            if ((activeOutputBits & 8) == 8) {
                functions = commandStationDriveMessage.getFunctionBits()[0];
                for (int bit = 4; bit < 8; ++bit) {
                    newVal = (functions & 1 << bit) >> bit;
                    fKey = bit + 9;
                    fVal = functionMap.get(fKey);
                    LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                    if (fVal != null && fVal == newVal) continue;
                    String functionCommand = "F " + (bit + 9) + "," + ((functions & 1 << bit) >> bit);
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
            }
            if ((activeOutputBits & 0x10) == 16) {
                functions = commandStationDriveMessage.getFunctionBits()[2];
                for (int bit = 0; bit < 8; ++bit) {
                    newVal = (functions & 1 << bit) >> bit;
                    fKey = bit + 13;
                    fVal = functionMap.get(fKey);
                    LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                    if (fVal != null && fVal == newVal) continue;
                    String functionCommand = "F " + (bit + 13) + "," + ((functions & 1 << bit) >> bit);
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
            }
            if ((activeOutputBits & 0x20) == 32) {
                functions = commandStationDriveMessage.getFunctionBits()[3];
                for (int bit = 0; bit < 8; ++bit) {
                    newVal = (functions & 1 << bit) >> bit;
                    fKey = bit + 21;
                    fVal = functionMap.get(fKey);
                    LOGGER.info("Current newVal: {}, fKey: {}, fVal: {}", new Object[]{newVal, fKey, fVal});
                    if (fVal != null && fVal == newVal) continue;
                    String functionCommand = "F " + (bit + 21) + "," + ((functions & 1 << bit) >> bit);
                    this.usbStickBasisAdapter.transmit(functionCommand);
                    functionMap.put(fKey, newVal);
                    Thread.sleep(10L);
                }
            }
            CommandStationDriveAcknowledgeResponse commandStationDriveAckResponse = new CommandStationDriveAcknowledgeResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), addressData, 1, null);
            response = commandStationDriveAckResponse.getContent();
        }
        catch (InterruptedException | ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", ex);
        }
        return response;
    }

    protected byte[] processCsQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationQueryMessage commandStationQueryMessage = (CommandStationQueryMessage)bidibMessage;
            CsQueryTypeEnum csQueryType = commandStationQueryMessage.getCsQueryType();
            switch (csQueryType) {
                case LOCO_LIST: {
                    String carQueryCommand = "A";
                    this.usbStickBasisAdapter.transmit(carQueryCommand);
                    break;
                }
                default: {
                    LOGGER.warn("The CsQueryRequest is not implemented for type: {}", (Object)csQueryType);
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Process the CsQuery request failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processFeatureGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureNotAvailableResponse featureResponse;
            FeatureGetMessage featureGetMessage = (FeatureGetMessage)bidibMessage;
            int featureNum = featureGetMessage.getNumber();
            LOGGER.info("Get feature with number: {}", (Object)featureNum);
            Feature foundFeature = null;
            for (Feature feature : this.features) {
                if (feature.getType() != featureNum) continue;
                foundFeature = feature;
                LOGGER.info("Found feature: {}", (Object)foundFeature);
                break;
            }
            if (foundFeature != null) {
                featureResponse = new FeatureResponse(featureGetMessage.getAddr(), this.getNextResponseSendNum(), featureNum, foundFeature.getValue());
                response = featureResponse.getContent();
                LOGGER.info("Prepared response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
            } else {
                featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), featureNum);
                response = featureResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processFeatureSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureNotAvailableResponse featureResponse;
            FeatureSetMessage featureSetMessage = (FeatureSetMessage)bidibMessage;
            int featureNum = featureSetMessage.getNumber();
            int featureValue = featureSetMessage.getValue();
            LOGGER.info("Set feature with number: {}, value: {}", (Object)featureNum, (Object)featureValue);
            Feature foundFeature = null;
            for (Feature feature : this.features) {
                if (feature.getType() != featureNum) continue;
                foundFeature = this.updateFeatureValue(feature, featureValue);
                LOGGER.info("Found feature: {}", (Object)foundFeature);
                break;
            }
            if (foundFeature != null) {
                featureResponse = new FeatureResponse(featureSetMessage.getAddr(), this.getNextResponseSendNum(), featureNum, foundFeature.getValue());
                response = featureResponse.getContent();
                LOGGER.info("Prepared response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
            } else {
                featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), featureNum);
                response = featureResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature response failed.", (Throwable)ex);
        }
        return response;
    }

    protected Feature updateFeatureValue(Feature feature, int featureValue) {
        if (feature.getFeatureEnum() != null) {
            switch (feature.getFeatureEnum()) {
                case FEATURE_GEN_POM_REPEAT: {
                    if (featureValue > 4) {
                        featureValue = 4;
                    } else if (featureValue < 1) {
                        featureValue = 1;
                    }
                    LOGGER.info("Set the POM repeat value on the speedometer: {}", (Object)featureValue);
                    this.usbStickBasisAdapter.transmit("CP " + featureValue);
                    break;
                }
            }
        }
        feature.setValue(featureValue);
        return feature;
    }

    protected Feature autoAddFeature(int featureNum, int featureValue) {
        Feature foundFeature = new Feature(featureNum, featureValue);
        this.features.add(foundFeature);
        return foundFeature;
    }

    protected byte[] processFeatureGetAllRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureCountResponse featureResponse = new FeatureCountResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), this.features.size());
            response = featureResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature count response failed.", (Throwable)ex);
        }
        this.currentFeature = 0;
        return response;
    }

    protected byte[] processFeatureGetNextRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        if (this.currentFeature >= this.features.size()) {
            try {
                FeatureNotAvailableResponse featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), 255);
                response = featureResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create feature N/A response failed.", (Throwable)ex);
            }
        } else {
            try {
                Feature feature = (Feature)IterableUtils.get(this.features, (int)this.currentFeature);
                FeatureResponse featureResponse = new FeatureResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), feature.getType(), feature.getValue());
                response = featureResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create feature response failed.", (Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.warn("Create feature response failed.", (Throwable)ex);
            }
        }
        ++this.currentFeature;
        return response;
    }

    protected byte[] processVendorEnableRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorEnableMessage vendorEnableMessage = (VendorEnableMessage)bidibMessage;
            long uniqueId = vendorEnableMessage.getUniqueId();
            LOGGER.info("Enable the user config mode for uniqueId: {}", (Object)uniqueId);
            byte userConfigModeActive = 1;
            VendorAckResponse vendorAckResponse = new VendorAckResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), userConfigModeActive);
            response = vendorAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor ack response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorDisableRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            LOGGER.info("Disable the user config mode");
            byte userConfigModeActive = 0;
            VendorAckResponse vendorAckResponse = new VendorAckResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), userConfigModeActive);
            response = vendorAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor ack response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorSetMessage vendorSetMessage = (VendorSetMessage)bidibMessage;
            VendorData vendorData = vendorSetMessage.getVendorData();
            LOGGER.info("Set the vendor data: {}", (Object)vendorData);
            if ("Scale".equals(vendorData.getName())) {
                String scale = vendorData.getValue();
                LOGGER.info("Set the scale value of the selected car: {}", (Object)scale);
                Integer scaleValue = Integer.valueOf(scale);
                this.selectedCar.setScale(scaleValue != null && scaleValue > 0 ? scaleValue : null);
                byte[] nodeAddress = vendorSetMessage.getAddr();
                response = this.prepareCvResponse(nodeAddress, vendorData.getName(), scale);
            } else if ("SpeedMeasurement".equals(vendorData.getName())) {
                String speedMeasurementCommand = vendorData.getValue();
                LOGGER.info("Prepared speed measurement command: {}", (Object)speedMeasurementCommand);
                this.usbStickBasisAdapter.transmit(speedMeasurementCommand);
                byte[] nodeAddress = vendorSetMessage.getAddr();
                response = this.prepareCvResponse(nodeAddress, vendorData.getName(), speedMeasurementCommand);
            } else {
                String bcvReadCommand = "BCV " + vendorData.getName() + "," + vendorData.getValue();
                LOGGER.info("Prepared BCV set command: {}", (Object)bcvReadCommand);
                this.usbStickBasisAdapter.transmit(bcvReadCommand);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Process vendorSet request failed.", (Throwable)ex);
        }
        return response;
    }

    private byte[] prepareCvResponse(byte[] nodeAddress, String cvName, String cvValue) throws ProtocolException {
        try {
            VendorResponse bidibMessage = new VendorResponse(nodeAddress, this.getNextResponseSendNum(), cvName, cvValue);
            return bidibMessage.getContent();
        }
        catch (Exception ex) {
            LOGGER.warn("Create VendorResponse failed, cvName: {}, cvValue", new Object[]{cvName, cvValue, ex});
            throw new ProtocolException("Create VendorResponse failed, cvName: " + cvName + ", cvValue: " + cvValue);
        }
    }

    protected byte[] processVendorGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorGetMessage vendorGetMessage = (VendorGetMessage)bidibMessage;
            String vendorDataName = vendorGetMessage.getVendorDataName();
            LOGGER.info("Get the vendor data with name: {}", (Object)vendorDataName);
            String bcvReadCommand = "BCV " + vendorDataName;
            LOGGER.info("Prepared BCV read command: {}", (Object)bcvReadCommand);
            this.usbStickBasisAdapter.transmit(bcvReadCommand);
        }
        catch (Exception ex) {
            LOGGER.warn("Process vendorGet request failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processStringSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            StringSetMessage stringSetMessage = (StringSetMessage)bidibMessage;
            int stringId = stringSetMessage.getStringId();
            this.stringValue[stringId] = stringSetMessage.getString();
            StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), this.stringValue[stringId]);
            response = stringResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processStringGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            StringGetMessage stringGetMessage = (StringGetMessage)bidibMessage;
            int stringId = stringGetMessage.getStringId();
            LOGGER.info("Get STRING[{}]: {}", (Object)stringId, (Object)this.stringValue[stringId]);
            StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextResponseSendNum(), ByteUtils.getLowByte((int)stringGetMessage.getNamespace()), ByteUtils.getLowByte((int)stringGetMessage.getStringId()), this.stringValue[stringId]);
            response = stringResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsPomRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsPom request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationPomMessage commandStationPomMessage = (CommandStationPomMessage)bidibMessage;
            PomAddressData addressData = commandStationPomMessage.getDecoderAddress();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            Integer currentAddress = this.selectedCar.getDecoderAddress();
            if (currentAddress == null || addressData.getAddress() != currentAddress.intValue()) {
                currentAddress = addressData.getAddress();
                LOGGER.info("Updated the decoder address: {}", (Object)currentAddress);
                this.selectedCar.setDecoderAddress(currentAddress);
                String addressCommand = "A " + currentAddress;
                this.usbStickBasisAdapter.transmit(addressCommand);
                Thread.sleep(10L);
            }
            String cvCommand = null;
            int cvNumber = commandStationPomMessage.getCvNumber();
            int cvValue = 0;
            CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)commandStationPomMessage.getOpCode()));
            switch (opCode) {
                case WR_BYTE: {
                    cvValue = commandStationPomMessage.getCvValue();
                    cvCommand = "CV " + cvNumber + "," + cvValue;
                    break;
                }
                default: {
                    cvCommand = "CV " + cvNumber;
                }
            }
            LOGGER.info("Prepared CV command: {}", (Object)cvCommand);
            this.usbStickBasisAdapter.transmit(cvCommand);
            Thread.sleep(10L);
            CommandStationPomAcknowledgeResponse commandStationPomAckResponse = new CommandStationPomAcknowledgeResponse(bidibMessage.getAddr(), 0, addressData, 1);
            LOGGER.info("Publish the running response: {}", (Object)commandStationPomAckResponse);
            this.prepareMessage((BidibMessageInterface)commandStationPomAckResponse);
        }
        catch (InterruptedException | ProtocolException ex) {
            LOGGER.warn("Create CommandStationPomAck response failed.", ex);
        }
        return response;
    }

    protected void processResetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the reset request, bidibMessage: {}", (Object)bidibMessage);
        if (!this.initialResetSkipped) {
            LOGGER.warn("Skip the initial reset command as the Speedometer boots on connect.");
            this.initialResetSkipped = true;
            return;
        }
        this.resetSendNum();
        String restartCommand = "REBOOT";
        LOGGER.info("Prepared restart command: {}", (Object)restartCommand);
        this.usbStickBasisAdapter.transmit(restartCommand);
    }

    protected void resetSendNum() {
        LOGGER.info("Reset the sendNum to 0.");
        this.sendNum = 0;
    }

    protected int getNextSendNum() {
        return 0;
    }

    protected int getCurrentSendNum() {
        return this.sendNum;
    }

    protected int getNextResponseSendNum() {
        int nextSendNum = this.sendNum++;
        if (this.sendNum > 255) {
            this.sendNum = 0;
        }
        return nextSendNum;
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }

    protected int contactInterface() {
        return 0;
    }

    private class UsbStickConnector
    extends AbstractBaseBidib {
        private UsbStickConnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
            LOGGER.info("Send data stream: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data));
            try {
                UsbStickBasisBidib.this.sendBuffer.reset();
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)UsbStickBasisBidib.this.sendBuffer);
                byte[] bytes = UsbStickBasisBidib.this.sendBuffer.toByteArray();
                LOGGER.info("Send is called with bytes: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
                if (rawMessageListener != null) {
                    rawMessageListener.notifySend(bytes);
                }
                List bidibMessages = UsbStickBasisBidib.this.requestFactory.create(bytes);
                Iterator iterator = bidibMessages.iterator();
                while (iterator.hasNext()) {
                    BidibMessageInterface bidibMessage = (BidibMessageInterface)iterator.next();
                    Object object = UsbStickBasisBidib.this.responseMessageLock;
                    synchronized (object) {
                        byte[] response = UsbStickBasisBidib.this.processRequest(bidibMessage);
                        if (response != null) {
                            UsbStickBasisBidib.this.publishResponse(response);
                        }
                    }
                }
                return;
            }
            catch (Exception ex) {
                LOGGER.warn("Process request failed.", (Throwable)ex);
                return;
            }
            finally {
                UsbStickBasisBidib.this.sendBuffer.reset();
            }
        }

        protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
            super.internalOpen(portName, context);
            LOGGER.info("Internal open the port.");
        }

        public void doReceive(byte[] content, int length) {
            this.receive(content, length);
        }

        public boolean close() {
            super.close();
            if (UsbStickBasisBidib.this.usbStickBasisAdapter != null) {
                LOGGER.info("Close the connection of the usbStickBasisAdapter: {}", (Object)UsbStickBasisBidib.this.usbStickBasisAdapter);
                try {
                    UsbStickBasisBidib.this.usbStickBasisAdapter.closeConnection();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close connection to USB stick basis failed.", (Throwable)ex);
                }
                UsbStickBasisBidib.this.usbStickBasisAdapter = null;
                return true;
            }
            return false;
        }
    }
}

