/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.usbstickbasis.adapter;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageListener;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.DebugMessageReceiver;
import org.bidib.jbidibc.debug.DebugReaderFactory;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisModel;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisResponseFactory;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisResponseInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbStickBasisAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsbStickBasisAdapter.class);
    private DebugInterface debugReader;
    private DebugMessageReceiver messageReceiver;
    private DebugMessageListener messageListener;
    private final UsbStickBasisModel usbStickBasisModel;
    private final UsbStickBasisResponseInterface responseInterface;
    private final StringBuilder resultBuffer = new StringBuilder();
    private final List<String> receivedLines = new LinkedList<String>();
    protected final ScheduledExecutorService receiverWorker = Executors.newScheduledThreadPool(1);
    private ResponseFactory responseFactory;
    private AtomicBoolean receiverWorkerActive = new AtomicBoolean();

    public UsbStickBasisAdapter(UsbStickBasisResponseInterface responseInterface, UsbStickBasisModel usbStickBasisModel) {
        this.responseInterface = responseInterface;
        this.usbStickBasisModel = usbStickBasisModel;
    }

    public void openConnection(String portName, String serialPortProvider) throws PortNotFoundException, PortNotOpenedException {
        Integer baudRate = this.usbStickBasisModel.getBaudRate();
        if (baudRate == null) {
            LOGGER.warn("No baudrate selected!");
            throw new IllegalArgumentException("No baudrate selected.");
        }
        LOGGER.info("Selected portName: {}", (Object)portName);
        if (this.debugReader == null) {
            LOGGER.info("Create new instance of debug reader.");
            this.responseFactory = new UsbStickBasisResponseFactory(this.responseInterface);
            this.responseFactory.initialize();
            try {
                this.messageListener = new DebugMessageListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void debugMessage(String message) {
                        LOGGER.info("debug message received size: {}, message: {}", (Object)message.length(), (Object)message);
                        UsbStickBasisAdapter.this.responseInterface.addLog(message);
                        StringBuilder stringBuilder = UsbStickBasisAdapter.this.resultBuffer;
                        synchronized (stringBuilder) {
                            LOGGER.trace("++ append");
                            UsbStickBasisAdapter.this.resultBuffer.append(message);
                            UsbStickBasisAdapter.this.resultBuffer.notifyAll();
                            LOGGER.trace("-- append");
                        }
                    }
                };
                this.messageReceiver = new DebugMessageReceiver();
                this.messageReceiver.addMessageListener(this.messageListener);
                LOGGER.info("Selected serial port provider: {}", (Object)serialPortProvider);
                DebugReaderFactory.SerialImpl serialImpl = null;
                switch (serialPortProvider) {
                    case "scm": {
                        serialImpl = DebugReaderFactory.SerialImpl.SCM;
                        break;
                    }
                    default: {
                        serialImpl = DebugReaderFactory.SerialImpl.PUREJAVACOMM;
                    }
                }
                this.debugReader = DebugReaderFactory.getDebugReader((DebugReaderFactory.SerialImpl)serialImpl, (DebugMessageProcessor)this.messageReceiver);
                LOGGER.info("Created debugReader: {}", (Object)this.debugReader);
            }
            catch (Exception ex) {
                LOGGER.warn("Open debug port failed.", (Throwable)ex);
            }
        }
        try {
            this.debugReader.open(portName, baudRate.intValue(), new ConnectionListener(){

                public void opened(String port) {
                    LOGGER.info("Port opened: {}", (Object)port);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UsbStickBasisAdapter.this.usbStickBasisModel.setConnected(true);
                        }
                    });
                }

                public void closed(String port) {
                    LOGGER.info("Port closed: {}", (Object)port);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UsbStickBasisAdapter.this.usbStickBasisModel.setConnected(false);
                        }
                    });
                }

                public void status(String messageKey, Context context) {
                }

                public void stall(boolean stall) {
                }
            }, null);
            int delay = 0;
            LOGGER.info("Schedule the receiverWorker.");
            this.receiverWorkerActive.set(true);
            this.receiverWorker.schedule(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Start process the receive queue.");
                    while (UsbStickBasisAdapter.this.receiverWorkerActive.get()) {
                        try {
                            UsbStickBasisAdapter.this.processReceiveQueue(UsbStickBasisAdapter.this.responseInterface);
                        }
                        catch (ProtocolException ex) {
                            LOGGER.warn("Process received response failed", (Throwable)ex);
                        }
                    }
                    LOGGER.info("Receive queue worker has finished.");
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        catch (PortNotFoundException | PortNotOpenedException ex) {
            LOGGER.warn("Open serial port failed.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Open serial port failed.", (Throwable)ex);
            throw new PortNotOpenedException("Open serial port failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        LOGGER.info("Close the debug connection.");
        if (this.debugReader != null) {
            LOGGER.info("Close the debug reader.");
            this.debugReader.close();
            this.receiverWorkerActive.set(false);
            this.usbStickBasisModel.setConnected(false);
            try {
                StringBuilder stringBuilder = this.resultBuffer;
                synchronized (stringBuilder) {
                    this.resultBuffer.notifyAll();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Notify the resultBuffer failed.", (Throwable)ex);
            }
            this.messageReceiver.removeMessageListener(this.messageListener);
            this.messageListener = null;
            this.messageReceiver = null;
            this.debugReader = null;
        } else {
            LOGGER.info("debug reader not available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReceiveBuffer() {
        LOGGER.info("Clear the receive buffer.");
        StringBuilder stringBuilder = this.resultBuffer;
        synchronized (stringBuilder) {
            this.resultBuffer.setLength(0);
        }
    }

    public String transmit(String sendText) {
        if (StringUtils.isEmpty((CharSequence)sendText)) {
            LOGGER.info("No data to send!");
            return null;
        }
        LOGGER.info("Send text to debugReader: '{}'", (Object)sendText);
        String result = null;
        if (this.debugReader != null) {
            this.debugReader.send(sendText, this.usbStickBasisModel.getLineEnding());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReceiveQueue(UsbStickBasisResponseInterface responseInterface) throws ProtocolException {
        StringBuilder stringBuilder = this.resultBuffer;
        synchronized (stringBuilder) {
            LOGGER.trace("++ processReceiveQueue, resultBuffer.length(): {}", (Object)this.resultBuffer.length());
            if (this.resultBuffer.length() < 1) {
                try {
                    this.resultBuffer.wait(500L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for data in result buffer failed.", (Throwable)ex);
                }
            }
            if (this.resultBuffer.length() > 0) {
                int lastLF = this.resultBuffer.lastIndexOf("\n");
                LOGGER.trace("lastLF: {}", (Object)lastLF);
                if (lastLF > 0) {
                    List parts = Pattern.compile("\n").splitAsStream(this.resultBuffer.substring(0, lastLF)).map(str -> str.trim()).filter(str -> !str.isEmpty()).collect(Collectors.toList());
                    this.receivedLines.addAll(parts);
                    String remaining = null;
                    if (lastLF < this.resultBuffer.length()) {
                        remaining = this.resultBuffer.substring(lastLF).trim();
                        LOGGER.info("Keep the remaining: '{}'", (Object)remaining);
                    }
                    this.resultBuffer.setLength(0);
                    if (StringUtils.isNotBlank((CharSequence)remaining)) {
                        this.resultBuffer.append(remaining);
                    }
                }
            }
            while (!this.receivedLines.isEmpty()) {
                try {
                    String part = this.receivedLines.remove(0).trim();
                    LOGGER.info("Check part: '{}'", (Object)part);
                    BidibMessageInterface bidibMessage = this.responseFactory.create(part.getBytes(Charset.forName("UTF-8")));
                    LOGGER.info("Created bidibMessage: {}", (Object)bidibMessage);
                    if (bidibMessage == null) continue;
                    responseInterface.publishReponse(bidibMessage);
                }
                catch (Exception ex) {
                    LOGGER.warn("Create bidib message from received data failed.", (Throwable)ex);
                }
            }
            LOGGER.trace("-- processReceiveQueue");
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception ex) {
            LOGGER.warn("Sleep for 10ms after processing resultBuffer failed.", (Throwable)ex);
        }
    }
}

