/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.usbstickbasis.adapter;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.DynNumEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDynStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.usbstickbasis.adapter.SelectedCar;
import org.bidib.jbidibc.usbstickbasis.adapter.UsbStickBasisResponseInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbStickBasisResponseFactory
implements ResponseFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsbStickBasisResponseFactory.class);
    private static final String PREFIX_POM_REPEAT = "POM repeat:";
    private static final String PREFIX_CAR_RESPONSE = "Car->:";
    private static final String PREFIX_CAR_REQUEST = "->Car:";
    private final UsbStickBasisResponseInterface responseInterface;
    private Pattern patternCarCvResponse;
    private Pattern patternCarBatteryResponse;
    private Pattern patternCarSpeedResponse;
    private Pattern patternBasisCv;
    private Pattern patternBasisStatus;
    private Pattern patternSpeed;
    private Pattern patternProductline;
    private Pattern patternProductname;
    private Pattern patternFirmwareVersion;
    private Pattern patternCarSpeedstep;
    private Pattern patternCarQueryCar;
    private Pattern patternPomRepeat;
    private SelectedCar selectedCar;
    private static final String REGEX_PATTERN_CAR_CV_RESPONSE = "Car->:(\\d+) Msg_Nr\\:(\\d+) CV(\\d+) = (.+)";
    private static final String REGEX_PATTERN_CAR_BATTERY_RESPONSE = "Car->:(\\d+) Msg_Nr\\:(\\d+) battery=(\\d+)\\%";
    private static final String REGEX_PATTERN_CAR_SPEED_RESPONSE = "Car->:(\\d+) Msg_Nr\\:(\\d+) speed=(\\d+)km/h";
    private final byte[] ROOT_ADDR = new byte[]{0};
    private static final String REGEX_PATTERN_CAR_SPEEDSTEP = "^->Car:(\\d+) FS: (\\d+)";
    private static final String REGEX_PATTERN_CARQUERY_CAR = "^actual car address: (\\d+) with speedstep: (\\d+)";
    private static final String REGEX_PATTERN_BASIS_CV = "^(write Basis|Basis) CV(\\d+) = (\\d+)";
    public static final String REGEX_PATTERN_BASIS_STATUS = "^Status\\: (\\S+)";
    public static final String REGEX_PATTERN_BASIS_SET_STATUS = "^set Status\\: (\\S+)";
    private static final String REGEX_PATTERN_SPEED = "^Speed\\: (\\d+) mm/s, mean speed: (\\d+) mm/s";
    private static final String REGEX_PATTERN_PRODUCTLINE = "^OpenCarSystem (USB-Basis|Car-Speedometer) V(\\d+).+$";
    private static final String REGEX_PATTERN_PRODUCTNAME = "^OpenCarSystem (USB-Basis|Car-Speedometer)";
    private static final String REGEX_PATTERN_FIRMWAREVERSION = "V(\\d+.*)$";
    private static final String REGEX_PATTERN_POMREPEAT = "^POM repeat: (\\d+)$";

    public UsbStickBasisResponseFactory(UsbStickBasisResponseInterface responseInterface) {
        this.responseInterface = responseInterface;
        this.selectedCar = responseInterface.getSelectedCarModel();
        this.patternCarCvResponse = Pattern.compile(REGEX_PATTERN_CAR_CV_RESPONSE);
        this.patternCarBatteryResponse = Pattern.compile(REGEX_PATTERN_CAR_BATTERY_RESPONSE);
        this.patternCarSpeedResponse = Pattern.compile(REGEX_PATTERN_CAR_SPEED_RESPONSE);
        this.patternBasisCv = Pattern.compile(REGEX_PATTERN_BASIS_CV);
        this.patternBasisStatus = Pattern.compile(REGEX_PATTERN_BASIS_STATUS);
        this.patternSpeed = Pattern.compile(REGEX_PATTERN_SPEED);
        this.patternProductline = Pattern.compile(REGEX_PATTERN_PRODUCTLINE);
        this.patternProductname = Pattern.compile(REGEX_PATTERN_PRODUCTNAME);
        this.patternFirmwareVersion = Pattern.compile(REGEX_PATTERN_FIRMWAREVERSION);
        this.patternCarSpeedstep = Pattern.compile(REGEX_PATTERN_CAR_SPEEDSTEP);
        this.patternCarQueryCar = Pattern.compile(REGEX_PATTERN_CARQUERY_CAR);
        this.patternPomRepeat = Pattern.compile(REGEX_PATTERN_POMREPEAT);
    }

    public void initialize() {
    }

    public BidibMessage create(byte[] message) throws ProtocolException {
        String line = new String(message, Charset.forName("UTF-8"));
        LOGGER.info("Process the line: {}", (Object)line);
        BidibMessage bidibMessage = null;
        if (line.startsWith(PREFIX_CAR_RESPONSE)) {
            bidibMessage = this.parseCarResponse(line);
        } else if (line.startsWith(PREFIX_CAR_REQUEST)) {
            bidibMessage = this.parseCarRequestResponse(line);
        } else if (line.startsWith("actual")) {
            bidibMessage = this.parseCarQueryResponse(line);
        } else if (line.startsWith("Status") || line.startsWith("set Status")) {
            bidibMessage = this.parseBasisResponse(line);
        } else if (line.startsWith("Basis") || line.startsWith("write Basis")) {
            bidibMessage = this.parseBasisCvResponse(line);
        } else if (line.startsWith("Speed:")) {
            bidibMessage = this.parseSpeedResponse(line);
        } else if (line.startsWith("OpenCarSystem")) {
            bidibMessage = this.parseHelpResponse(line);
        } else if (line.startsWith(PREFIX_POM_REPEAT)) {
            bidibMessage = this.parsePomRepeatResponse(line);
        } else if (line.startsWith("OK")) {
            bidibMessage = this.parseOkResponse(line);
        }
        LOGGER.info("Created bidibMessage: {}", (Object)bidibMessage);
        return bidibMessage;
    }

    protected BidibMessage parseCarResponse(String line) throws ProtocolException {
        LOGGER.info("parseCarResponse, line: {}", (Object)line);
        FeedbackCvResponse bidibMessage = null;
        Matcher m = this.patternCarCvResponse.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String addr = m.group(1);
            String msgNum = m.group(2);
            String cvNum = m.group(3);
            String cvValue = m.group(4);
            LOGGER.info("Current addr: {}, msgNum: {}, cvNum: {}, cvValue: {}", new Object[]{addr, msgNum, cvNum, cvValue});
            try {
                int cvNumVal = Integer.parseInt(cvNum) - 1;
                bidibMessage = new FeedbackCvResponse(this.ROOT_ADDR, Integer.parseInt(msgNum), Integer.parseInt(addr), cvNumVal, Integer.parseInt(cvValue));
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackCvResponse failed, response: {}", (Object)line, (Object)ex);
                throw new ProtocolException("Create FeedbackCvResponse failed, line: " + line);
            }
            return bidibMessage;
        }
        m = this.patternCarBatteryResponse.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String addr = m.group(1);
            String msgNum = m.group(2);
            String batteryPercentage = m.group(3);
            LOGGER.info("Current addr: {}, msgNum: {}, batteryPercentage: {}", new Object[]{addr, msgNum, batteryPercentage});
            try {
                AddressData addressData = new AddressData(Integer.parseInt(addr), AddressTypeEnum.LOCOMOTIVE_FORWARD);
                int detectorNum = 0;
                bidibMessage = new FeedbackDynStateResponse(this.ROOT_ADDR, Integer.parseInt(msgNum), detectorNum, addressData, DynNumEnum.DYN_STATE_NUM_CONTAINER_1.getType(), ByteUtils.getLowByte((int)Integer.parseInt(batteryPercentage)));
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackDynStateResponse failed, response: {}", (Object)line, (Object)ex);
                throw new ProtocolException("Create FeedbackDynStateResponse failed, line: " + line);
            }
            return bidibMessage;
        }
        m = this.patternCarSpeedResponse.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String carAddress = m.group(1);
            String msgNum = m.group(2);
            String carSpeed = m.group(3);
            LOGGER.info("Current carAddress: {}, msgNum: {}, carSpeed: {}", new Object[]{carAddress, msgNum, carSpeed});
            LOGGER.info("Create speed response from car speed message: {}", (Object)carSpeed);
            try {
                bidibMessage = new FeedbackSpeedResponse(this.ROOT_ADDR, 0, Integer.parseInt(carAddress), Integer.parseInt(carSpeed));
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackSpeedResponse failed, response: {}", (Object)line, (Object)ex);
                throw new ProtocolException("Create FeedbackSpeedResponse failed, line: " + line);
            }
            return bidibMessage;
        }
        return bidibMessage;
    }

    protected BidibMessage parseCarRequestResponse(String line) throws ProtocolException {
        LOGGER.info("parseCarRequestResponse, line: {}", (Object)line);
        FeedbackSpeedResponse bidibMessage = null;
        Matcher m = this.patternCarCvResponse.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String addr = m.group(1);
            String msgNum = m.group(2);
            String cvNum = m.group(3);
            String cvValue = m.group(4);
            LOGGER.info("Current addr: {}, msgNum: {}, cvNum: {}, cvValue: {}", new Object[]{addr, msgNum, cvNum, cvValue});
            try {
                int cvNumVal = Integer.parseInt(cvNum) - 1;
                bidibMessage = new FeedbackCvResponse(this.ROOT_ADDR, Integer.parseInt(msgNum), Integer.parseInt(addr), cvNumVal, Integer.parseInt(cvValue));
                return bidibMessage;
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackCvResponse failed, response: {}", (Object)line, (Object)ex);
                throw new ProtocolException("Create FeedbackCvResponse failed, line: " + line);
            }
        }
        LOGGER.trace("The provided line does not match the CarCV response pattern: {}", (Object)line);
        m = this.patternCarSpeedstep.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String carAddress = null;
            String carSpeed = null;
            try {
                carAddress = m.group(1);
                carSpeed = m.group(2);
                LOGGER.info("Parsed car address: {}, speed: {}", (Object)carAddress, (Object)carSpeed);
                LOGGER.info("Create speed response from car speed steps message: {}", (Object)carSpeed);
                if (this.selectedCar.getScale() == null) {
                    bidibMessage = new FeedbackSpeedResponse(this.ROOT_ADDR, 0, Integer.parseInt(carAddress), Integer.parseInt(carSpeed));
                    return bidibMessage;
                }
                LOGGER.info("Skip provide SPEED response from car speed message because measurement is active.");
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackSpeedResponse failed, CV num: {}, CV value: {}", new Object[]{carAddress, carSpeed, ex});
                throw new ProtocolException("Create FeedbackSpeedResponse failed, line: " + line);
            }
        } else {
            LOGGER.trace("The provided line does not match the car speed step pattern: {}", (Object)line);
        }
        return bidibMessage;
    }

    protected BidibMessage parseCarQueryResponse(String line) throws ProtocolException {
        LOGGER.info("parseCarQueryResponse, line: {}", (Object)line);
        CommandStationDriveStateResponse bidibMessage = null;
        Matcher m = this.patternCarQueryCar.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String carAddress = null;
            String carSpeed = null;
            try {
                carAddress = m.group(1);
                carSpeed = m.group(2);
                LOGGER.info("Parsed car address: {}, speed: {}", (Object)carAddress, (Object)carSpeed);
                AddressData addressData = new AddressData(Integer.parseInt(carAddress), AddressTypeEnum.LOCOMOTIVE_FORWARD);
                byte[] functions = new byte[]{0, 0, 0, 0};
                bidibMessage = new CommandStationDriveStateResponse(this.ROOT_ADDR, 0, 65, addressData, SpeedStepsEnum.DCC128, Integer.parseInt(carSpeed), functions);
            }
            catch (Exception ex) {
                LOGGER.warn("Create CommandStationStateResponse failed, CV num: {}, CV value: {}", new Object[]{carAddress, carSpeed, ex});
                throw new ProtocolException("Create CommandStationStateResponse failed, line: " + line);
            }
        }
        return bidibMessage;
    }

    protected BidibMessage parseBasisCvResponse(String line) throws ProtocolException {
        LOGGER.info("parseBasisCvResponse, parse line: {}", (Object)line);
        VendorResponse bidibMessage = null;
        Matcher m = this.patternBasisCv.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String basisCvNum = null;
            String basisCvValue = null;
            try {
                basisCvNum = m.group(2);
                basisCvValue = m.group(3);
                LOGGER.info("Parsed CV num: {}, CV value: {}", (Object)basisCvNum, (Object)basisCvValue);
                bidibMessage = new VendorResponse(this.ROOT_ADDR, 0, basisCvNum, basisCvValue);
            }
            catch (Exception ex) {
                LOGGER.warn("Create CommandStationStateResponse failed, CV num: {}, CV value: {}", new Object[]{basisCvNum, basisCvValue, ex});
                throw new ProtocolException("Create CommandStationStateResponse failed, line: " + line);
            }
        } else {
            LOGGER.info("No match found: {}", (Object)line);
        }
        return bidibMessage;
    }

    protected BidibMessage parseBasisResponse(String line) throws ProtocolException {
        if (line.startsWith("set ")) {
            line = line.substring(4);
        }
        CommandStationStateResponse bidibMessage = null;
        Matcher m = this.patternBasisStatus.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            String basisStatus = m.group(1);
            try {
                CommandStationState state = null;
                switch (basisStatus.toLowerCase()) {
                    case "go": {
                        state = CommandStationState.GO;
                        break;
                    }
                    default: {
                        state = CommandStationState.STOP;
                    }
                }
                bidibMessage = new CommandStationStateResponse(this.ROOT_ADDR, 0, state.getType());
            }
            catch (Exception ex) {
                LOGGER.warn("Create CommandStationStateResponse failed, basisStatus: {}", (Object)basisStatus, (Object)ex);
                throw new ProtocolException("Create CommandStationStateResponse failed, line: " + line);
            }
        }
        return bidibMessage;
    }

    protected BidibMessage parseSpeedResponse(String line) throws ProtocolException {
        FeedbackSpeedResponse bidibMessage = null;
        Matcher m = this.patternSpeed.matcher(line);
        if (m.matches()) {
            LOGGER.info("A matching line was found, m: {}", (Object)m);
            try {
                Integer decoderAddress = this.selectedCar.getDecoderAddress();
                if (decoderAddress != null) {
                    String currentSpeed = m.group(1);
                    String meanSpeed = m.group(2);
                    int speedValue = Integer.parseInt(meanSpeed);
                    LOGGER.info("Create speed response from speed message: {} mm/s, current speed: {} mm/s, meanSpeed: {} mm/s", new Object[]{speedValue, currentSpeed, meanSpeed});
                    bidibMessage = new FeedbackSpeedResponse(this.ROOT_ADDR, 0, decoderAddress.intValue(), speedValue);
                } else {
                    LOGGER.warn("Skip return speed response because no decoder address available.");
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Create FeedbackSpeedResponse failed, line: {}", (Object)line, (Object)ex);
                throw new ProtocolException("Create FeedbackSpeedResponse failed, line: " + line);
            }
        }
        return bidibMessage;
    }

    private BidibMessage parseHelpResponse(String line) throws ProtocolException {
        LOGGER.info("Received answer: {}", (Object)line);
        SysSwVersionResponse response = null;
        String productLine = null;
        Matcher m = this.patternProductline.matcher(line);
        if (m.matches()) {
            productLine = line;
            LOGGER.info("Found matching result: {}", (Object)productLine);
        }
        if (StringUtils.isNotBlank((CharSequence)productLine)) {
            Matcher matcher;
            if (this.responseInterface != null && (matcher = this.patternProductname.matcher(productLine)).find()) {
                String productName = matcher.group();
                LOGGER.info("Found productName: {}", (Object)productName);
                this.responseInterface.publishProductName(productName);
            }
            if ((matcher = this.patternFirmwareVersion.matcher(productLine)).find()) {
                String firmwareVersion = matcher.group(1);
                SoftwareVersion version = SoftwareVersion.parse((String)firmwareVersion);
                response = new SysSwVersionResponse(this.ROOT_ADDR, 0, version.asByteArray());
            }
        } else {
            LOGGER.warn("Get the productName of the attached stick failed.");
        }
        return response;
    }

    protected BidibMessage parsePomRepeatResponse(String line) {
        Matcher matcher;
        LOGGER.info("Parse POM repeat response: {}", (Object)line);
        FeatureResponse response = null;
        if (StringUtils.isNotBlank((CharSequence)line) && this.responseInterface != null && (matcher = this.patternPomRepeat.matcher(line)).find()) {
            String pomRepeat = matcher.group(1);
            LOGGER.info("Found pomRepeat: {}", (Object)pomRepeat);
            try {
                int featureValuePomRepeat = Integer.parseInt(pomRepeat);
                this.responseInterface.publishPomRepeat(featureValuePomRepeat);
                LOGGER.info("Set the FEATURE_GEN_POM_REPEAT: {}", (Object)featureValuePomRepeat);
                response = new FeatureResponse(this.ROOT_ADDR, 0, 106, featureValuePomRepeat);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the feature POM repeat failed.", (Throwable)ex);
            }
        }
        return response;
    }

    private BidibMessage parseOkResponse(String line) {
        LOGGER.info("Parse OK response.");
        return null;
    }

    public BidibMessage createRaw(byte[] message) throws ProtocolException {
        return null;
    }
}

