/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import org.biojava.nbio.ontology.AlreadyExistsException;
import org.biojava.nbio.ontology.OntoTools;
import org.biojava.nbio.ontology.Ontology;
import org.biojava.nbio.ontology.OntologyException;
import org.biojava.nbio.ontology.OntologyFactory;
import org.biojava.nbio.ontology.obo.OboFileHandler;
import org.biojava.nbio.ontology.obo.OboFileParser;

public class OboParser {
    public Ontology parseOBO(BufferedReader oboFile, String ontoName, String ontoDescription) throws ParseException, IOException {
        try {
            OntologyFactory factory = OntoTools.getDefaultFactory();
            Ontology ontology = factory.createOntology(ontoName, ontoDescription);
            OboFileParser parser = new OboFileParser();
            OboFileHandler handler = new OboFileHandler(ontology);
            parser.addOboFileEventListener(handler);
            parser.parseOBO(oboFile);
            return ontology;
        }
        catch (AlreadyExistsException ex) {
            throw new RuntimeException("Duplication in ontology");
        }
        catch (OntologyException ex) {
            throw new RuntimeException(ex);
        }
    }
}

