/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.glyph.Glyph;

public class ArrowGlyph
implements Glyph {
    private Paint fillPaint;
    private Paint outerPaint;
    private Rectangle2D.Float bounds;
    private Shape arrowShape;

    public ArrowGlyph() {
        this(Color.BLUE, Color.BLACK);
    }

    public ArrowGlyph(Paint fillPaint, Paint outerPaint) {
        this.fillPaint = fillPaint;
        this.outerPaint = outerPaint;
        this.bounds = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ArrowGlyph(Rectangle2D.Float bounds) {
        this(bounds, Color.BLUE, Color.BLACK);
    }

    public ArrowGlyph(Rectangle2D.Float bounds, Paint fillPaint, Paint outerPaint) {
        this(fillPaint, outerPaint);
        this.setBounds(bounds);
    }

    @Override
    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle2D.Float r) {
        if (this.bounds.equals(r)) {
            return;
        }
        this.bounds = r;
    }

    public void setDirection(int direction) {
        float q1 = this.bounds.height * 0.25f;
        float q2 = this.bounds.height * 0.5f;
        float q3 = this.bounds.height * 0.75f;
        float arrowHeadSize = this.bounds.height;
        GeneralPath p = new GeneralPath();
        switch (direction) {
            case 1: {
                if (this.bounds.width - arrowHeadSize > 0.0f) {
                    p.moveTo(this.bounds.x, this.bounds.y + q1);
                    p.lineTo(this.bounds.x + this.bounds.width - arrowHeadSize, this.bounds.y + q1);
                    p.lineTo(this.bounds.x + this.bounds.width - arrowHeadSize, this.bounds.y);
                    p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + q2);
                    p.lineTo(this.bounds.x + this.bounds.width - arrowHeadSize, this.bounds.y + this.bounds.height);
                    p.lineTo(this.bounds.x + this.bounds.width - arrowHeadSize, this.bounds.y + q3);
                    p.lineTo(this.bounds.x, this.bounds.y + q3);
                    break;
                }
                p.moveTo(this.bounds.x, this.bounds.y);
                p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + q2);
                p.lineTo(this.bounds.x, this.bounds.y + this.bounds.height);
                break;
            }
            case -1: {
                if (this.bounds.width - arrowHeadSize > 0.0f) {
                    p.moveTo(this.bounds.x + this.bounds.width, this.bounds.y + q1);
                    p.lineTo(this.bounds.x + arrowHeadSize, this.bounds.y + q1);
                    p.lineTo(this.bounds.x + arrowHeadSize, this.bounds.y);
                    p.lineTo(this.bounds.x, this.bounds.y + q2);
                    p.lineTo(this.bounds.x + arrowHeadSize, this.bounds.y + this.bounds.height);
                    p.lineTo(this.bounds.x + arrowHeadSize, this.bounds.y + q3);
                    p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + q3);
                    break;
                }
                p.moveTo(this.bounds.x + this.bounds.width, this.bounds.y);
                p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
                p.lineTo(this.bounds.x, this.bounds.y + q2);
                break;
            }
            default: {
                p.moveTo(this.bounds.x, this.bounds.y + q1);
                p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + q1);
                p.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + q3);
                p.lineTo(this.bounds.x, this.bounds.y + q3);
            }
        }
        p.closePath();
        this.arrowShape = p;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.bounds.height > 0.0f && this.bounds.width > 0.0f && this.arrowShape == null) {
            this.setDirection(0);
        }
        if (this.arrowShape != null) {
            g.setPaint(this.fillPaint);
            g.fill(this.arrowShape);
            g.setPaint(this.outerPaint);
            g.draw(this.arrowShape);
        }
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Paint getOuterPaint() {
        return this.outerPaint;
    }

    public void setOuterPaint(Paint outerPaint) {
        this.outerPaint = outerPaint;
    }
}

