/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class AlignmentRenderer
extends SequenceRendererWrapper {
    public static ChangeType LABEL = new ChangeType("The label used to select the Alignment component to render has changed.", "org.biojava.bio.gui.sequence.AlignmentRenderer", "LABEL", SequenceRenderContext.LAYOUT);
    private String label;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent((Object)this, LABEL, (Object)label, (Object)this.label);
            ChangeSupport changeSupport = cs = this.getChangeSupport(LABEL);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.label = label;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.label = label;
        }
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public double getDepth(SequenceRenderContext ctx) {
        if (this.getLabel() != null) {
            SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
            return super.getDepth(subctx);
        }
        return 0.0;
    }

    @Override
    public double getMinimumLeader(SequenceRenderContext ctx) {
        if (this.getLabel() != null) {
            SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
            return super.getMinimumLeader(subctx);
        }
        return 0.0;
    }

    @Override
    public double getMinimumTrailer(SequenceRenderContext ctx) {
        if (this.getLabel() != null) {
            SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
            return super.getMinimumTrailer(subctx);
        }
        return 0.0;
    }

    @Override
    public void paint(Graphics2D g, SequenceRenderContext ctx) {
        if (this.getLabel() != null) {
            SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
            super.paint(g, subctx);
        }
    }

    public SequenceRenderContext contextForLabel(SequenceRenderContext src, String label) {
        Alignment ali = (Alignment)src.getSymbols();
        SymbolList sl = ali.symbolListForLabel(label);
        FeatureHolder features = null;
        if (sl instanceof FeatureHolder) {
            features = (FeatureHolder)sl;
        }
        return new SubSequenceRenderContext(src, sl, features, null);
    }
}

