/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.ImageMap;
import org.biojava.bio.gui.sequence.ImageMapRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.net.URLFactory;

public class BasicImapRenderer
implements ImageMapRenderer,
Serializable {
    private BasicFeatureRenderer renderer;
    private ImageMap imageMap;
    private URLFactory urlFactory;

    public BasicImapRenderer(BasicFeatureRenderer renderer, ImageMap imageMap, URLFactory urlFactory) {
        this.renderer = renderer;
        this.imageMap = imageMap;
        this.urlFactory = urlFactory;
    }

    public ImageMap getImageMap() {
        return this.imageMap;
    }

    public void setImageMap(ImageMap imageMap) {
        this.imageMap = imageMap;
    }

    @Override
    public void renderImageMap(Graphics2D g2, Feature f, SequenceRenderContext context) {
        Rectangle bounds = g2.getDeviceConfiguration().getBounds();
        int mapWidth = (int)bounds.getWidth();
        int mapHeight = (int)bounds.getHeight();
        URL url = this.urlFactory.createURL((Object)f);
        double depth = this.renderer.getDepth(context);
        AffineTransform t = g2.getTransform();
        double transX = t.getTranslateX();
        double transY = t.getTranslateY();
        Location location = f.getLocation();
        Iterator li = location.blockIterator();
        while (li.hasNext()) {
            double height;
            double width;
            double posYN;
            double posXW;
            Location loc = (Location)li.next();
            int min = loc.getMin();
            int max = loc.getMax();
            int dif = max - min;
            if (context.getDirection() == 0) {
                posXW = context.sequenceToGraphics(min);
                posYN = 0.0;
                width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
                height = depth;
            } else {
                posXW = 0.0;
                posYN = context.sequenceToGraphics(min);
                width = depth;
                height = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            }
            int x1 = (int)Math.floor(posXW + transX);
            int y1 = (int)Math.floor(posYN + transY);
            int x2 = (int)Math.floor(posXW + width + transX);
            int y2 = (int)Math.floor(posYN + height + transY);
            if (x1 > mapWidth || y1 > mapHeight || x2 < 0 || y2 < 0) continue;
            x1 = Math.max(x1, 0);
            y1 = Math.max(y1, 0);
            x2 = Math.min(x2, mapWidth);
            y2 = Math.min(y2, mapHeight);
            Integer[] coordinates = new Integer[]{new Integer(x1), new Integer(y1), new Integer(x2), new Integer(y2)};
            this.imageMap.addHotSpot(new ImageMap.HotSpot("rect", url, coordinates, f));
        }
    }

    @Override
    public void renderFeature(Graphics2D g2, Feature f, SequenceRenderContext context) {
        this.renderImageMap(g2, f, context);
        this.renderer.renderFeature(g2, f, context);
    }

    @Override
    public double getDepth(SequenceRenderContext context) {
        return this.renderer.getDepth(context);
    }

    @Override
    public FeatureHolder processMouseEvent(FeatureHolder holder, SequenceRenderContext context, MouseEvent mEvent) {
        return this.renderer.processMouseEvent(holder, context, mEvent);
    }
}

