/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.gui.glyph.ArrowGlyph;
import org.biojava.bio.gui.glyph.Glyph;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ChangeVetoException;

public class GlyphFeatureRenderer
extends FilteringRenderer
implements FeatureRenderer {
    private static final long serialVersionUID = 7005846487574725181L;
    private double depth = 15.0;
    protected List<FeatureFilter> fList = new ArrayList<FeatureFilter>();
    protected List<Glyph> gList = new ArrayList<Glyph>();

    public void addFilterAndGlyph(FeatureFilter ff, Glyph g) throws ChangeVetoException {
        if (!this.fList.contains(ff)) {
            this.fList.add(ff);
            this.gList.add(g);
            if (this.fList.size() == 0) {
                this.setFilter(FeatureFilter.none);
            } else {
                FeatureFilter f = this.fList.get(0);
                if (this.fList.size() > 1) {
                    for (int i = 1; i < this.fList.size(); ++i) {
                        f = new FeatureFilter.Or(f, this.fList.get(i));
                    }
                }
                this.setFilter(f);
            }
        }
    }

    public void removeFilterWithGlyph(FeatureFilter ff) throws ChangeVetoException {
        if (this.fList.contains(ff)) {
            this.gList.remove(this.fList.indexOf(ff));
            this.fList.remove(ff);
            if (this.fList.size() == 0) {
                this.setFilter(FeatureFilter.none);
            } else {
                FeatureFilter f = this.fList.get(0);
                if (this.fList.size() > 1) {
                    for (int i = 1; i < this.fList.size(); ++i) {
                        f = new FeatureFilter.Or(f, this.fList.get(i));
                    }
                }
                this.setFilter(f);
            }
        }
    }

    public FeatureFilter getFeatureFilter(int i) {
        return this.fList.get(i);
    }

    public boolean containsFilter(FeatureFilter ff) {
        return this.fList.contains(ff);
    }

    public void setGlyphForFilter(FeatureFilter ff, Glyph glyph) throws NoSuchElementException {
        if (!this.fList.contains(ff)) {
            throw new NoSuchElementException(ff.toString());
        }
        this.gList.set(this.fList.indexOf(ff), glyph);
    }

    public Glyph getGlyphForFilter(FeatureFilter ff) throws NoSuchElementException {
        if (this.fList.contains(ff)) {
            return this.gList.get(this.fList.indexOf(ff));
        }
        throw new NoSuchElementException(ff.toString());
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    @Override
    public double getDepth(SequenceRenderContext src) {
        return this.depth;
    }

    @Override
    public FeatureHolder processMouseEvent(FeatureHolder fh, SequenceRenderContext src, MouseEvent me) {
        return fh;
    }

    @Override
    public void renderFeature(Graphics2D g2, Feature f, SequenceRenderContext src) {
        float minBounds = (float)src.sequenceToGraphics(f.getLocation().getMin());
        float maxBounds = (float)src.sequenceToGraphics(f.getLocation().getMax() + 1);
        Rectangle2D.Float bounds = new Rectangle2D.Float(minBounds, 0.0f, maxBounds - minBounds, (float)this.depth);
        for (int i = 0; i < this.fList.size(); ++i) {
            if (!this.fList.get(i).accept(f)) continue;
            Glyph g = this.gList.get(i);
            g.setBounds(bounds);
            if (g instanceof ArrowGlyph && f instanceof StrandedFeature) {
                ((ArrowGlyph)g).setDirection(((StrandedFeature)f).getStrand().getValue());
            }
            if (src.getDirection() != 0) continue;
            g.render(g2);
        }
    }
}

