/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import org.biojava.bio.gui.sequence.AbstractBeadRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;

public class RoundRectangularBeadRenderer
extends AbstractBeadRenderer {
    protected RoundRectangle2D rect = new RoundRectangle2D.Double();
    protected double arcWidth;
    protected double arcHeight;

    public RoundRectangularBeadRenderer() {
        this.arcWidth = 5.0;
        this.arcHeight = 5.0;
    }

    public RoundRectangularBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke, double arcWidth, double arcHeight) {
        super(beadDepth, beadDisplacement, beadOutline, beadFill, beadStroke);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    @Override
    public void renderBead(Graphics2D g2, Feature f, SequenceRenderContext context) {
        Location loc = f.getLocation();
        int min = loc.getMin();
        int max = loc.getMax();
        int dif = max - min;
        if (context.getDirection() == 0) {
            double posXW = context.sequenceToGraphics(min);
            double posYN = this.beadDisplacement;
            double width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            double height = Math.min(this.beadDepth, width / 2.0);
            if (height < this.beadDepth) {
                posYN += (this.beadDepth - height) / 2.0;
            }
            this.rect.setRoundRect(posXW, posYN, Math.floor(width), Math.floor(height), this.arcWidth, this.arcHeight);
        } else {
            double posXW = this.beadDisplacement;
            double posYN = context.sequenceToGraphics(min);
            double height = Math.max(((double)dif + 1.0) * context.getScale(), 1.0);
            double width = Math.min(this.beadDepth, height / 2.0);
            if (width < this.beadDepth) {
                posXW += (this.beadDepth - width) / 2.0;
            }
            this.rect.setRoundRect(posXW, posYN, Math.floor(width), Math.floor(height), this.arcWidth, this.arcHeight);
        }
        g2.setPaint(this.beadFill);
        g2.fill(this.rect);
        g2.setStroke(this.beadStroke);
        g2.setPaint(this.beadOutline);
        g2.draw(this.rect);
    }

    @Override
    public double getDepth(SequenceRenderContext context) {
        double maxDepth = super.getDepth(context);
        return Math.max(maxDepth, this.beadDepth + this.beadDisplacement);
    }
}

