/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import org.biojava.bio.gui.sequence.CircularRendererContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.SymbolList;

public class SubCircularRendererContext
implements CircularRendererContext {
    private final CircularRendererContext delegate;
    private final SymbolList symbols;
    private final FeatureHolder features;
    private final double radius;

    public SubCircularRendererContext(CircularRendererContext delegate, SymbolList symbols, FeatureHolder features, double radius) {
        if (delegate == null) {
            throw new NullPointerException("Delegate can not be null");
        }
        this.delegate = delegate;
        this.symbols = symbols;
        this.features = features;
        this.radius = radius;
    }

    @Override
    public double getOffset() {
        return this.delegate.getOffset();
    }

    @Override
    public double getAngle(int indx) {
        return this.delegate.getAngle(indx);
    }

    @Override
    public int getIndex(double angle) {
        return 0;
    }

    @Override
    public double getRadius() {
        if (Double.isNaN(this.radius)) {
            return this.delegate.getRadius();
        }
        return this.radius;
    }

    @Override
    public SymbolList getSymbols() {
        if (this.symbols == null) {
            return this.delegate.getSymbols();
        }
        return this.symbols;
    }

    @Override
    public FeatureHolder getFeatures() {
        if (this.features == null) {
            return this.delegate.getFeatures();
        }
        return this.features;
    }
}

