/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.gui.sequence.GUITools;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;

public class SymbolSequenceRenderer
implements SequenceRenderer {
    private double depth = 25.0;
    private Paint outline = Color.black;

    @Override
    public double getDepth(SequenceRenderContext context) {
        return this.depth + 1.0;
    }

    @Override
    public double getMinimumLeader(SequenceRenderContext context) {
        return 0.0;
    }

    @Override
    public double getMinimumTrailer(SequenceRenderContext context) {
        return 0.0;
    }

    @Override
    public void paint(Graphics2D g2, SequenceRenderContext context) {
        Rectangle prevClip = g2.getClipBounds();
        AffineTransform prevTransform = g2.getTransform();
        g2.setPaint(this.outline);
        Font font = context.getFont();
        Rectangle2D maxCharBounds = font.getMaxCharBounds(g2.getFontRenderContext());
        double scale = context.getScale();
        if (scale >= maxCharBounds.getWidth() * 0.3 && scale >= maxCharBounds.getHeight() * 0.3) {
            double xFontOffset = 0.0;
            double yFontOffset = 0.0;
            if (context.getDirection() == 0) {
                xFontOffset = maxCharBounds.getCenterX() * 0.25;
                yFontOffset = -maxCharBounds.getCenterY() + this.depth * 0.5;
            } else {
                xFontOffset = -maxCharBounds.getCenterX() + this.depth * 0.5;
                yFontOffset = -maxCharBounds.getCenterY() * 3.0;
            }
            SymbolList seq = context.getSymbols();
            SymbolTokenization toke = null;
            try {
                toke = seq.getAlphabet().getTokenization("token");
            }
            catch (Exception ex) {
                throw new BioRuntimeException((Throwable)ex);
            }
            Location visible = GUITools.getVisibleRange(context, g2);
            for (int sPos = visible.getMin(); sPos <= visible.getMax(); ++sPos) {
                double gPos = context.sequenceToGraphics(sPos);
                String s = "?";
                try {
                    s = toke.tokenizeSymbol(seq.symbolAt(sPos));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (context.getDirection() == 0) {
                    g2.drawString(s, (float)(gPos + xFontOffset), (float)yFontOffset);
                    continue;
                }
                g2.drawString(s, (float)xFontOffset, (float)(gPos + yFontOffset));
            }
        }
        g2.setClip(prevClip);
        g2.setTransform(prevTransform);
    }

    @Override
    public SequenceViewerEvent processMouseEvent(SequenceRenderContext context, MouseEvent me, List path) {
        path.add(this);
        int sPos = context.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

