/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;

public class decoratorX {
    private static final int SEQ_NAME_COLUMN = 1;
    private static final int SPECIES_COLUMN = 2;
    private static final int SEQ_COLUMN = 3;
    private static final int TARGET_COLUMN = 4;

    public static void main(String[] args) {
        File intree = null;
        File outtree1 = null;
        File outtree2 = null;
        File intable = null;
        try {
            CommandLineArguments cla = null;
            cla = new CommandLineArguments(args);
            intree = cla.getFile(0);
            intable = cla.getFile(1);
            outtree1 = cla.getFile(2);
            outtree2 = cla.getFile(3);
            if (outtree1.exists()) {
                System.out.println(outtree1 + " already exists");
                System.exit(-1);
            }
            if (outtree2.exists()) {
                System.out.println(outtree2 + " already exists");
                System.exit(-1);
            }
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            Phylogeny phy = factory.create(intree, xml_parser)[0];
            BasicTable<String> t = BasicTableParser.parse(intable, '\t');
            PhylogenyNodeIterator it = phy.iteratorExternalForward();
            int i = 0;
            while (it.hasNext()) {
                PhylogenyNode node = it.next();
                decoratorX.processNode(node, t);
                ++i;
            }
            PhylogenyWriter writer1 = new PhylogenyWriter();
            writer1.toPhyloXML(outtree1, phy, 0);
            PhylogenyNodeIterator it2 = phy.iteratorExternalForward();
            while (it2.hasNext()) {
                PhylogenyNode node = it2.next();
                decoratorX.processNode2(node, phy);
            }
            PhylogenyWriter writer2 = new PhylogenyWriter();
            writer2.toPhyloXML(outtree2, phy, 0);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private static void processNode(PhylogenyNode node, BasicTable<String> t) throws Exception {
        String node_seq = node.getNodeData().getSequence().getMolecularSequence().toUpperCase();
        boolean found = false;
        String found_row = "";
        String found_protein_name = "";
        String found_species = "";
        for (int row = 0; row < t.getNumberOfRows(); ++row) {
            String table_seq = t.getValueAsString(3, row).toUpperCase();
            if (!table_seq.contains(node_seq)) continue;
            if (found) {
                if (!found_protein_name.equals(t.getValueAsString(1, row)) || !found_species.equals(t.getValueAsString(2, row))) {
                    throw new Exception("Sequence from node " + node + " is not unique: " + node_seq + "\nAlready found in row " + found_row);
                }
            } else {
                found = true;
                found_row = t.getRowAsString(row, ", ");
                found_protein_name = t.getValueAsString(1, row);
                found_species = t.getValueAsString(2, row);
            }
            Annotation annotation = new Annotation("target", t.getValueAsString(4, row));
            node.getNodeData().getSequence().addAnnotation(annotation);
            System.out.println(node + "->" + annotation);
        }
    }

    private static void processNode2(PhylogenyNode node, Phylogeny t) {
        if (node.getNodeData().getSequence().getAnnotations() == null || node.getNodeData().getSequence().getAnnotations().isEmpty()) {
            t.deleteSubtree(node, true);
        }
    }
}

