/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class domainloss_replacement {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: domainloss_replacement <phylogeny file> <file with replacement characters>");
                System.exit(-1);
            }
            Phylogeny p = ParserUtils.readPhylogenies(args[0])[0];
            SortedSet<String> replacement_domains = ForesterUtil.file2set(new File(args[1]));
            PhylogenyNodeIterator it = p.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                String name = null;
                name = n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName()) ? n.getNodeData().getTaxonomy().getScientificName() : n.getName();
                TreeSet<String> lost_chars = new TreeSet<String>();
                while (!n.isRoot()) {
                    lost_chars.addAll(n.getNodeData().getBinaryCharacters().getLostCharacters());
                    n = n.getParent();
                }
                int losses = lost_chars.size();
                lost_chars.retainAll(replacement_domains);
                int intersection = lost_chars.size();
                double percentage = 100.0 * (double)intersection / (double)losses;
                System.out.println(name + "\t" + intersection + "\t" + losses + "\t" + ForesterUtil.round(percentage, 3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

