/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class get_shared_chars {
    public static final boolean DEBUG = true;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println();
            System.err.println("get_subtree_specific_chars: wrong number of arguments");
            System.err.println("Usage: \"get_shared_chars <intree> <subtree 1> <subtree 2> ... <subtree n>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<Long> outside_external_ids = get_shared_chars.getAllExternalDescendantsNodeIds(phy.getRoot());
        SortedSet<String> all_chars = get_shared_chars.getAllExternalPresentAndGainedCharacters(phy.getRoot());
        System.out.println("Sum of all external characters:\t" + all_chars.size());
        TreeSet<String> all_shared_chars = new TreeSet<String>();
        for (int i = 1; i < args.length; ++i) {
            System.out.print(args[i] + "\t");
            PhylogenyNode current_node = phy.getNode(args[i]);
            if (i == 1) {
                all_shared_chars.addAll(get_shared_chars.getAllExternalPresentAndGainedCharacters(current_node));
            } else {
                all_shared_chars.retainAll(get_shared_chars.getAllExternalPresentAndGainedCharacters(current_node));
            }
            outside_external_ids.removeAll(get_shared_chars.getAllExternalDescendantsNodeIds(current_node));
        }
        System.out.println();
        System.out.println("Number of outside nodes: " + outside_external_ids.size());
        TreeSet<String> outside_chars = new TreeSet<String>();
        System.out.println("All shared characters\t" + all_shared_chars.size());
        for (Long id : outside_external_ids) {
            outside_chars.addAll(get_shared_chars.getAllExternalPresentAndGainedCharacters(phy.getNode(id)));
        }
        SortedSet<String> unique_shared_chars = get_shared_chars.copy(all_shared_chars);
        unique_shared_chars.removeAll(outside_chars);
        System.out.println("Unique shared characters\t" + unique_shared_chars.size());
        System.out.println();
        System.out.println("Unique shared characters:");
        for (String unique_shared_char : unique_shared_chars) {
            System.out.println(unique_shared_char);
        }
    }

    private static SortedSet<String> copy(SortedSet<String> set) {
        TreeSet<String> copy = new TreeSet<String>();
        for (String s : set) {
            copy.add(s);
        }
        return copy;
    }

    private static SortedSet<Long> getAllExternalDescendantsNodeIds(PhylogenyNode node) {
        TreeSet<Long> ids = new TreeSet<Long>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            ids.add(desc.getId());
        }
        return ids;
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

