/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class inverted_dcs {
    static final boolean SIMPLE = true;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println();
            System.err.println("inverted_dcs: wrong number of arguments");
            System.err.println("Usage: \"get_subtree_specific_chars <intree>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<String> orig = inverted_dcs.getAllExternalPresentAndGainedCharacters(phy.getRoot());
        System.out.println("total=" + orig.size());
        for (String dc : orig) {
            String[] split = dc.split("=");
            String inv = split[1] + "=" + split[0];
            if (!orig.contains(inv)) continue;
            System.out.println(dc);
        }
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

