/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class subtree_feature_count {
    private static final String MIN_DISTANCE_TO_ROOT_OPTION = "d";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_DATE = "131120";
    private static final String PRG_DESC = "";
    private static final String PRG_NAME = "subtree_feature_count";
    private static final String PRG_VERSION = "0.90";
    private static final String WWW = "sites.google.com/site/cmzmasek/home/software/forester";

    public static void main(String[] args) {
        try {
            double min_distance_to_root;
            CommandLineArguments cla = new CommandLineArguments(args);
            if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length < 2) {
                subtree_feature_count.printHelp();
                System.exit(0);
            }
            ArrayList<String> allowed_options = new ArrayList<String>();
            allowed_options.add(MIN_DISTANCE_TO_ROOT_OPTION);
            String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
            if (dissallowed_options.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
            }
            if ((min_distance_to_root = cla.getOptionValueAsDouble(MIN_DISTANCE_TO_ROOT_OPTION)) <= 0.0) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use min distance to root of: " + min_distance_to_root);
            }
            File intree_file = cla.getFile(0);
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phy = factory.create(intree_file, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
            subtree_feature_count.execute(phy, min_distance_to_root);
        }
        catch (Exception e) {
            e.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static final void execute(Phylogeny phy, double min_distance_to_root) {
        List<List<PhylogenyNode>> ll = PhylogenyMethods.divideIntoSubTrees(phy, min_distance_to_root);
        for (List<PhylogenyNode> l : ll) {
            int xray = 0;
            int nmr = 0;
            int model = 0;
            for (PhylogenyNode node : l) {
                Sequence seq;
                SortedSet<Accession> xrefs;
                if (!node.getNodeData().isHasSequence() || ForesterUtil.isEmpty(xrefs = (seq = node.getNodeData().getSequence()).getCrossReferences())) continue;
                for (Accession xref : xrefs) {
                    if (!xref.getSource().equalsIgnoreCase("pdb")) continue;
                    if (xref.getComment().equalsIgnoreCase("x-ray") || xref.getComment().equalsIgnoreCase("xray")) {
                        ++xray;
                    }
                    if (xref.getComment().equalsIgnoreCase("nmr")) {
                        ++nmr;
                    }
                    if (!xref.getComment().equalsIgnoreCase("model")) continue;
                    ++model;
                }
            }
            int n = l.size();
            double xray_p = ForesterUtil.round(100.0 * (double)xray / (double)n, 1);
            double nmr_p = ForesterUtil.round(100.0 * (double)nmr / (double)n, 1);
            double model_p = ForesterUtil.round(100.0 * (double)model / (double)n, 1);
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(n));
            sb.append("\t");
            sb.append(String.valueOf(xray));
            sb.append("\t");
            sb.append(String.valueOf(nmr));
            sb.append("\t");
            sb.append(String.valueOf(model));
            sb.append("\t");
            sb.append(String.valueOf(xray_p));
            sb.append("\t");
            sb.append(String.valueOf(nmr_p));
            sb.append("\t");
            sb.append(String.valueOf(model_p));
            System.out.println(sb);
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.print("Usage: ");
        System.out.println("subtree_feature_count -d=<min distance to root> <intree>");
        System.out.println();
        System.out.println();
    }
}

