/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

final class ControlPanel
extends JPanel
implements ActionListener {
    static final Font jcb_bold_font = new Font(Configuration.getDefaultFontFamilyName(), 1, 9);
    static final Font jcb_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    static final Font js_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    private static final String RETURN_TO_SUPER_TREE_TEXT = "Back to Super Tree";
    private static final String SEARCH_TIP_TEXT = "Enter text to search for. Use ',' for logical OR and '+' for logical AND (not used in this manner for regular expression searches).";
    private static final long serialVersionUID = -8463483932821545633L;
    private NodeClickAction _action_when_node_clicked;
    private int _add_new_node_item;
    private Map<Integer, String> _all_click_to_names;
    private Map<String, Color> _annotation_colors;
    private int _blast_item;
    private JComboBox<String> _click_to_combobox;
    private JLabel _click_to_label;
    private List<String> _click_to_names;
    private int _collapse_cb_item;
    private JCheckBox _color_acc_species;
    private JCheckBox _color_acc_sequence;
    private JCheckBox _color_according_to_annotation;
    private boolean _color_branches;
    private JCheckBox _use_visual_styles_cb;
    private int _color_subtree_cb_item;
    private int _change_node_font_item;
    private final Configuration _configuration;
    private int _copy_subtree_item;
    private int _cut_subtree_item;
    private JButton _decr_domain_structure_evalue_thr;
    private int _delete_node_or_subtree_item;
    private JCheckBox _display_as_phylogram_cb;
    private JCheckBox _display_internal_data;
    private JLabel _domain_display_label;
    private JTextField _domain_structure_evalue_thr_tf;
    private List<Boolean> _draw_phylogram;
    private JCheckBox _dynamically_hide_data;
    private int _edit_node_data_item;
    private int _get_ext_desc_data;
    private JButton _incr_domain_structure_evalue_thr;
    private final MainPanel _mainpanel;
    private JCheckBox _node_desc_popup_cb;
    private int _open_pdb_item;
    private int _open_seq_web_item;
    private int _open_tax_web_item;
    private int _color_node_font_item;
    private JButton _order;
    private boolean _order_of_appearance;
    private int _paste_subtree_item;
    private int _reroot_cb_item;
    private JButton _return_to_super_tree;
    private JLabel _search_found_label_0;
    private JLabel _search_found_label_1;
    private JButton _search_reset_button_0;
    private JButton _search_reset_button_1;
    private JTextField _search_tf_0;
    private JTextField _search_tf_1;
    private int _select_nodes_item;
    private Sequence _selected_query_seq;
    private JCheckBox _seq_relation_confidence_switch;
    private JComboBox<SequenceRelation.SEQUENCE_RELATION_TYPE> _sequence_relation_type_box;
    private JCheckBox _show_annotation;
    private JCheckBox _show_binary_character_counts;
    private JCheckBox _show_binary_characters;
    private int _show_data_item;
    private JCheckBox _show_domain_architectures;
    private JCheckBox _show_mol_seqs;
    private JCheckBox _write_branch_length_values;
    private JCheckBox _show_events;
    private JCheckBox _show_gene_names;
    private JCheckBox _show_node_names;
    private JCheckBox _show_properties_cb;
    private JCheckBox _show_seq_names;
    private JCheckBox _show_seq_symbols;
    private JCheckBox _show_sequence_acc;
    private JComboBox<String> _show_sequence_relations;
    private JCheckBox _show_taxo_code;
    private JCheckBox _show_taxo_common_names;
    private JCheckBox _show_taxo_images_cb;
    private JCheckBox _show_taxo_scientific_names;
    private JCheckBox _show_vector_data_cb;
    private JButton _show_whole;
    private int _sort_descendents_item;
    private Map<String, Color> _species_colors;
    private Map<String, Color> _sequence_colors;
    private int _subtree_cb_item;
    private int _swap_cb_item;
    private JButton _uncollapse_all;
    private JCheckBox _width_branches;
    private JCheckBox _write_confidence;
    private JButton _zoom_in_domain_structure;
    private JButton _zoom_in_x;
    private JButton _zoom_in_y;
    private JLabel _zoom_label;
    private JButton _zoom_out_domain_structure;
    private JButton _zoom_out_x;
    private JButton _zoom_out_y;

    ControlPanel(MainPanel ap, Configuration configuration) {
        this.init();
        this._mainpanel = ap;
        this._configuration = configuration;
        if (!this._configuration.isUseNativeUI()) {
            this.setBackground(this.getConfiguration().getGuiBackgroundColor());
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this._order_of_appearance = true;
        this.setupControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            TreePanel tp;
            if (e.getSource() == this._color_acc_sequence) {
                if (this._color_acc_species != null) {
                    this._color_acc_species.setSelected(false);
                }
            } else if (e.getSource() == this._color_acc_species && this._color_acc_sequence != null) {
                this._color_acc_sequence.setSelected(false);
            }
            if ((tp = this.getMainPanel().getCurrentTreePanel()) == null) {
                return;
            }
            if (e.getSource() == this._click_to_combobox) {
                this.setClickToAction(this._click_to_combobox.getSelectedIndex());
                this.getCurrentTreePanel().repaint();
            } else if (e.getSource() == this._show_binary_characters) {
                if (this._show_binary_character_counts != null && this._show_binary_characters.isSelected()) {
                    this._show_binary_character_counts.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (e.getSource() == this._show_binary_character_counts) {
                if (this._show_binary_characters != null && this._show_binary_character_counts.isSelected()) {
                    this._show_binary_characters.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (e.getSource() == this._show_domain_architectures) {
                this.search0();
                this.search1();
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (tp != null && tp.getPhylogeny() != null) {
                if (e.getSource() == this.getDisplayAsPhylogramCb()) {
                    this.setDrawPhylogram(this.getDisplayAsPhylogramCb().isSelected());
                    this.showWhole();
                } else if (e.getSource() == this._zoom_in_x) {
                    this.zoomInX(1.25f, 1.2f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_in_y) {
                    this.zoomInY(1.25f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_out_x) {
                    this.zoomOutX(0.8f, 0.8333333f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_out_y) {
                    this.zoomOutY(0.8f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._show_whole) {
                    this.displayedPhylogenyMightHaveChanged(true);
                    this.showWhole();
                } else if (e.getSource() == this._return_to_super_tree) {
                    this._mainpanel.getCurrentTreePanel().superTree();
                    this.showWhole();
                } else if (e.getSource() == this._order) {
                    PhylogenyMethods.DESCENDANT_SORT_PRIORITY pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
                    if (this.isShowTaxonomyScientificNames() || this.isShowTaxonomyCode()) {
                        pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
                    } else if (this.isShowSeqNames() || this.isShowSeqSymbols() || this.isShowGeneNames()) {
                        pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
                    }
                    PhylogenyMethods.orderAppearance(tp.getPhylogeny().getRoot(), this._order_of_appearance, true, pri);
                    this._order_of_appearance = !this._order_of_appearance;
                    tp.setNodeInPreorderToNull();
                    tp.getPhylogeny().externalNodesHaveChanged();
                    tp.getPhylogeny().clearHashIdToNodeMap();
                    tp.getPhylogeny().recalculateNumberOfExternalDescendants(true);
                    tp.resetNodeIdToDistToLeafMap();
                    tp.setEdited(true);
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._uncollapse_all) {
                    this.uncollapseAll(tp);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_in_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomInDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._zoom_out_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomOutDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._decr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().decreaseDomainStructureEvalueThresholdExp();
                    this.search0();
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._incr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().increaseDomainStructureEvalueThresholdExp();
                    this.search0();
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._search_tf_0) {
                    this.search0();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._search_tf_1) {
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (this._dynamically_hide_data != null && e.getSource() == this._dynamically_hide_data && !this._dynamically_hide_data.isSelected()) {
                    this.setDynamicHidingIsOn(false);
                    this.displayedPhylogenyMightHaveChanged(true);
                } else {
                    this.displayedPhylogenyMightHaveChanged(true);
                }
            }
            tp.requestFocus();
            tp.requestFocusInWindow();
            tp.requestFocus();
        }
        catch (Exception ex) {
            AptxUtil.unexpectedException(ex);
        }
        catch (Error err) {
            AptxUtil.unexpectedError(err);
        }
    }

    public JCheckBox getColorAccSequenceCb() {
        return this._color_acc_sequence;
    }

    public JCheckBox getColorAccSpeciesCb() {
        return this._color_acc_species;
    }

    public JCheckBox getDisplayAsPhylogramCb() {
        return this._display_as_phylogram_cb;
    }

    public JCheckBox getDynamicallyHideData() {
        return this._dynamically_hide_data;
    }

    public JCheckBox getNodeDescPopupCb() {
        return this._node_desc_popup_cb;
    }

    public Sequence getSelectedQuerySequence() {
        return this._selected_query_seq;
    }

    public JComboBox<String> getSequenceRelationBox() {
        if (this._show_sequence_relations == null) {
            this._show_sequence_relations = new JComboBox();
            this._show_sequence_relations.setFocusable(false);
            this._show_sequence_relations.setMaximumRowCount(20);
            this._show_sequence_relations.setFont(js_font);
            if (!this._configuration.isUseNativeUI()) {
                this._show_sequence_relations.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
                this._show_sequence_relations.setForeground(this.getConfiguration().getGuiButtonTextColor());
            }
            this._show_sequence_relations.addItem("-----");
            this._show_sequence_relations.setToolTipText("To display orthology information for selected query");
        }
        return this._show_sequence_relations;
    }

    public JComboBox<SequenceRelation.SEQUENCE_RELATION_TYPE> getSequenceRelationTypeBox() {
        if (this._sequence_relation_type_box == null) {
            this._sequence_relation_type_box = new JComboBox();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE type : SequenceRelation.SEQUENCE_RELATION_TYPE.values()) {
                this._sequence_relation_type_box.addItem(type);
            }
            this._sequence_relation_type_box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ControlPanel.this._mainpanel.getCurrentPhylogeny() != null) {
                        ControlPanel.this.setSequenceRelationQueries(ControlPanel.this.getMainPanel().getCurrentPhylogeny().getSequenceRelationQueries());
                    }
                }
            });
        }
        return this._sequence_relation_type_box;
    }

    public JCheckBox getShowEventsCb() {
        return this._show_events;
    }

    public JCheckBox getUseVisualStylesCb() {
        return this._use_visual_styles_cb;
    }

    public JCheckBox getWriteConfidenceCb() {
        return this._write_confidence;
    }

    public boolean isShowMolSequences() {
        return this._show_mol_seqs != null && this._show_mol_seqs.isSelected();
    }

    public boolean isShowProperties() {
        return this._show_properties_cb != null && this._show_properties_cb.isSelected();
    }

    public boolean isShowTaxonomyImages() {
        return this._show_taxo_images_cb != null && this._show_taxo_images_cb.isSelected();
    }

    public boolean isShowVectorData() {
        return this._show_vector_data_cb != null && this._show_vector_data_cb.isSelected();
    }

    public void setSequenceRelationQueries(Collection<Sequence> sequenceRelationQueries) {
        JComboBox<String> box = this.getSequenceRelationBox();
        while (box.getItemCount() > 1) {
            box.removeItemAt(1);
        }
        final HashMap<String, Sequence> sequencesByName = new HashMap<String, Sequence>();
        SequenceRelation.SEQUENCE_RELATION_TYPE relationType = (SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)this._sequence_relation_type_box.getSelectedItem());
        if (relationType == null) {
            return;
        }
        ArrayList<String> sequenceNamesToAdd = new ArrayList<String>();
        for (Sequence seq : sequenceRelationQueries) {
            if (!seq.hasSequenceRelations()) continue;
            boolean fFoundForCurrentType = false;
            for (SequenceRelation sq : seq.getSequenceRelations()) {
                if (!sq.getType().equals((Object)relationType)) continue;
                fFoundForCurrentType = true;
                break;
            }
            if (!fFoundForCurrentType) continue;
            sequenceNamesToAdd.add(seq.getName());
            sequencesByName.put(seq.getName(), seq);
        }
        String[] sequenceNameArray = sequenceNamesToAdd.toArray(new String[sequenceNamesToAdd.size()]);
        Arrays.sort(sequenceNameArray, String.CASE_INSENSITIVE_ORDER);
        for (String seqName : sequenceNameArray) {
            box.addItem(seqName);
        }
        for (ItemListener oldItemListener : box.getItemListeners()) {
            box.removeItemListener(oldItemListener);
        }
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ControlPanel.this._selected_query_seq = (Sequence)sequencesByName.get(e.getItem());
                ControlPanel.this._mainpanel.getCurrentTreePanel().repaint();
            }
        });
    }

    private void addClickToOption(int which, String title) {
        this._click_to_combobox.addItem(title);
        this._click_to_names.add(title);
        this._all_click_to_names.put(new Integer(which), title);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._click_to_combobox.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
    }

    private void addSequenceRelationBlock() {
        JLabel spacer = new JLabel("");
        spacer.setSize(1, 1);
        this.add(spacer);
        JLabel mainLabel = new JLabel("Sequence relations to display");
        JLabel typeLabel = ControlPanel.customizeLabel(new JLabel("(type) "), this.getConfiguration());
        typeLabel.setFont(js_font.deriveFont(7));
        this.getSequenceRelationTypeBox().setFocusable(false);
        this._sequence_relation_type_box.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._sequence_relation_type_box.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._sequence_relation_type_box.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        this._sequence_relation_type_box.setRenderer((ListCellRenderer<SequenceRelation.SEQUENCE_RELATION_TYPE>)new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = new DefaultListCellRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null && value instanceof SequenceRelation.SEQUENCE_RELATION_TYPE) {
                    ((DefaultListCellRenderer)component).setText(SequenceRelation.getPrintableNameByType((SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)value)));
                }
                return component;
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        this._sequence_relation_type_box.setMinimumSize(new Dimension(115, 17));
        this._sequence_relation_type_box.setPreferredSize(new Dimension(115, 20));
        JPanel horizGrid = new JPanel(gbl);
        horizGrid.setBackground(this.getBackground());
        horizGrid.add(typeLabel);
        horizGrid.add(this._sequence_relation_type_box);
        this.add(ControlPanel.customizeLabel(mainLabel, this.getConfiguration()));
        this.add(horizGrid);
        this.add(this.getSequenceRelationBox());
        if (this._configuration.doDisplayOption(22)) {
            this.addCheckbox(22, this._configuration.getDisplayTitle(22));
            this.setCheckbox(22, this._configuration.doCheckOption(22));
        }
    }

    private List<Boolean> getIsDrawPhylogramList() {
        return this._draw_phylogram;
    }

    private final MainFrame getMainFrame() {
        MainFrame mf = this.getMainPanel().getMainFrame();
        if (mf == null) {
            ArchaeopteryxE e = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
            if (e.getMainPanel() == null) {
                return null;
            }
            mf = e.getMainPanel().getMainFrame();
        }
        return mf;
    }

    private void init() {
        this._draw_phylogram = new ArrayList<Boolean>();
        this.setSpeciesColors(new HashMap<String, Color>());
        this.setSequenceColors(new HashMap<String, Color>());
        this.setAnnotationColors(new HashMap<String, Color>());
    }

    private boolean isDrawPhylogram(int index) {
        return this.getIsDrawPhylogramList().get(index);
    }

    private void search0(MainPanel main_panel, Phylogeny tree, String query_str) {
        this.getSearchFoundCountsLabel0().setVisible(true);
        this.getSearchResetButton0().setEnabled(true);
        this.getSearchResetButton0().setVisible(true);
        String[] queries = null;
        HashSet<PhylogenyNode> nodes = null;
        queries = query_str.indexOf(44) >= 0 && !this.getOptions().isSearchWithRegex() ? query_str.split(",+") : new String[]{query_str.trim()};
        if (queries != null && queries.length > 0) {
            nodes = new HashSet<PhylogenyNode>();
            for (String string : queries) {
                if (ForesterUtil.isEmpty(string)) continue;
                String string2 = string.trim();
                TreePanel tp = this.getMainPanel().getCurrentTreePanel();
                if (string2.indexOf(43) > 0 && !this.getOptions().isSearchWithRegex()) {
                    nodes.addAll(PhylogenyMethods.searchDataLogicalAnd(string2.split("\\++"), tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.isShowDomainArchitectures(), tp != null ? Math.pow(10.0, tp.getDomainStructureEvalueThresholdExp()) : 0.0));
                    continue;
                }
                nodes.addAll(PhylogenyMethods.searchData(string2, tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.getOptions().isSearchWithRegex(), this.isShowDomainArchitectures(), tp != null ? Math.pow(10.0, tp.getDomainStructureEvalueThresholdExp()) : 0.0));
            }
            if (this.getOptions().isInverseSearchResult()) {
                List<PhylogenyNode> all = PhylogenyMethods.obtainAllNodesAsList(tree);
                all.removeAll(nodes);
                nodes = new HashSet();
                nodes.addAll(all);
            }
        }
        if (nodes != null && nodes.size() > 0) {
            main_panel.getCurrentTreePanel().setFoundNodes0(new HashSet<Long>());
            for (PhylogenyNode node : nodes) {
                main_panel.getCurrentTreePanel().getFoundNodes0().add(node.getId());
            }
            this.setSearchFoundCountsOnLabel0(nodes.size());
        } else {
            this.setSearchFoundCountsOnLabel0(0);
            this.searchReset0();
        }
    }

    private void search1(MainPanel main_panel, Phylogeny tree, String query_str) {
        this.getSearchFoundCountsLabel1().setVisible(true);
        this.getSearchResetButton1().setEnabled(true);
        this.getSearchResetButton1().setVisible(true);
        String[] queries = null;
        HashSet<PhylogenyNode> nodes = null;
        queries = query_str.indexOf(44) >= 0 && !this.getOptions().isSearchWithRegex() ? query_str.split(",+") : new String[]{query_str.trim()};
        if (queries != null && queries.length > 0) {
            nodes = new HashSet<PhylogenyNode>();
            for (String string : queries) {
                if (ForesterUtil.isEmpty(string)) continue;
                String string2 = string.trim();
                TreePanel tp = this.getMainPanel().getCurrentTreePanel();
                if (string2.indexOf(43) > 0 && !this.getOptions().isSearchWithRegex()) {
                    nodes.addAll(PhylogenyMethods.searchDataLogicalAnd(string2.split("\\++"), tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.isShowDomainArchitectures(), tp != null ? Math.pow(10.0, tp.getDomainStructureEvalueThresholdExp()) : 0.0));
                    continue;
                }
                nodes.addAll(PhylogenyMethods.searchData(string2, tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.getOptions().isSearchWithRegex(), this.isShowDomainArchitectures(), tp != null ? Math.pow(10.0, tp.getDomainStructureEvalueThresholdExp()) : 0.0));
            }
            if (this.getOptions().isInverseSearchResult()) {
                List<PhylogenyNode> all = PhylogenyMethods.obtainAllNodesAsList(tree);
                all.removeAll(nodes);
                nodes = new HashSet();
                nodes.addAll(all);
            }
        }
        if (nodes != null && nodes.size() > 0) {
            main_panel.getCurrentTreePanel().setFoundNodes1(new HashSet<Long>());
            for (PhylogenyNode node : nodes) {
                main_panel.getCurrentTreePanel().getFoundNodes1().add(node.getId());
            }
            this.setSearchFoundCountsOnLabel1(nodes.size());
        } else {
            this.setSearchFoundCountsOnLabel1(0);
            this.searchReset1();
        }
    }

    private void setDrawPhylogram(int index, boolean b) {
        this.getIsDrawPhylogramList().set(index, b);
    }

    private void setupClickToOptions() {
        int default_option = this._configuration.getDefaultDisplayClicktoOption();
        int selected_index = 0;
        int cb_index = 0;
        if (this._configuration.doDisplayClickToOption(0)) {
            this._show_data_item = cb_index;
            this.addClickToOption(0, this._configuration.getClickToTitle(0));
            if (default_option == 0) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(1)) {
            this._collapse_cb_item = cb_index;
            this.addClickToOption(1, this._configuration.getClickToTitle(1));
            if (default_option == 1) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(2)) {
            this._reroot_cb_item = cb_index;
            this.addClickToOption(2, this._configuration.getClickToTitle(2));
            if (default_option == 2) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(3)) {
            this._subtree_cb_item = cb_index;
            this.addClickToOption(3, this._configuration.getClickToTitle(3));
            if (default_option == 3) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(4)) {
            this._swap_cb_item = cb_index;
            this.addClickToOption(4, this._configuration.getClickToTitle(4));
            if (default_option == 4) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(18)) {
            this._sort_descendents_item = cb_index;
            this.addClickToOption(18, this._configuration.getClickToTitle(18));
            if (default_option == 18) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(5)) {
            this._color_node_font_item = cb_index;
            this.addClickToOption(5, this._configuration.getClickToTitle(5));
            if (default_option == 5) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(6)) {
            this._change_node_font_item = cb_index;
            this.addClickToOption(6, this._configuration.getClickToTitle(6));
            if (default_option == 6) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(7)) {
            this._color_subtree_cb_item = cb_index;
            this.addClickToOption(7, this._configuration.getClickToTitle(7));
            if (default_option == 7) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(8)) {
            this._open_seq_web_item = cb_index;
            this.addClickToOption(8, this._configuration.getClickToTitle(8));
            if (default_option == 8) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(9)) {
            this._open_pdb_item = cb_index;
            this.addClickToOption(9, this._configuration.getClickToTitle(9));
            if (default_option == 9) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(10)) {
            this._open_tax_web_item = cb_index;
            this.addClickToOption(10, this._configuration.getClickToTitle(10));
            if (default_option == 10) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(11)) {
            this._blast_item = cb_index;
            this.addClickToOption(11, this._configuration.getClickToTitle(11));
            if (default_option == 11) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(20)) {
            this._select_nodes_item = cb_index;
            this.addClickToOption(20, this._configuration.getClickToTitle(20));
            if (default_option == 20) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(19)) {
            this._get_ext_desc_data = cb_index;
            if (!ForesterUtil.isEmpty(this.getConfiguration().getLabelForGetExtDescendentsData())) {
                this.addClickToOption(19, this.getConfiguration().getLabelForGetExtDescendentsData());
            } else {
                this.addClickToOption(19, this.getConfiguration().getClickToTitle(19));
            }
            if (default_option == 19) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.getOptions().isEditable()) {
            if (this._configuration.doDisplayClickToOption(12)) {
                this._cut_subtree_item = cb_index;
                this.addClickToOption(12, this._configuration.getClickToTitle(12));
                if (default_option == 12) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(13)) {
                this._copy_subtree_item = cb_index;
                this.addClickToOption(13, this._configuration.getClickToTitle(13));
                if (default_option == 13) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(14)) {
                this._paste_subtree_item = cb_index;
                this.addClickToOption(14, this._configuration.getClickToTitle(14));
                if (default_option == 14) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(15)) {
                this._delete_node_or_subtree_item = cb_index;
                this.addClickToOption(15, this._configuration.getClickToTitle(15));
                if (default_option == 15) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(16)) {
                this._add_new_node_item = cb_index;
                this.addClickToOption(16, this._configuration.getClickToTitle(16));
                if (default_option == 16) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(17)) {
                this._edit_node_data_item = cb_index;
                this.addClickToOption(17, this._configuration.getClickToTitle(17));
                if (default_option == 17) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
        }
        this._click_to_combobox.setSelectedIndex(selected_index);
        this.setClickToAction(selected_index);
    }

    private void setupDisplayCheckboxes() {
        if (this._configuration.doDisplayOption(0)) {
            this.addCheckbox(0, this._configuration.getDisplayTitle(0));
            this.setCheckbox(0, this._configuration.doCheckOption(0));
        }
        if (this._configuration.doDisplayOption(16)) {
            this.addCheckbox(16, this._configuration.getDisplayTitle(16));
            this.setCheckbox(16, this._configuration.doCheckOption(16));
        }
        if (this._configuration.doDisplayOption(21)) {
            this.addCheckbox(21, this._configuration.getDisplayTitle(21));
            this.setCheckbox(21, this._configuration.doCheckOption(21));
        }
        if (this._configuration.doDisplayOption(15)) {
            this.addCheckbox(15, this._configuration.getDisplayTitle(15));
            this.setCheckbox(15, this._configuration.doCheckOption(15));
        }
        if (this._configuration.doDisplayOption(7)) {
            this.addCheckbox(7, this._configuration.getDisplayTitle(7));
            this.setCheckbox(7, this._configuration.doCheckOption(7));
        }
        if (this._configuration.doDisplayOption(6)) {
            this.addCheckbox(6, this._configuration.getDisplayTitle(6));
            this.setCheckbox(6, this._configuration.doCheckOption(6));
        }
        if (this._configuration.doDisplayOption(19)) {
            this.addCheckbox(19, this._configuration.getDisplayTitle(19));
            this.setCheckbox(19, this._configuration.doCheckOption(19));
        }
        if (this._configuration.doDisplayOption(8)) {
            this.addCheckbox(8, this._configuration.getDisplayTitle(8));
            this.setCheckbox(8, this._configuration.doCheckOption(8));
        }
        if (this._configuration.doDisplayOption(9)) {
            this.addCheckbox(9, this._configuration.getDisplayTitle(9));
            this.setCheckbox(9, this._configuration.doCheckOption(9));
        }
        JLabel label = new JLabel("Display Data:");
        label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            label.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(label);
        if (this._configuration.doDisplayOption(1)) {
            this.addCheckbox(1, this._configuration.getDisplayTitle(1));
            this.setCheckbox(1, this._configuration.doCheckOption(1));
        }
        if (this._configuration.doDisplayOption(2)) {
            this.addCheckbox(2, this._configuration.getDisplayTitle(2));
            this.setCheckbox(2, this._configuration.doCheckOption(2));
        }
        if (this._configuration.doDisplayOption(17)) {
            this.addCheckbox(17, this._configuration.getDisplayTitle(17));
            this.setCheckbox(17, this._configuration.doCheckOption(17));
        }
        if (this._configuration.doDisplayOption(18)) {
            this.addCheckbox(18, this._configuration.getDisplayTitle(18));
            this.setCheckbox(18, this._configuration.doCheckOption(18));
        }
        if (this._configuration.doDisplayOption(13)) {
            this.addCheckbox(13, this._configuration.getDisplayTitle(13));
            this.setCheckbox(13, this._configuration.doCheckOption(13));
        }
        if (this._configuration.doDisplayOption(26)) {
            this.addCheckbox(26, this._configuration.getDisplayTitle(26));
            this.setCheckbox(26, this._configuration.doCheckOption(26));
        }
        if (this._configuration.doDisplayOption(20)) {
            this.addCheckbox(20, this._configuration.getDisplayTitle(20));
            this.setCheckbox(20, this._configuration.doCheckOption(20));
        }
        if (this._configuration.doDisplayOption(14)) {
            this.addCheckbox(14, this._configuration.getDisplayTitle(14));
            this.setCheckbox(14, this._configuration.doCheckOption(14));
        }
        if (this._configuration.doDisplayOption(3)) {
            this.addCheckbox(3, this._configuration.getDisplayTitle(3));
            this.setCheckbox(3, this._configuration.doCheckOption(3));
        }
        if (this._configuration.doDisplayOption(4)) {
            this.addCheckbox(4, this._configuration.getDisplayTitle(4));
            this.setCheckbox(4, this._configuration.doCheckOption(4));
        }
        if (this._configuration.doDisplayOption(28)) {
            this.addCheckbox(28, this._configuration.getDisplayTitle(28));
            this.setCheckbox(28, this._configuration.doCheckOption(28));
        }
        if (this._configuration.doDisplayOption(11)) {
            this.addCheckbox(11, this._configuration.getDisplayTitle(11));
            this.setCheckbox(11, this._configuration.doCheckOption(11));
        }
        if (this._configuration.doDisplayOption(12)) {
            this.addCheckbox(12, this._configuration.getDisplayTitle(12));
            this.setCheckbox(12, this._configuration.doCheckOption(12));
        }
        if (this._configuration.doDisplayOption(10)) {
            this.addCheckbox(10, this._configuration.getDisplayTitle(10));
            this.setCheckbox(10, this._configuration.doCheckOption(10));
        }
        if (this._configuration.doDisplayOption(27)) {
            this.addCheckbox(27, this._configuration.getDisplayTitle(27));
            this.setCheckbox(27, this._configuration.doCheckOption(27));
        }
        if (this._configuration.doDisplayOption(5)) {
            this.addCheckbox(5, this._configuration.getDisplayTitle(5));
            this.setCheckbox(5, this._configuration.doCheckOption(5));
        }
        if (this._configuration.doDisplayOption(23)) {
            this.addCheckbox(23, this._configuration.getDisplayTitle(23));
            this.setCheckbox(23, this._configuration.doCheckOption(23));
        }
        if (this._configuration.doDisplayOption(25)) {
            this.addCheckbox(25, this._configuration.getDisplayTitle(25));
            this.setCheckbox(25, this._configuration.doCheckOption(25));
        }
        if (this._configuration.doDisplayOption(24)) {
            this.addCheckbox(24, this._configuration.getDisplayTitle(24));
            this.setCheckbox(24, this._configuration.doCheckOption(24));
        }
    }

    private void setVisibilityOfDomainStrucureControls() {
        MainFrame mf;
        if (this._zoom_in_domain_structure != null && (mf = this.getMainFrame()) != null) {
            if (this.isShowDomainArchitectures()) {
                this._domain_display_label.setVisible(true);
                this._zoom_in_domain_structure.setVisible(true);
                this._zoom_out_domain_structure.setVisible(true);
                this._decr_domain_structure_evalue_thr.setVisible(true);
                this._incr_domain_structure_evalue_thr.setVisible(true);
                this._domain_structure_evalue_thr_tf.setVisible(true);
                if (mf._right_line_up_domains_cbmi != null) {
                    mf._right_line_up_domains_cbmi.setVisible(true);
                }
                if (mf._show_domain_labels != null) {
                    mf._show_domain_labels.setVisible(true);
                }
            } else {
                this._domain_display_label.setVisible(false);
                this._zoom_in_domain_structure.setVisible(false);
                this._zoom_out_domain_structure.setVisible(false);
                this._decr_domain_structure_evalue_thr.setVisible(false);
                this._incr_domain_structure_evalue_thr.setVisible(false);
                this._domain_structure_evalue_thr_tf.setVisible(false);
                if (mf._right_line_up_domains_cbmi != null) {
                    mf._right_line_up_domains_cbmi.setVisible(false);
                }
                if (mf._show_domain_labels != null) {
                    mf._show_domain_labels.setVisible(false);
                }
            }
        }
    }

    void activateButtonToReturnToSuperTree(int index) {
        if (--index > 0) {
            this._return_to_super_tree.setText("Back to Super Tree " + index);
        } else {
            this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        }
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        this._return_to_super_tree.setEnabled(true);
    }

    void addButtons() {
        JLabel spacer = new JLabel("");
        spacer.setOpaque(false);
        this.add(spacer);
        JPanel x_panel = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel y_panel = new JPanel(new GridLayout(1, 3, 0, 0));
        JPanel z_panel = new JPanel(new GridLayout(1, 1, 0, 0));
        if (!this.getConfiguration().isUseNativeUI()) {
            x_panel.setBackground(this.getBackground());
            y_panel.setBackground(this.getBackground());
            z_panel.setBackground(this.getBackground());
        }
        this._zoom_label = new JLabel("Zoom:");
        this.add(this._zoom_label);
        ControlPanel.customizeLabel(this._zoom_label, this.getConfiguration());
        this.add(x_panel);
        this.add(y_panel);
        this.add(z_panel);
        if (this.getConfiguration().isUseNativeUI()) {
            this._zoom_in_x = new JButton("+");
            this._zoom_out_x = new JButton("-");
        } else {
            this._zoom_in_x = new JButton("X+");
            this._zoom_out_x = new JButton("X-");
        }
        this._zoom_in_y = new JButton("Y+");
        this._zoom_out_y = new JButton("Y-");
        this._show_whole = new JButton("F");
        this._show_whole.setToolTipText("To fit the complete phylogeny to the current display size [F or Home]");
        this._zoom_in_x.setToolTipText("To zoom in horizontally [Shift+cursor-right]");
        this._zoom_in_y.setToolTipText("To zoom in vertically [Shift+cursor-up]");
        this._zoom_out_x.setToolTipText("To zoom out horizontally [Shift+cursor-left]");
        this._zoom_out_y.setToolTipText("To zoom out vertically [Shift+cursor-down]");
        if (this.getConfiguration().isUseNativeUI() && ForesterUtil.isMac()) {
            this._zoom_out_x.setPreferredSize(new Dimension(55, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(55, 10));
        } else {
            this._zoom_out_x.setPreferredSize(new Dimension(10, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(10, 10));
        }
        this._zoom_out_y.setPreferredSize(new Dimension(10, 10));
        this._zoom_in_y.setPreferredSize(new Dimension(10, 10));
        this._show_whole.setPreferredSize(new Dimension(10, 10));
        this._return_to_super_tree = new JButton(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setEnabled(false);
        this._order = new JButton("Order Subtrees");
        this._uncollapse_all = new JButton("Uncollapse All");
        this.addJButton(this._zoom_in_y, x_panel);
        this.addJButton(this._zoom_out_x, y_panel);
        this.addJButton(this._show_whole, y_panel);
        this.addJButton(this._zoom_in_x, y_panel);
        this.addJButton(this._zoom_out_y, z_panel);
        if (this.getConfiguration().doDisplayOption(10)) {
            this.setUpControlsForDomainStrucures();
        }
        JLabel spacer2 = new JLabel("");
        this.add(spacer2);
        this.addJButton(this._return_to_super_tree, this);
        this.addJButton(this._order, this);
        this.addJButton(this._uncollapse_all, this);
        JLabel spacer3 = new JLabel("");
        this.add(spacer3);
        this.setVisibilityOfDomainStrucureControls();
    }

    void addCheckbox(int which, String title) {
        JPanel ch_panel = new JPanel(new BorderLayout(0, 0));
        switch (which) {
            case 0: {
                this._display_as_phylogram_cb = new JCheckBox(title);
                this.getDisplayAsPhylogramCb().setToolTipText("To switch between phylogram and cladogram display");
                this.addJCheckBox(this.getDisplayAsPhylogramCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 15: {
                this._display_internal_data = new JCheckBox(title);
                this._display_internal_data.setToolTipText("To allow or disallow display of internal labels");
                this.addJCheckBox(this._display_internal_data, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 6: {
                this._color_acc_species = new JCheckBox(title);
                this._color_acc_species.setToolTipText("To colorize node labels as a function of taxonomy");
                this.addJCheckBox(this._color_acc_species, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 7: {
                this._color_acc_sequence = new JCheckBox(title);
                this._color_acc_sequence.setToolTipText("To colorize node labels as a function of sequence name");
                this.addJCheckBox(this._color_acc_sequence, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 19: {
                this._color_according_to_annotation = new JCheckBox(title);
                this._color_according_to_annotation.setToolTipText("To colorize sequence annotation labels as a function of sequence annotation");
                this.addJCheckBox(this._color_according_to_annotation, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 1: {
                this._show_node_names = new JCheckBox(title);
                this.addJCheckBox(this._show_node_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 17: {
                this._show_taxo_scientific_names = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_scientific_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 18: {
                this._show_taxo_common_names = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_common_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 2: {
                this._show_taxo_code = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_code, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 24: {
                this._show_taxo_images_cb = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_images_cb, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 11: {
                this._show_binary_characters = new JCheckBox(title);
                this.addJCheckBox(this._show_binary_characters, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 3: {
                this._show_annotation = new JCheckBox(title);
                this.addJCheckBox(this._show_annotation, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 12: {
                this._show_binary_character_counts = new JCheckBox(title);
                this.addJCheckBox(this._show_binary_character_counts, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 4: {
                this._write_confidence = new JCheckBox(title);
                this.addJCheckBox(this.getWriteConfidenceCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 5: {
                this._show_events = new JCheckBox(title);
                this.addJCheckBox(this.getShowEventsCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 8: {
                this._use_visual_styles_cb = new JCheckBox(title);
                this.getUseVisualStylesCb().setToolTipText("To use visual styles (node colors, fonts) and branch colors, if present");
                this.addJCheckBox(this.getUseVisualStylesCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 9: {
                this._width_branches = new JCheckBox(title);
                this._width_branches.setToolTipText("To use branch width values, if present");
                this.addJCheckBox(this._width_branches, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 28: {
                this._write_branch_length_values = new JCheckBox(title);
                this.addJCheckBox(this._write_branch_length_values, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 10: {
                this._show_domain_architectures = new JCheckBox(title);
                this.addJCheckBox(this._show_domain_architectures, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 27: {
                this._show_mol_seqs = new JCheckBox(title);
                this.addJCheckBox(this._show_mol_seqs, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 13: {
                this._show_seq_names = new JCheckBox(title);
                this.addJCheckBox(this._show_seq_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 26: {
                this._show_gene_names = new JCheckBox(title);
                this.addJCheckBox(this._show_gene_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 20: {
                this._show_seq_symbols = new JCheckBox(title);
                this.addJCheckBox(this._show_seq_symbols, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 14: {
                this._show_sequence_acc = new JCheckBox(title);
                this.addJCheckBox(this._show_sequence_acc, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 16: {
                this._dynamically_hide_data = new JCheckBox(title);
                this.getDynamicallyHideData().setToolTipText("To hide labels depending on expected visibility");
                this.addJCheckBox(this.getDynamicallyHideData(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 21: {
                this._node_desc_popup_cb = new JCheckBox(title);
                this.getNodeDescPopupCb().setToolTipText("To enable mouse rollover display of basic node data");
                this.addJCheckBox(this.getNodeDescPopupCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 22: {
                this._seq_relation_confidence_switch = new JCheckBox(title);
                this.addJCheckBox(this._seq_relation_confidence_switch, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 23: {
                this._show_vector_data_cb = new JCheckBox(title);
                this.addJCheckBox(this._show_vector_data_cb, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 25: {
                this._show_properties_cb = new JCheckBox(title);
                this.addJCheckBox(this._show_properties_cb, ch_panel);
                this.add(ch_panel);
                break;
            }
            default: {
                throw new RuntimeException("unknown checkbox: " + which);
            }
        }
    }

    void addJButton(JButton jb, JPanel p) {
        jb.setFocusPainted(false);
        jb.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jb.setBorder(BorderFactory.createLineBorder(this.getConfiguration().getGuiButtonBorderColor()));
            jb.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            jb.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        p.add(jb);
        jb.addActionListener(this);
    }

    void addJCheckBox(JCheckBox jcb, JPanel p) {
        jcb.setFocusPainted(false);
        jcb.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jcb.setBackground(this.getConfiguration().getGuiBackgroundColor());
            jcb.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        p.add((Component)jcb, "Center");
        jcb.addActionListener(this);
    }

    void addJTextField(JTextField tf, JPanel p) {
        if (!this._configuration.isUseNativeUI()) {
            tf.setForeground(this.getConfiguration().getGuiBackgroundColor());
            tf.setFont(jcb_font);
        }
        p.add(tf);
        tf.addActionListener(this);
    }

    void deactivateButtonToReturnToSuperTree() {
        this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiButtonTextColor());
        this._return_to_super_tree.setEnabled(false);
    }

    void displayedPhylogenyMightHaveChanged(boolean recalc_longest_ext_node_info) {
        if (this._mainpanel != null && this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            if (this.getOptions().isShowOverview()) {
                this._mainpanel.getCurrentTreePanel().updateOvSizes();
            }
            this._mainpanel.getCurrentTreePanel().recalculateMaxDistanceToRoot();
            this.setVisibilityOfDomainStrucureControls();
            this.updateDomainStructureEvaluethresholdDisplay();
            this._mainpanel.getCurrentTreePanel().calculateScaleDistance();
            this._mainpanel.getCurrentTreePanel().calcMaxDepth();
            this._mainpanel.adjustJScrollPane();
            if (recalc_longest_ext_node_info) {
                this._mainpanel.getCurrentTreePanel().initNodeData();
                this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
            }
            this._mainpanel.getCurrentTreePanel().repaint();
        }
    }

    void endClickToOptions() {
        this._click_to_combobox.addActionListener(this);
    }

    NodeClickAction getActionWhenNodeClicked() {
        return this._action_when_node_clicked;
    }

    Map<Integer, String> getAllClickToItems() {
        return this._all_click_to_names;
    }

    Map<String, Color> getAnnotationColors() {
        return this._annotation_colors;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    Options getOptions() {
        return this.getMainPanel().getOptions();
    }

    JLabel getSearchFoundCountsLabel0() {
        return this._search_found_label_0;
    }

    JLabel getSearchFoundCountsLabel1() {
        return this._search_found_label_1;
    }

    JButton getSearchResetButton0() {
        return this._search_reset_button_0;
    }

    JButton getSearchResetButton1() {
        return this._search_reset_button_1;
    }

    JTextField getSearchTextField0() {
        return this._search_tf_0;
    }

    JTextField getSearchTextField1() {
        return this._search_tf_1;
    }

    Map<String, Color> getSequenceColors() {
        return this._sequence_colors;
    }

    List<String> getSingleClickToNames() {
        return this._click_to_names;
    }

    Map<String, Color> getSpeciesColors() {
        return this._species_colors;
    }

    boolean isAntialiasScreenText() {
        return true;
    }

    boolean isColorAccordingToAnnotation() {
        return this._color_according_to_annotation != null && this._color_according_to_annotation.isSelected();
    }

    boolean isColorAccordingToSequence() {
        return this._color_acc_sequence != null && this._color_acc_sequence.isSelected();
    }

    boolean isColorAccordingToTaxonomy() {
        return this._color_acc_species != null && this._color_acc_species.isSelected();
    }

    boolean isDrawPhylogram() {
        return this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex());
    }

    boolean isDynamicallyHideData() {
        return this.getDynamicallyHideData() != null && this.getDynamicallyHideData().isSelected();
    }

    boolean isEvents() {
        return this.getShowEventsCb() != null && this.getShowEventsCb().isSelected();
    }

    boolean isNodeDescPopup() {
        return this.getNodeDescPopupCb() != null && this.getNodeDescPopupCb().isSelected();
    }

    boolean isShowAnnotation() {
        return this._show_annotation != null && this._show_annotation.isSelected();
    }

    boolean isShowBinaryCharacterCounts() {
        return this._show_binary_character_counts != null && this._show_binary_character_counts.isSelected();
    }

    boolean isShowBinaryCharacters() {
        return this._show_binary_characters != null && this._show_binary_characters.isSelected();
    }

    boolean isShowConfidenceValues() {
        return this.getWriteConfidenceCb() != null && this.getWriteConfidenceCb().isSelected();
    }

    boolean isShowDomainArchitectures() {
        return this._show_domain_architectures != null && this._show_domain_architectures.isSelected();
    }

    boolean isShowGeneNames() {
        return this._show_gene_names != null && this._show_gene_names.isSelected();
    }

    boolean isShowInternalData() {
        return this._display_internal_data == null || this._display_internal_data.isSelected();
    }

    boolean isShowNodeNames() {
        return this._show_node_names != null && this._show_node_names.isSelected();
    }

    boolean isShowSeqNames() {
        return this._show_seq_names != null && this._show_seq_names.isSelected();
    }

    boolean isShowSeqSymbols() {
        return this._show_seq_symbols != null && this._show_seq_symbols.isSelected();
    }

    boolean isShowSequenceAcc() {
        return this._show_sequence_acc != null && this._show_sequence_acc.isSelected();
    }

    boolean isShowSequenceRelationConfidence() {
        return this._seq_relation_confidence_switch != null && this._seq_relation_confidence_switch.isSelected();
    }

    boolean isShowSequenceRelations() {
        return this._show_sequence_relations != null && this._show_sequence_relations.getSelectedIndex() > 0;
    }

    boolean isShowTaxonomyCode() {
        return this._show_taxo_code != null && this._show_taxo_code.isSelected();
    }

    boolean isShowTaxonomyCommonNames() {
        return this._show_taxo_common_names != null && this._show_taxo_common_names.isSelected();
    }

    boolean isShowTaxonomyScientificNames() {
        return this._show_taxo_scientific_names != null && this._show_taxo_scientific_names.isSelected();
    }

    boolean isUseVisualStyles() {
        return this.getUseVisualStylesCb() != null && this.getUseVisualStylesCb().isSelected() || this.getUseVisualStylesCb() == null && this._color_branches;
    }

    boolean isWidthBranches() {
        return this._width_branches != null && this._width_branches.isSelected();
    }

    boolean isWriteBranchLengthValues() {
        return this._write_branch_length_values != null && this._write_branch_length_values.isSelected();
    }

    void phylogenyAdded(Configuration configuration) {
        this.getIsDrawPhylogramList().add(configuration.isDrawAsPhylogram());
    }

    void phylogenyRemoved(int index) {
        this.getIsDrawPhylogramList().remove(index);
    }

    void search0() {
        MainPanel main_panel = this.getMainPanel();
        Phylogeny tree = main_panel.getCurrentPhylogeny();
        if (tree == null || tree.isEmpty()) {
            return;
        }
        String query = this.getSearchTextField0().getText();
        if (query != null) {
            query = query.trim();
        }
        if (!ForesterUtil.isEmpty(query)) {
            this.search0(main_panel, tree, query);
        } else {
            this.getSearchFoundCountsLabel0().setVisible(false);
            this.getSearchResetButton0().setEnabled(false);
            this.getSearchResetButton0().setVisible(false);
            this.searchReset0();
        }
    }

    void search1() {
        MainPanel main_panel = this.getMainPanel();
        Phylogeny tree = main_panel.getCurrentPhylogeny();
        if (tree == null || tree.isEmpty()) {
            return;
        }
        String query = this.getSearchTextField1().getText();
        if (query != null) {
            query = query.trim();
        }
        if (!ForesterUtil.isEmpty(query)) {
            this.search1(main_panel, tree, query);
        } else {
            this.getSearchFoundCountsLabel1().setVisible(false);
            this.getSearchResetButton1().setEnabled(false);
            this.getSearchResetButton1().setVisible(false);
            this.searchReset1();
        }
    }

    void searchReset0() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes0(null);
        }
    }

    void searchReset1() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes1(null);
        }
    }

    void setActionWhenNodeClicked(NodeClickAction action) {
        this._action_when_node_clicked = action;
    }

    void setAnnotationColors(Map<String, Color> annotation_colors) {
        this._annotation_colors = annotation_colors;
    }

    void setCheckbox(int which, boolean state) {
        switch (which) {
            case 0: {
                if (this.getDisplayAsPhylogramCb() == null) break;
                this.getDisplayAsPhylogramCb().setSelected(state);
                break;
            }
            case 15: {
                if (this._display_internal_data == null) break;
                this._display_internal_data.setSelected(state);
                break;
            }
            case 6: {
                if (this._color_acc_species == null) break;
                this._color_acc_species.setSelected(state);
                break;
            }
            case 7: {
                if (this._color_acc_sequence == null) break;
                this._color_acc_sequence.setSelected(state);
                break;
            }
            case 19: {
                if (this._color_according_to_annotation == null) break;
                this._color_according_to_annotation.setSelected(state);
                break;
            }
            case 1: {
                if (this._show_node_names == null) break;
                this._show_node_names.setSelected(state);
                break;
            }
            case 17: {
                if (this._show_taxo_scientific_names == null) break;
                this._show_taxo_scientific_names.setSelected(state);
                break;
            }
            case 18: {
                if (this._show_taxo_common_names == null) break;
                this._show_taxo_common_names.setSelected(state);
                break;
            }
            case 2: {
                if (this._show_taxo_code == null) break;
                this._show_taxo_code.setSelected(state);
                break;
            }
            case 24: {
                if (this._show_taxo_images_cb == null) break;
                this._show_taxo_images_cb.setSelected(state);
                break;
            }
            case 3: {
                if (this._show_annotation == null) break;
                this._show_annotation.setSelected(state);
                break;
            }
            case 11: {
                if (this._show_binary_characters == null) break;
                this._show_binary_characters.setSelected(state);
                break;
            }
            case 12: {
                if (this._show_binary_character_counts == null) break;
                this._show_binary_character_counts.setSelected(state);
                break;
            }
            case 4: {
                if (this.getWriteConfidenceCb() == null) break;
                this.getWriteConfidenceCb().setSelected(state);
                break;
            }
            case 5: {
                if (this.getShowEventsCb() == null) break;
                this.getShowEventsCb().setSelected(state);
                break;
            }
            case 8: {
                if (this.getUseVisualStylesCb() == null) break;
                this.getUseVisualStylesCb().setSelected(state);
                break;
            }
            case 9: {
                if (this._width_branches == null) break;
                this._width_branches.setSelected(state);
                break;
            }
            case 10: {
                if (this._show_domain_architectures == null) break;
                this._show_domain_architectures.setSelected(state);
                break;
            }
            case 28: {
                if (this._write_branch_length_values == null) break;
                this._write_branch_length_values.setSelected(state);
                break;
            }
            case 27: {
                if (this._show_mol_seqs == null) break;
                this._show_mol_seqs.setSelected(state);
                break;
            }
            case 13: {
                if (this._show_seq_names == null) break;
                this._show_seq_names.setSelected(state);
                break;
            }
            case 26: {
                if (this._show_gene_names == null) break;
                this._show_gene_names.setSelected(state);
                break;
            }
            case 20: {
                if (this._show_seq_symbols == null) break;
                this._show_seq_symbols.setSelected(state);
                break;
            }
            case 23: {
                if (this._show_vector_data_cb == null) break;
                this._show_vector_data_cb.setSelected(state);
                break;
            }
            case 25: {
                if (this._show_properties_cb == null) break;
                this._show_properties_cb.setSelected(state);
                break;
            }
            case 14: {
                if (this._show_sequence_acc == null) break;
                this._show_sequence_acc.setSelected(state);
                break;
            }
            case 16: {
                if (this.getDynamicallyHideData() == null) break;
                this.getDynamicallyHideData().setSelected(state);
                break;
            }
            case 21: {
                if (this.getNodeDescPopupCb() == null) break;
                this.getNodeDescPopupCb().setSelected(state);
                break;
            }
            case 22: {
                if (this._seq_relation_confidence_switch == null) break;
                this._seq_relation_confidence_switch.setSelected(state);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown checkbox: " + which));
            }
        }
    }

    void setCheckbox(JCheckBox cb, boolean state) {
        if (cb != null) {
            cb.setSelected(state);
        }
    }

    void setClickToAction(int action) {
        if (action == this._show_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SHOW_DATA);
        } else if (action == this._collapse_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLLAPSE);
        } else if (action == this._reroot_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.REROOT);
        } else if (action == this._subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SUBTREE);
        } else if (action == this._swap_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SWAP);
        } else if (action == this._color_subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_SUBTREE);
        } else if (action == this._open_seq_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_SEQ_WEB);
        } else if (action == this._sort_descendents_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SORT_DESCENDENTS);
        } else if (action == this._blast_item) {
            this.setActionWhenNodeClicked(NodeClickAction.BLAST);
        } else if (action == this._open_tax_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_TAX_WEB);
        } else if (action == this._cut_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CUT_SUBTREE);
        } else if (action == this._copy_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COPY_SUBTREE);
        } else if (action == this._delete_node_or_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.DELETE_NODE_OR_SUBTREE);
        } else if (action == this._paste_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.PASTE_SUBTREE);
        } else if (action == this._add_new_node_item) {
            this.setActionWhenNodeClicked(NodeClickAction.ADD_NEW_NODE);
        } else if (action == this._edit_node_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.EDIT_NODE_DATA);
        } else if (action == this._select_nodes_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SELECT_NODES);
        } else if (action == this._get_ext_desc_data) {
            this.setActionWhenNodeClicked(NodeClickAction.GET_EXT_DESC_DATA);
        } else if (action == this._open_pdb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_PDB_WEB);
        } else if (action == this._color_node_font_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_NODE_FONT);
        } else if (action == this._change_node_font_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CHANGE_NODE_FONT);
        } else {
            throw new RuntimeException("unknown action: " + action);
        }
        this._click_to_combobox.setSelectedIndex(action);
    }

    void setColorBranches(boolean color_branches) {
        this._color_branches = color_branches;
    }

    void setDrawPhylogram(boolean b) {
        this.getDisplayAsPhylogramCb().setSelected(b);
        this.setDrawPhylogram(this.getMainPanel().getCurrentTabIndex(), b);
    }

    void setDrawPhylogramEnabled(boolean b) {
        this.getDisplayAsPhylogramCb().setEnabled(b);
    }

    void setDynamicHidingIsOn(boolean is_on) {
        if (is_on) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        } else if (!this._configuration.isUseNativeUI()) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiButtonTextColor());
        } else {
            this.getDynamicallyHideData().setForeground(Color.BLACK);
        }
    }

    void setSearchFoundCountsOnLabel0(int counts) {
        this.getSearchFoundCountsLabel0().setText("Found: " + counts);
    }

    void setSearchFoundCountsOnLabel1(int counts) {
        this.getSearchFoundCountsLabel1().setText("Found: " + counts);
    }

    void setSequenceColors(Map<String, Color> sequence_colors) {
        this._sequence_colors = sequence_colors;
    }

    void setShowEvents(boolean show_events) {
        if (this.getShowEventsCb() == null) {
            this._show_events = new JCheckBox("");
        }
        this.getShowEventsCb().setSelected(show_events);
    }

    void setSpeciesColors(Map<String, Color> species_colors) {
        this._species_colors = species_colors;
    }

    void setupControls() {
        this.setupDisplayCheckboxes();
        if (this._configuration.displaySequenceRelations()) {
            this.addSequenceRelationBlock();
        }
        this.startClickToOptions();
        this.setupClickToOptions();
        this.endClickToOptions();
        this.addButtons();
        this.setupSearchTools0();
        this.setupSearchTools1();
    }

    void setUpControlsForDomainStrucures() {
        this._domain_display_label = new JLabel("Domain Architectures:");
        this.add(ControlPanel.customizeLabel(this._domain_display_label, this.getConfiguration()));
        this.add(this._domain_display_label);
        this._zoom_in_domain_structure = new JButton("d+");
        this._zoom_out_domain_structure = new JButton("d-");
        this._decr_domain_structure_evalue_thr = new JButton("-");
        this._incr_domain_structure_evalue_thr = new JButton("+");
        this._zoom_in_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._zoom_out_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._decr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setToolTipText("Increase the E-value threshold by a factor of 10");
        this._decr_domain_structure_evalue_thr.setToolTipText("Decrease the E-value threshold by a factor of 10");
        this._domain_structure_evalue_thr_tf = new JTextField(3);
        this._domain_structure_evalue_thr_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._domain_structure_evalue_thr_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._domain_structure_evalue_thr_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._domain_structure_evalue_thr_tf.setBorder(null);
        }
        JPanel d1_panel = new JPanel(new GridLayout(1, 2, 0, 0));
        JPanel d2_panel = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            d1_panel.setBackground(this.getBackground());
            d2_panel.setBackground(this.getBackground());
        }
        this.add(d1_panel);
        this.add(d2_panel);
        this.addJButton(this._zoom_out_domain_structure, d1_panel);
        this.addJButton(this._zoom_in_domain_structure, d1_panel);
        this.addJButton(this._decr_domain_structure_evalue_thr, d2_panel);
        this.addJTextField(this._domain_structure_evalue_thr_tf, d2_panel);
        this.addJButton(this._incr_domain_structure_evalue_thr, d2_panel);
    }

    void setupSearchTools0() {
        JLabel search_label = new JLabel("Search (A):");
        search_label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            search_label.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(search_label);
        search_label.setToolTipText(SEARCH_TIP_TEXT);
        this._search_found_label_0 = new JLabel();
        this.getSearchFoundCountsLabel0().setVisible(false);
        this._search_found_label_0.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label_0.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this._search_tf_0 = new JTextField(3);
        this._search_tf_0.setToolTipText(SEARCH_TIP_TEXT);
        this._search_tf_0.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf_0.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._search_tf_0.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._search_tf_0.setBorder(null);
        }
        this._search_reset_button_0 = new JButton();
        this.getSearchResetButton0().setText("Reset");
        this.getSearchResetButton0().setEnabled(false);
        this.getSearchResetButton0().setVisible(false);
        JPanel s_panel_1 = new JPanel(new BorderLayout());
        JPanel s_panel_2 = new JPanel(new GridLayout(1, 2, 0, 0));
        s_panel_1.setBackground(this.getBackground());
        this.add(s_panel_1);
        s_panel_2.setBackground(this.getBackground());
        this.add(s_panel_2);
        KeyAdapter key_adapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent key_event) {
                ControlPanel.this.search0();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener action_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.searchReset0();
                ControlPanel.this.setSearchFoundCountsOnLabel0(0);
                ControlPanel.this.getSearchFoundCountsLabel0().setVisible(false);
                ControlPanel.this.getSearchTextField0().setText("");
                ControlPanel.this.getSearchResetButton0().setEnabled(false);
                ControlPanel.this.getSearchResetButton0().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button_0.addActionListener(action_listener);
        this._search_tf_0.addKeyListener(key_adapter);
        this.addJTextField(this._search_tf_0, s_panel_1);
        s_panel_2.add(this._search_found_label_0);
        this.addJButton(this._search_reset_button_0, s_panel_2);
    }

    void setupSearchTools1() {
        JLabel search_label = new JLabel("Search (B):");
        search_label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            search_label.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(search_label);
        search_label.setToolTipText(SEARCH_TIP_TEXT);
        this._search_found_label_1 = new JLabel();
        this.getSearchFoundCountsLabel1().setVisible(false);
        this._search_found_label_1.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label_1.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this._search_tf_1 = new JTextField(3);
        this._search_tf_1.setToolTipText(SEARCH_TIP_TEXT);
        this._search_tf_1.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf_1.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._search_tf_1.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._search_tf_1.setBorder(null);
        }
        this._search_reset_button_1 = new JButton();
        this.getSearchResetButton1().setText("Reset");
        this.getSearchResetButton1().setEnabled(false);
        this.getSearchResetButton1().setVisible(false);
        JPanel s_panel_1 = new JPanel(new BorderLayout());
        JPanel s_panel_2 = new JPanel(new GridLayout(1, 2, 0, 0));
        s_panel_1.setBackground(this.getBackground());
        this.add(s_panel_1);
        s_panel_2.setBackground(this.getBackground());
        this.add(s_panel_2);
        KeyAdapter key_adapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent key_event) {
                ControlPanel.this.search1();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener action_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.searchReset1();
                ControlPanel.this.setSearchFoundCountsOnLabel1(0);
                ControlPanel.this.getSearchFoundCountsLabel1().setVisible(false);
                ControlPanel.this.getSearchTextField1().setText("");
                ControlPanel.this.getSearchResetButton1().setEnabled(false);
                ControlPanel.this.getSearchResetButton1().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button_1.addActionListener(action_listener);
        this._search_tf_1.addKeyListener(key_adapter);
        this.addJTextField(this._search_tf_1, s_panel_1);
        s_panel_2.add(this._search_found_label_1);
        this.addJButton(this._search_reset_button_1, s_panel_2);
    }

    void setVisibilityOfDomainStrucureCB() {
        try {
            if (this.getCurrentTreePanel() != null && (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(false);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(false);
                }
            } else if (this.isShowDomainArchitectures()) {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(true);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(true);
                }
            } else {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(false);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setVisibilityOfX() {
        MainFrame mf = this.getMainFrame();
        if (mf != null) {
            if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().getPhylogeny() != null) {
                if (AptxUtil.isHasAtLeastOneBranchWithSupportSD(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mf._show_confidence_stddev_cbmi != null) {
                        mf._show_confidence_stddev_cbmi.setVisible(true);
                    }
                } else if (mf._show_confidence_stddev_cbmi != null) {
                    mf._show_confidence_stddev_cbmi.setVisible(false);
                }
                if (AptxUtil.isHasAtLeastOneNodeWithScientificName(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mf._abbreviate_scientific_names != null) {
                        mf._abbreviate_scientific_names.setVisible(true);
                    }
                } else if (mf._abbreviate_scientific_names != null) {
                    mf._abbreviate_scientific_names.setVisible(false);
                }
                if (AptxUtil.isHasAtLeastOneNodeWithSequenceAnnotation(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mf._show_annotation_ref_source != null) {
                        mf._show_annotation_ref_source.setVisible(true);
                    }
                } else if (mf._show_annotation_ref_source != null) {
                    mf._show_annotation_ref_source.setVisible(false);
                }
            }
            if (this.isDrawPhylogram() || this.getCurrentTreePanel() != null && (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                if (mf._non_lined_up_cladograms_rbmi != null) {
                    mf._non_lined_up_cladograms_rbmi.setVisible(false);
                }
                if (mf._uniform_cladograms_rbmi != null) {
                    mf._uniform_cladograms_rbmi.setVisible(false);
                }
                if (mf._ext_node_dependent_cladogram_rbmi != null) {
                    mf._ext_node_dependent_cladogram_rbmi.setVisible(false);
                }
            } else {
                if (mf._non_lined_up_cladograms_rbmi != null) {
                    mf._non_lined_up_cladograms_rbmi.setVisible(true);
                }
                if (mf._uniform_cladograms_rbmi != null) {
                    mf._uniform_cladograms_rbmi.setVisible(true);
                }
                if (mf._ext_node_dependent_cladogram_rbmi != null) {
                    mf._ext_node_dependent_cladogram_rbmi.setVisible(true);
                }
            }
            if (this.isDrawPhylogram()) {
                if (mf._show_scale_cbmi != null) {
                    mf._show_scale_cbmi.setVisible(true);
                }
            } else if (mf._show_scale_cbmi != null) {
                mf._show_scale_cbmi.setVisible(false);
            }
            if (this.getCurrentTreePanel() != null) {
                if (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    if (mf._label_direction_cbmi != null) {
                        mf._label_direction_cbmi.setVisible(true);
                    }
                } else if (mf._label_direction_cbmi != null) {
                    mf._label_direction_cbmi.setVisible(false);
                }
            }
        }
    }

    void showAnnotations() {
        if (this._show_annotation != null) {
            this._show_annotation.setSelected(true);
        }
        if (this._color_according_to_annotation != null) {
            this._color_according_to_annotation.setSelected(true);
        }
        if (this._color_acc_species != null) {
            this._color_acc_species.setSelected(false);
        }
        if (this._color_acc_sequence != null) {
            this._color_acc_sequence.setSelected(false);
        }
        this._mainpanel.getCurrentTreePanel().repaint();
    }

    void showWhole() {
        if (this._mainpanel.getCurrentScrollPane() == null || this._mainpanel.getCurrentTreePanel().getPhylogeny().isEmpty()) {
            return;
        }
        this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
        this.displayedPhylogenyMightHaveChanged(true);
        this._mainpanel.getCurrentTreePanel().updateOvSettings();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().updateOvSizes();
    }

    void showWholeAll() {
        for (TreePanel tree_panel : this._mainpanel.getTreePanels()) {
            if (tree_panel == null) continue;
            tree_panel.validate();
            tree_panel.calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
            tree_panel.resetPreferredSize();
            tree_panel.repaint();
        }
    }

    void startClickToOptions() {
        JLabel spacer = new JLabel("");
        spacer.setFont(jcb_font);
        this.add(spacer);
        this._click_to_label = new JLabel("Click on Node to:");
        this.add(ControlPanel.customizeLabel(this._click_to_label, this.getConfiguration()));
        this._click_to_combobox = new JComboBox();
        this._click_to_combobox.setFocusable(false);
        this._click_to_combobox.setMaximumRowCount(14);
        this._click_to_combobox.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiBackgroundColor());
        }
        this.add(this._click_to_combobox);
        this._all_click_to_names = new HashMap<Integer, String>();
        this._click_to_names = new ArrayList<String>();
    }

    void tabChanged() {
        if (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && this.getCurrentTreePanel().getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setDrawPhylogramEnabled(true);
                this.setDrawPhylogram(this.isDrawPhylogram());
            } else {
                this.setDrawPhylogramEnabled(false);
                this.setDrawPhylogram(false);
            }
            if (this.getMainPanel().getMainFrame() == null) {
                ArchaeopteryxE e = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                e.setSelectedTypeInTypeMenu(e.getCurrentTreePanel().getPhylogenyGraphicsType());
            } else {
                this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getMainPanel().getCurrentTreePanel().getPhylogenyGraphicsType());
            }
            this.getMainPanel().getCurrentTreePanel().updateSubSuperTreeButton();
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
            this.getMainPanel().getControlPanel().updateDomainStructureEvaluethresholdDisplay();
            this.getSequenceRelationTypeBox().removeAllItems();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE type : this.getMainPanel().getCurrentPhylogeny().getRelevantSequenceRelationTypes()) {
                this._sequence_relation_type_box.addItem(type);
            }
            this.getMainPanel().getCurrentTreePanel().repaint();
        }
    }

    void uncollapseAll(TreePanel tp) {
        Phylogeny t = tp.getPhylogeny();
        if (t != null && !t.isEmpty()) {
            PhylogenyNodeIterator iter = t.iteratorPreorder();
            while (iter.hasNext()) {
                PhylogenyNode node = iter.next();
                node.setCollapse(false);
            }
            tp.resetNodeIdToDistToLeafMap();
            tp.updateSetOfCollapsedExternalNodes();
            t.recalculateNumberOfExternalDescendants(false);
            tp.setNodeInPreorderToNull();
            t.clearHashIdToNodeMap();
            this.showWhole();
        }
    }

    void updateDomainStructureEvaluethresholdDisplay() {
        if (this._domain_structure_evalue_thr_tf != null) {
            this._domain_structure_evalue_thr_tf.setText("10^" + this.getMainPanel().getCurrentTreePanel().getDomainStructureEvalueThresholdExp());
        }
    }

    void zoomInX(float factor, float x_correction_factor) {
        JScrollBar sb = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
        TreePanel treepanel = this.getMainPanel().getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.0f);
        if (treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
            double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
            treepanel.setXdistance(treepanel.getXdistance() * factor);
            treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
            this.getMainPanel().adjustJScrollPane();
            treepanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
        } else {
            int x = sb.getMaximum() - sb.getMinimum() - sb.getVisibleAmount() - sb.getValue();
            treepanel.setXdistance(treepanel.getXdistance() * factor);
            treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
            this.getMainPanel().adjustJScrollPane();
            treepanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            sb.setValue(sb.getMaximum() - sb.getMinimum() - x - sb.getVisibleAmount());
        }
        treepanel.resetPreferredSize();
        treepanel.updateOvSizes();
    }

    void zoomInY(float factor) {
        JScrollBar sb = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
        TreePanel treepanel = this.getMainPanel().getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.1f);
        double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
        treepanel.setYdistance(treepanel.getYdistance() * factor);
        this.getMainPanel().adjustJScrollPane();
        treepanel.resetPreferredSize();
        this.getMainPanel().getCurrentScrollPane().getViewport().validate();
        sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
        treepanel.resetPreferredSize();
        treepanel.updateOvSizes();
    }

    void zoomOutX(float factor, float x_correction_factor) {
        TreePanel treepanel = this.getMainPanel().getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.0f);
        if ((double)(treepanel.getXdistance() * factor) > 0.0) {
            JScrollBar sb = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
            if (treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
                this.getMainPanel().adjustJScrollPane();
                treepanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
                treepanel.setXdistance(treepanel.getXdistance() * factor);
                treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
                this.getMainPanel().adjustJScrollPane();
                treepanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
            } else {
                int x = sb.getMaximum() - sb.getMinimum() - sb.getVisibleAmount() - sb.getValue();
                treepanel.setXdistance(treepanel.getXdistance() * factor);
                treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
                if (x > 0) {
                    this.getMainPanel().adjustJScrollPane();
                    treepanel.resetPreferredSize();
                    this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                    sb.setValue(sb.getMaximum() - sb.getMinimum() - x - sb.getVisibleAmount());
                }
            }
            treepanel.resetPreferredSize();
            treepanel.updateOvSizes();
        }
    }

    void zoomOutY(float factor) {
        TreePanel treepanel = this.getMainPanel().getCurrentTreePanel();
        treepanel.multiplyUrtFactor(0.9f);
        if ((double)(treepanel.getYdistance() * factor) > 0.0) {
            JScrollBar sb = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
            double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
            treepanel.setYdistance(treepanel.getYdistance() * factor);
            this.getMainPanel().adjustJScrollPane();
            treepanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
            treepanel.resetPreferredSize();
            treepanel.updateOvSizes();
        }
    }

    static JLabel customizeLabel(JLabel label, Configuration configuration) {
        label.setFont(jcb_bold_font);
        if (!configuration.isUseNativeUI()) {
            label.setForeground(configuration.getGuiCheckboxTextColor());
            label.setBackground(configuration.getGuiBackgroundColor());
        }
        return label;
    }

    static enum NodeClickAction {
        ADD_NEW_NODE,
        BLAST,
        COLLAPSE,
        COLOR_SUBTREE,
        COPY_SUBTREE,
        CUT_SUBTREE,
        DELETE_NODE_OR_SUBTREE,
        EDIT_NODE_DATA,
        GET_EXT_DESC_DATA,
        OPEN_PDB_WEB,
        OPEN_SEQ_WEB,
        OPEN_TAX_WEB,
        PASTE_SUBTREE,
        REROOT,
        SELECT_NODES,
        SHOW_DATA,
        SORT_DESCENDENTS,
        SUBTREE,
        SWAP,
        CHANGE_NODE_FONT,
        COLOR_NODE_FONT;

    }
}

