/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public class MainPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -2682765312661416435L;
    MainFrame _mainframe;
    List<TreePanel> _treepanels;
    ControlPanel _control_panel;
    private List<JScrollPane> _treegraphic_scroll_panes;
    private List<JPanel> _treegraphic_scroll_pane_panels;
    Configuration _configuration;
    private JTabbedPane _tabbed_pane;
    private TreeColorSet _colorset;
    private TreeFontSet _fontset;
    private Phylogeny _cut_or_copied_tree;
    private Set<Long> _copied_and_pasted_nodes;
    private Hashtable<String, BufferedImage> _image_map;
    private static Map<String, String> _lineage_to_rank_map;

    public MainPanel(Configuration configuration, MainFrame parent) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.addComponentListener(this);
        this._configuration = configuration;
        this._mainframe = parent;
        this._treepanels = new ArrayList<TreePanel>();
        this.initialize();
        this._control_panel = new ControlPanel(this, configuration);
        this.add((Component)this._control_panel, "West");
        this.setupTreeGraphic(configuration, this.getControlPanel());
        this.getControlPanel().showWhole();
    }

    MainPanel() {
    }

    public void addPhylogenyInNewTab(Phylogeny phy, Configuration config, String default_name, String full_path) {
        final TreePanel treepanel = new TreePanel(phy, config, this);
        this.getControlPanel().phylogenyAdded(config);
        treepanel.setControlPanel(this.getControlPanel());
        this._treepanels.add(treepanel);
        String name = "";
        name = !ForesterUtil.isEmpty(phy.getName()) ? phy.getName() : (phy.getIdentifier() != null ? phy.getIdentifier().toString() : (!ForesterUtil.isEmpty(default_name) ? default_name : "[" + (this.getTabbedPane().getTabCount() + 1) + "]"));
        JScrollPane treegraphic_scroll_pane = new JScrollPane(treepanel);
        treegraphic_scroll_pane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (treepanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treepanel.repaint();
                }
            }
        });
        treegraphic_scroll_pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (treepanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treepanel.repaint();
                }
            }
        });
        treegraphic_scroll_pane.getHorizontalScrollBar().setUnitIncrement(10);
        treegraphic_scroll_pane.getHorizontalScrollBar().setBlockIncrement(200);
        treegraphic_scroll_pane.getVerticalScrollBar().setUnitIncrement(10);
        treegraphic_scroll_pane.getVerticalScrollBar().setBlockIncrement(200);
        JPanel treegraphic_scroll_pane_panel = new JPanel();
        treegraphic_scroll_pane_panel.setLayout(new BorderLayout());
        treegraphic_scroll_pane_panel.add((Component)treegraphic_scroll_pane, "Center");
        this._treegraphic_scroll_pane_panels.add(treegraphic_scroll_pane_panel);
        this._treegraphic_scroll_panes.add(treegraphic_scroll_pane);
        this.getTabbedPane().addTab(name, null, treegraphic_scroll_pane_panel, "");
        this.getTabbedPane().setSelectedIndex(this.getTabbedPane().getTabCount() - 1);
        this.getControlPanel().showWhole();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getCurrentTreePanel() != null) {
            this.getCurrentTreePanel().updateOvSettings();
            this.getCurrentTreePanel().updateOvSizes();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public ControlPanel getControlPanel() {
        return this._control_panel;
    }

    public Set<Long> getCopiedAndPastedNodes() {
        return this._copied_and_pasted_nodes;
    }

    public TreePanel getCurrentTreePanel() {
        int selected = this.getTabbedPane().getSelectedIndex();
        if (selected >= 0) {
            return this._treepanels.get(selected);
        }
        if (this._treepanels.size() == 1) {
            return this._treepanels.get(0);
        }
        return null;
    }

    public Options getOptions() {
        return this._mainframe.getOptions();
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbed_pane;
    }

    public TreeFontSet getTreeFontSet() {
        return this._fontset;
    }

    public void setArrowCursor() {
        this.setCursor(TreePanel.ARROW_CURSOR);
        this.repaint();
    }

    public void setCopiedAndPastedNodes(Set<Long> node_ids) {
        this._copied_and_pasted_nodes = node_ids;
    }

    public void setWaitCursor() {
        this.setCursor(TreePanel.WAIT_CURSOR);
        this.repaint();
    }

    void addPhylogenyInPanel(Phylogeny phy, Configuration config) {
        final TreePanel treepanel = new TreePanel(phy, config, this);
        this.getControlPanel().phylogenyAdded(config);
        treepanel.setControlPanel(this.getControlPanel());
        this._treepanels.add(treepanel);
        JScrollPane treegraphic_scroll_pane = new JScrollPane(treepanel);
        treegraphic_scroll_pane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (treepanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treepanel.repaint();
                }
            }
        });
        treegraphic_scroll_pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (treepanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treepanel.repaint();
                }
            }
        });
        treegraphic_scroll_pane.getHorizontalScrollBar().setUnitIncrement(20);
        treegraphic_scroll_pane.getHorizontalScrollBar().setBlockIncrement(50);
        treegraphic_scroll_pane.getVerticalScrollBar().setUnitIncrement(20);
        treegraphic_scroll_pane.getVerticalScrollBar().setBlockIncrement(50);
        JPanel treegraphic_scroll_pane_panel = new JPanel();
        treegraphic_scroll_pane_panel.setLayout(new BorderLayout());
        treegraphic_scroll_pane_panel.add((Component)treegraphic_scroll_pane, "Center");
        this._treegraphic_scroll_pane_panels.add(treegraphic_scroll_pane_panel);
        this._treegraphic_scroll_panes.add(treegraphic_scroll_pane);
        this.add((Component)treegraphic_scroll_pane_panel, "Center");
    }

    void adjustJScrollPane() {
        if (this.getTabbedPane() != null) {
            this.getCurrentScrollPanePanel().remove(this.getCurrentScrollPane());
            this.getCurrentScrollPanePanel().add((Component)this.getCurrentScrollPane(), "Center");
        }
        this.getCurrentScrollPane().revalidate();
    }

    void closeCurrentPane() {
        int index = this.getCurrentTabIndex();
        if (index >= 0 && this.getTabbedPane().getTabCount() > 0) {
            this.getTabbedPane().remove(index);
            this.getTreePanels().remove(index);
            this._treegraphic_scroll_panes.remove(index);
            this._treegraphic_scroll_pane_panels.remove(index);
            this.getControlPanel().phylogenyRemoved(index);
        }
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    Phylogeny getCurrentPhylogeny() {
        if (this.getCurrentTreePanel() == null) {
            return null;
        }
        return this.getCurrentTreePanel().getPhylogeny();
    }

    JScrollPane getCurrentScrollPane() {
        if (this._treegraphic_scroll_panes.size() > 0) {
            int selected = this.getTabbedPane().getSelectedIndex();
            if (selected >= 0) {
                return this._treegraphic_scroll_panes.get(selected);
            }
            return this._treegraphic_scroll_panes.get(0);
        }
        return null;
    }

    JPanel getCurrentScrollPanePanel() {
        int selected = this.getTabbedPane().getSelectedIndex();
        if (selected >= 0) {
            return this._treegraphic_scroll_pane_panels.get(selected);
        }
        return this._treegraphic_scroll_pane_panels.get(0);
    }

    int getCurrentTabIndex() {
        int selected = this.getTabbedPane().getSelectedIndex();
        if (selected >= 0) {
            return selected;
        }
        return 0;
    }

    Phylogeny getCutOrCopiedTree() {
        return this._cut_or_copied_tree;
    }

    synchronized Hashtable<String, BufferedImage> getImageMap() {
        return this._image_map;
    }

    MainFrame getMainFrame() {
        return this._mainframe;
    }

    Phylogeny getPhylogeny(int index) {
        if (this.getCurrentTreePanel() == null) {
            return null;
        }
        return this._treepanels.get(index).getPhylogeny();
    }

    Dimension getSizeOfViewport() {
        return this.getCurrentScrollPane().getViewport().getExtentSize();
    }

    TreeColorSet getTreeColorSet() {
        return this._colorset;
    }

    List<TreePanel> getTreePanels() {
        return this._treepanels;
    }

    void initialize() {
        if (!this.getConfiguration().isUseNativeUI()) {
            this.setBackground(this.getConfiguration().getGuiBackgroundColor());
        }
        this.setTreeFontSet(new TreeFontSet(this));
        this.getTreeFontSet().setBaseFont(this.getOptions().getBaseFont());
        this.setLayout(new BorderLayout());
        this.setTreeColorSet(TreeColorSet.createInstance(this.getConfiguration()));
        this._treegraphic_scroll_panes = new ArrayList<JScrollPane>();
        this._treegraphic_scroll_pane_panels = new ArrayList<JPanel>();
        this._tabbed_pane = new JTabbedPane(1);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._tabbed_pane.setBackground(this.getConfiguration().getGuiBackgroundColor());
            this._tabbed_pane.setForeground(this.getConfiguration().getGuiBackgroundColor());
        }
        this._tabbed_pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                MainPanel.this.getControlPanel().tabChanged();
                int sel = pane.getSelectedIndex();
                if (sel >= 0 && !MainPanel.this.getConfiguration().isUseNativeUI() && MainPanel.this._tabbed_pane.getTabCount() > 0) {
                    MainPanel.this._tabbed_pane.setForegroundAt(sel, Constants.TAB_LABEL_FOREGROUND_COLOR_SELECTED);
                    for (int i = 0; i < MainPanel.this._tabbed_pane.getTabCount(); ++i) {
                        if (i == sel) continue;
                        MainPanel.this._tabbed_pane.setBackgroundAt(i, MainPanel.this.getConfiguration().getGuiBackgroundColor());
                        MainPanel.this._tabbed_pane.setForegroundAt(i, MainPanel.this.getConfiguration().getGuiCheckboxTextColor());
                    }
                }
            }
        });
        if (!this.getConfiguration().isUseNativeUI()) {
            this._tabbed_pane.setFont(ControlPanel.jcb_font);
        }
        this._tabbed_pane.setTabLayoutPolicy(1);
        this.add((Component)this._tabbed_pane, "Center");
    }

    void setCutOrCopiedTree(Phylogeny cut_or_copied_tree) {
        this._cut_or_copied_tree = cut_or_copied_tree;
    }

    synchronized void setImageMap(Hashtable<String, BufferedImage> image_map) {
        this._image_map = image_map;
    }

    void setTitleOfSelectedTab(String title) {
        int selected = this.getTabbedPane().getSelectedIndex();
        if (selected >= 0) {
            this.getTabbedPane().setTitleAt(selected, title);
        }
    }

    void setTreeColorSet(TreeColorSet colorset) {
        this._colorset = colorset;
        for (TreePanel p : this.getTreePanels()) {
            p.setBackground(colorset.getBackgroundColor());
        }
    }

    void setTreeFontSet(TreeFontSet fontset) {
        this._fontset = fontset;
    }

    void setupTreeGraphic(Configuration config_settings, ControlPanel control) {
        control.setSpeciesColors(config_settings.getSpeciesColors());
        control.setSequenceColors(config_settings.getSequenceColors());
        control.setAnnotationColors(config_settings.getAnnotationColors());
        RenderableDomainArchitecture.setColorMap(config_settings.getDomainColors());
    }

    void terminate() {
        for (TreePanel atvtreepanel : this._treepanels) {
            atvtreepanel.removeAllEditNodeJFrames();
        }
    }

    public static synchronized Map<String, String> getLineageToRankMap() {
        if (_lineage_to_rank_map == null) {
            _lineage_to_rank_map = new HashMap<String, String>();
        }
        return _lineage_to_rank_map;
    }
}

