/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

public final class RenderableDomainArchitecture
extends DomainArchitecture
implements RenderablePhylogenyData {
    private static final String SPECIAL_DOMAIN = "RRMa";
    private static final int BRIGHTEN_COLOR_BY = 200;
    private static final int E_VALUE_THRESHOLD_EXP_DEFAULT = 0;
    private static final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    private static Map<String, Color> _domain_colors;
    private final DomainArchitecture _domain_structure;
    private int _e_value_threshold_exp = 0;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private float _rendering_factor_width = 1.0f;
    private float _rendering_height = 0.0f;
    private String _node_name;

    public RenderableDomainArchitecture(DomainArchitecture domain_structure) {
        this._domain_structure = domain_structure;
    }

    public RenderableDomainArchitecture(DomainArchitecture domain_structure, String node_name) {
        this._domain_structure = domain_structure;
        this._node_name = node_name;
    }

    public static void setColorMap(Map<String, Color> domain_colors) {
        _domain_colors = domain_colors;
    }

    @Override
    public StringBuffer asSimpleText() {
        return this._domain_structure.asSimpleText();
    }

    @Override
    public StringBuffer asText() {
        return this._domain_structure.asText();
    }

    @Override
    public PhylogenyData copy() {
        return this._domain_structure.copy();
    }

    private final void drawDomain(double x, double y, double width, double heigth, String name, Graphics2D g, boolean to_pdf) {
        double h2 = heigth / 2.0;
        Color color_one = this.getColorOne(name);
        Color color_two = this.getColorTwo(color_one);
        double step = 1.0;
        if (to_pdf) {
            step = 0.05;
        }
        for (double i = 0.0; i < heigth; i += step) {
            g.setColor(ForesterUtil.calcColor(i >= h2 ? heigth - i : i, 0.0, h2, color_one, color_two));
            this._rectangle.setFrame(x, i + y, width, step);
            g.fill(this._rectangle);
        }
    }

    private final void drawDomainGrey(double x, double y, double width, double heigth, String name, Graphics2D g, boolean to_pdf) {
        double h2 = heigth / 2.0;
        Color color_one = Color.GRAY;
        Color color_two = this.getColorTwo(color_one);
        double step = 1.0;
        if (to_pdf) {
            step = 0.05;
        }
        for (double i = 0.0; i < heigth; i += step) {
            g.setColor(ForesterUtil.calcColor(i >= h2 ? heigth - i : i, 0.0, h2, color_one, color_two));
            this._rectangle.setFrame(x, i + y, width, step);
            g.fill(this._rectangle);
        }
    }

    private final Color getColorOne(String name) {
        Color c = _domain_colors.get(name);
        if (c == null) {
            c = AptxUtil.calculateColorFromString(name, false);
            if (c == null) {
                throw new IllegalStateException();
            }
            _domain_colors.put(name, c);
        }
        return c;
    }

    private Color getColorTwo(Color color_one) {
        int red = color_one.getRed() + 200;
        int green = color_one.getGreen() + 200;
        int blue = color_one.getBlue() + 200;
        return new Color(red > 255 ? 255 : red, green > 255 ? 255 : green, blue > 255 ? 255 : blue);
    }

    @Override
    public ProteinDomain getDomain(int i) {
        return this._domain_structure.getDomain(i);
    }

    @Override
    public SortedMap<BigDecimal, ProteinDomain> getDomains() {
        return this._domain_structure.getDomains();
    }

    @Override
    public int getNumberOfDomains() {
        return this._domain_structure.getNumberOfDomains();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this._domain_structure.getTotalLength(), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public Object getParameter() {
        return new Integer(this._e_value_threshold_exp);
    }

    public float getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return new Dimension(ForesterUtil.roundToInt((float)this._domain_structure.getTotalLength() * this.getRenderingFactorWidth()), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public int getTotalLength() {
        return this._domain_structure.getTotalLength();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return this._domain_structure.isEqual(data);
    }

    @Override
    public void render(float x1, float y1, Graphics2D g, TreePanel tree_panel, boolean to_pdf) {
        float f = this.getRenderingFactorWidth();
        float y = y1 + this._rendering_height / 2.0f;
        float start = x1 + 20.0f;
        Stroke s = g.getStroke();
        g.setStroke(STROKE_1);
        if (!to_pdf) {
            g.setColor(tree_panel.getTreeColorSet().getDomainBaseColor());
        } else {
            g.setColor(Constants.DOMAIN_BASE_COLOR_FOR_PDF);
        }
        this._rectangle.setFrame(start, (double)y - 0.5, (float)this._domain_structure.getTotalLength() * f, 1.0);
        g.fill(this._rectangle);
        int special_domain_count = 0;
        for (int i = 0; i < this._domain_structure.getDomains().size(); ++i) {
            ProteinDomain d = this._domain_structure.getDomain(i);
            if (!(d.getConfidence() <= Math.pow(10.0, this._e_value_threshold_exp)) && (!d.getName().equals(SPECIAL_DOMAIN) || !(d.getConfidence() <= 1.0))) continue;
            if (d.getName().equals(SPECIAL_DOMAIN)) {
                special_domain_count = (short)(special_domain_count + 1);
            }
            float xa = start + (float)d.getFrom() * f;
            float xb = xa + (float)d.getLength() * f;
            if (tree_panel.getMainPanel().getOptions().isShowDomainLabels() && tree_panel.getMainPanel().getTreeFontSet().getFontMetricsSmall().getHeight() > 4) {
                g.setFont(tree_panel.getMainPanel().getTreeFontSet().getSmallFont());
                if (!to_pdf) {
                    g.setColor(tree_panel.getTreeColorSet().getDomainLabelColor());
                } else {
                    g.setColor(Constants.DOMAIN_LABEL_COLOR_FOR_PDF);
                }
                g.drawString(d.getName(), xa, y1 + (float)tree_panel.getMainPanel().getTreeFontSet().getFontMetricsSmall().getAscent() + this._rendering_height);
            }
            if (this._node_name.indexOf("~") > 1 && d.getName().equals(SPECIAL_DOMAIN) && this._node_name.indexOf("~" + special_domain_count + "-") < 1) {
                this.drawDomainGrey(xa, y1, xb - xa, this._rendering_height, d.getName(), g, to_pdf);
                continue;
            }
            this.drawDomain(xa, y1, xb - xa, this._rendering_height, d.getName(), g, to_pdf);
        }
        g.setStroke(s);
    }

    @Override
    public void setParameter(double e_value_threshold_exp) {
        this._e_value_threshold_exp = (int)e_value_threshold_exp;
    }

    public void setRenderingFactorWidth(float rendering_factor_width) {
        this._rendering_factor_width = rendering_factor_width;
    }

    @Override
    public void setRenderingHeight(float rendering_height) {
        this._rendering_height = rendering_height;
    }

    @Override
    public StringBuffer toNHX() {
        return this._domain_structure.toNHX();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        this._domain_structure.toPhyloXML(writer, level, indentation);
    }
}

