/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JApplet;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.ws.wabi.RestUtil;

public final class Blast {
    public static final void openNcbiBlastWeb(String query, boolean is_nucleic_acids, JApplet applet, TreePanel p) {
        StringBuilder uri_str = new StringBuilder();
        uri_str.append("http://www.ncbi.nlm.nih.gov/blast/Blast.cgi?CMD=Web&DATABASE=nr&PAGE=");
        if (is_nucleic_acids) {
            uri_str.append("Nucleotide");
        } else {
            uri_str.append("Proteins");
        }
        uri_str.append("&QUERY=");
        uri_str.append(query);
        try {
            AptxUtil.launchWebBrowser(new URI(uri_str.toString()), applet != null, applet, "_aptx_blast");
        }
        catch (IOException e) {
            AptxUtil.showErrorMessage(p, e.toString());
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            AptxUtil.showErrorMessage(p, e.toString());
            e.printStackTrace();
        }
    }

    public static final String obtainQueryForBlast(PhylogenyNode node) {
        Accession id;
        String query = "";
        if (node.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getMolecularSequence())) {
                query = node.getNodeData().getSequence().getMolecularSequence();
            }
            if (ForesterUtil.isEmpty(query) && node.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getValue()) && (id = SequenceAccessionTools.parseAccessorFromString(node.getNodeData().getSequence().getAccession().getValue())) != null) {
                query = id.getValue();
            }
            if (ForesterUtil.isEmpty(query) && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getName()) && (id = SequenceAccessionTools.parseAccessorFromString(node.getNodeData().getSequence().getName())) != null) {
                query = id.getValue();
            }
            if (ForesterUtil.isEmpty(query) && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getSymbol()) && (id = SequenceAccessionTools.parseAccessorFromString(node.getNodeData().getSequence().getSymbol())) != null) {
                query = id.getValue();
            }
            if (ForesterUtil.isEmpty(query) && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getGeneName()) && (id = SequenceAccessionTools.parseAccessorFromString(node.getNodeData().getSequence().getGeneName())) != null) {
                query = id.getValue();
            }
        }
        if (ForesterUtil.isEmpty(query) && !ForesterUtil.isEmpty(node.getName()) && (id = SequenceAccessionTools.parseAccessorFromString(node.getName())) != null) {
            query = id.getValue();
        }
        return query;
    }

    public static final boolean isContainsQueryForBlast(PhylogenyNode node) {
        return !ForesterUtil.isEmpty(Blast.obtainQueryForBlast(node));
    }

    public final void ddbjBlast(String geneName) {
        String queryPath = "/ENTRY/DDBJ/division=='HUM' AND (/ENTRY/DDBJ/length>=300 AND /ENTRY/DDBJ/length<=1000) ";
        queryPath = queryPath + "AND (/ENTRY/DDBJ/feature-table/feature{/f_key = 'CDS' AND ";
        queryPath = queryPath + "/f_quals/qualifier{/q_name = 'gene' AND /q_value=='" + geneName + "'}})";
        String query = "service=ARSA&method=searchByXMLPath&queryPath=" + queryPath + "&returnPath=/ENTRY/DDBJ/primary-accession&offset=1&count=100";
        String arsaResult = null;
        try {
            arsaResult = RestUtil.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] arsaResultLines = arsaResult.split("\n");
        int arsaResultNum = Integer.parseInt(arsaResultLines[0].replaceAll("hitscount       =", "").trim());
        if (arsaResultNum == 0) {
            System.out.println("There is no entry for gene:" + geneName);
            return;
        }
        String repAccession = arsaResultLines[2];
        query = "service=GetEntry&method=getFASTA_DDBJEntry&accession=" + repAccession;
        String dnaSeq = null;
        try {
            dnaSeq = RestUtil.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Retrieved DNA sequence is: " + dnaSeq);
        query = "service=Blast&method=searchParam&program=blastn&database=ddbjpri ddbjrod ddbjmam ddbjvrt ddbjinv&query=" + dnaSeq + "&param=-m 8 -b 50 -v 50 -e 0.0001";
        String blastResult = null;
        try {
            blastResult = RestUtil.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] blastResultLines = blastResult.split("\n");
        Vector<String[]> parsedBlastResult = new Vector<String[]>();
        for (String blastResultLine : blastResultLines) {
            String[] cols = blastResultLine.split("\t");
            String accession = cols[1].substring(0, cols[1].indexOf("|"));
            String[] result = new String[]{accession, cols[2]};
            parsedBlastResult.add(result);
        }
        Hashtable<String, String> organismAccession = new Hashtable<String, String>();
        for (int i = 0; i < parsedBlastResult.size(); ++i) {
            String[] parsed = (String[])parsedBlastResult.elementAt(i);
            query = "service=ARSA&method=searchByXMLPath&queryPath=/ENTRY/DDBJ/primary-accession=='" + parsed[0] + "'&returnPath=/ENTRY/DDBJ/organism&offset=1&count=100";
            String organism = null;
            try {
                organism = RestUtil.getResult(query);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String[] organismLines = organism.split("\n");
            organism = organismLines[2];
            if (organismAccession.containsKey(organism)) continue;
            organismAccession.put(organism, parsed[0] + "\t" + parsed[1]);
        }
        System.out.println("DDBJ entries: " + arsaResultNum);
        System.out.println("Representative accession: " + repAccession);
        System.out.println("Organism name\tDDBJ accession number\tSequence similarity");
        Object[] keys = new String[organismAccession.size()];
        Enumeration enu = organismAccession.keys();
        int count = 0;
        while (enu.hasMoreElements()) {
            keys[count] = (String)enu.nextElement();
            ++count;
        }
        Arrays.sort(keys);
        for (Object key : keys) {
            System.out.println((String)key + "\t" + (String)organismAccession.get(key));
        }
    }
}

