/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.msa.MsaFormatException;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public final class GeneralMsaParser {
    private static final Pattern NAME_SEQ_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s*");
    private static final Pattern INDENTED_SEQ_PATTERN = Pattern.compile("\\s+(\\S+)\\s*");
    private static final Pattern NON_INDENTED_SEQ_PATTERN = Pattern.compile("(\\S+).*");
    private static final Pattern PROBCONS_REGEX = Pattern.compile("^CLUSTAL");
    private static final Pattern MUSCLE_REGEX = Pattern.compile("^MUSCLE\\s\\(");
    private static final Pattern CLUSTAL_REGEX = Pattern.compile("^PROBCONS\\s");
    private static final Pattern ANYTHING_REGEX = Pattern.compile("[\\d\\s]+");
    private static final Pattern SELEX_SPECIAL_LINES_REGEX = Pattern.compile("\\s+[*\\.:\\s]+");
    private static final Pattern SPECIAL_LINES_REGEX = Pattern.compile("^\\s*(#|%|//|!!)");
    private static final Pattern ERROR_REGEX = Pattern.compile("\\S+\\s+\\S+\\s+\\S+");

    private static boolean canIgnore(String line) {
        if (line.length() < 1 || ANYTHING_REGEX.matcher(line).matches()) {
            return true;
        }
        return SELEX_SPECIAL_LINES_REGEX.matcher(line).matches() || SPECIAL_LINES_REGEX.matcher(line).lookingAt();
    }

    private static boolean isProgramNameLine(String line) {
        return PROBCONS_REGEX.matcher(line).lookingAt() || CLUSTAL_REGEX.matcher(line).lookingAt() || MUSCLE_REGEX.matcher(line).lookingAt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Msa parse(InputStream is) throws IOException {
        int block = -1;
        int current_seq_index_per_block = -1;
        String current_name = null;
        boolean saw_ignorable = true;
        boolean is_first = true;
        HashMap<String, StringBuilder> temp_msa = new HashMap<String, StringBuilder>();
        ArrayList<String> names_in_order = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = null;
        int line_counter = 0;
        while ((line = reader.readLine()) != null) {
            String name;
            ++line_counter;
            if (GeneralMsaParser.canIgnore(line)) {
                saw_ignorable = true;
                continue;
            }
            if (is_first && GeneralMsaParser.isProgramNameLine(line)) continue;
            if (ERROR_REGEX.matcher(line).lookingAt()) {
                throw new MsaFormatException("unrecognized msa format (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
            }
            if (GeneralMsaParser.canIgnore(line)) {
                saw_ignorable = true;
            }
            Matcher name_seq_m = NAME_SEQ_PATTERN.matcher(line);
            Matcher ind_seq_m = null;
            Matcher non_ind_seq_m = null;
            boolean ind_seq_m_matches = false;
            boolean non_ind_seq_m_matches = false;
            boolean name_seq_m_matches = name_seq_m.matches();
            if (!name_seq_m_matches && !(ind_seq_m_matches = (ind_seq_m = INDENTED_SEQ_PATTERN.matcher(line)).matches())) {
                non_ind_seq_m = NON_INDENTED_SEQ_PATTERN.matcher(line);
                non_ind_seq_m_matches = non_ind_seq_m.lookingAt();
            }
            if (!name_seq_m_matches && !ind_seq_m_matches) {
                if (!non_ind_seq_m_matches) throw new MsaFormatException("illegal msa format (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
            }
            if (saw_ignorable) {
                ++block;
                current_seq_index_per_block = -1;
                saw_ignorable = false;
            }
            ++current_seq_index_per_block;
            if (name_seq_m_matches) {
                name = name_seq_m.group(1);
                String seq = name_seq_m.group(2);
                if (temp_msa.containsKey(name)) {
                    ((StringBuilder)temp_msa.get(name)).append(seq);
                } else {
                    temp_msa.put(name, new StringBuilder(seq));
                    names_in_order.add(name);
                }
                current_name = name;
            } else if (ind_seq_m_matches) {
                if (!temp_msa.containsKey(current_name)) throw new MsaFormatException("illegal msa format (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
                ((StringBuilder)temp_msa.get(current_name)).append(ind_seq_m.group(1));
            } else if (non_ind_seq_m_matches) {
                if (block == 0) {
                    throw new MsaFormatException("illegal msa format: first block cannot contain un-named sequence (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
                }
                name = "";
                try {
                    name = (String)names_in_order.get(current_seq_index_per_block);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new MsaFormatException("illegalmsa format (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
                }
                if (!temp_msa.containsKey(name)) throw new MsaFormatException("illegal msa format (line: " + line_counter + "):\n\"" + GeneralMsaParser.trim(line) + "\"");
                ((StringBuilder)temp_msa.get(name)).append(non_ind_seq_m.group(1));
                current_name = null;
            }
            if (!is_first) continue;
            is_first = false;
        }
        ArrayList<MolecularSequence> seqs = new ArrayList<MolecularSequence>();
        int i = 0;
        while (i < names_in_order.size()) {
            seqs.add(BasicSequence.createAaSequence((String)names_in_order.get(i), ((StringBuilder)temp_msa.get(names_in_order.get(i))).toString()));
            ++i;
        }
        return BasicMsa.createInstance(seqs);
    }

    private static String trim(String line) {
        if (line.length() > 100) {
            return line.substring(0, 100) + " ...";
        }
        return line;
    }
}

