/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class SequenceWriter {
    public static StringBuilder toFasta(MolecularSequence seq, int width) {
        return SequenceWriter.toFasta(seq.getIdentifier(), seq.getMolecularSequenceAsString(), width);
    }

    public static StringBuilder toFasta(String name, String mol_seq, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(">");
        sb.append(name);
        sb.append(ForesterUtil.LINE_SEPARATOR);
        if (width < 1 || width >= mol_seq.length()) {
            sb.append(mol_seq);
        } else {
            int lines = mol_seq.length() / width;
            int rest = mol_seq.length() - lines * width;
            for (int i = 0; i < lines; ++i) {
                sb.append(mol_seq, i * width, (i + 1) * width);
                if (i >= lines - 1) continue;
                sb.append(ForesterUtil.LINE_SEPARATOR);
            }
            if (rest > 0) {
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(mol_seq, lines * width, mol_seq.length());
            }
        }
        return sb;
    }

    public static void toFasta(MolecularSequence seq, Writer w, int width) throws IOException {
        w.write(">");
        w.write(seq.getIdentifier());
        w.write(ForesterUtil.LINE_SEPARATOR);
        if (width < 1 || width >= seq.getLength()) {
            w.write(seq.getMolecularSequence());
        } else {
            int lines = seq.getLength() / width;
            int rest = seq.getLength() - lines * width;
            for (int i = 0; i < lines; ++i) {
                w.write(seq.getMolecularSequence(), i * width, width);
                if (i >= lines - 1) continue;
                w.write(ForesterUtil.LINE_SEPARATOR);
            }
            if (rest > 0) {
                w.write(ForesterUtil.LINE_SEPARATOR);
                w.write(seq.getMolecularSequence(), lines * width, rest);
            }
        }
    }

    public static void writeSeqs(List<MolecularSequence> seqs, File file, SEQ_FORMAT format, int width) throws IOException {
        BufferedWriter w = ForesterUtil.createBufferedWriter(file);
        SequenceWriter.writeSeqs(seqs, w, format, width);
        ((Writer)w).close();
    }

    public static void writeSeqs(List<MolecularSequence> seqs, Writer writer, SEQ_FORMAT format, int width) throws IOException {
        switch (format) {
            case FASTA: {
                for (MolecularSequence s : seqs) {
                    SequenceWriter.toFasta(s, writer, width);
                    writer.write(ForesterUtil.LINE_SEPARATOR);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown format " + (Object)((Object)format));
            }
        }
    }

    public static enum SEQ_FORMAT {
        FASTA;

    }
}

