/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class PreorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final Stack<PhylogenyNode> _stack;

    public PreorderTreeIterator(Phylogeny tree) throws IllegalArgumentException {
        if (tree.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PreorderTreeIterator on empty tree.");
        }
        this._stack = new Stack();
        this._tree = tree;
        this.reset();
    }

    public PreorderTreeIterator(PhylogenyNode node) throws IllegalArgumentException {
        this._stack = new Stack();
        this._tree = null;
        this.reset(node);
    }

    @Override
    public final boolean hasNext() {
        return !this._stack.isEmpty();
    }

    @Override
    public final PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode node = this._stack.pop();
        if (!node.isExternal()) {
            for (int i = node.getNumberOfDescendants() - 1; i >= 0; --i) {
                this._stack.push(node.getChildNode(i));
            }
        }
        return node;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void reset() {
        this._stack.clear();
        this._stack.push(this._tree.getRoot());
    }

    private final void reset(PhylogenyNode node) {
        this._stack.clear();
        this._stack.push(node);
    }
}

