/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CountsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;

public class ProteinCountsBasedPairwiseDomainSimilarityCalculator
implements PairwiseDomainSimilarityCalculator {
    @Override
    public PairwiseDomainSimilarity calculateSimilarity(CombinableDomains domains_1, CombinableDomains domains_2) {
        if (!domains_1.getKeyDomain().equals(domains_2.getKeyDomain())) {
            throw new IllegalArgumentException("attempt to calculate similarity between domain collection with different keys");
        }
        if (domains_1.getKeyDomainProteinsCount() > Short.MAX_VALUE || domains_2.getKeyDomainProteinsCount() > Short.MAX_VALUE || domains_1.getKeyDomainProteinsCount() + domains_2.getKeyDomainCount() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("too large for short!");
        }
        short pc1 = (short)domains_1.getKeyDomainProteinsCount();
        short pc2 = (short)domains_2.getKeyDomainProteinsCount();
        return new CountsBasedPairwiseDomainSimilarity((short)(pc1 - pc2), (short)(pc1 + pc2));
    }
}

