/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class PhylogenyDecorator {
    private static final String TP_NODE_NAME = "NODE_NAME";
    private static final String TP_SEQ_ACCESSION = "SEQ_ACCESSION";
    private static final String TP_SEQ_ACCESSION_SOURCE = "SEQ_ACCESSION_SOURCE";
    private static final String TP_SEQ_ANNOTATION_DESC = "SEQ_ANNOTATION_DESC";
    private static final String TP_SEQ_ANNOTATION_REF = "SEQ_ANNOTATION_REF";
    private static final String TP_SEQ_MOL_SEQ = "SEQ_MOL_SEQ";
    private static final String TP_SEQ_NAME = "SEQ_NAME";
    private static final String TP_SEQ_SYMBOL = "SEQ_SYMBOL";
    private static final String TP_TAXONOMY_CN = "TAXONOMY_CN";
    private static final String TP_TAXONOMY_CODE = "TAXONOMY_CODE";
    private static final String TP_TAXONOMY_ID = "TAXONOMY_ID";
    private static final String TP_TAXONOMY_ID_PROVIDER = "TAXONOMY_ID_PROVIDER";
    private static final String TP_TAXONOMY_SN = "TAXONOMY_SN";
    private static final String TP_TAXONOMY_SYN = "TAXONOMY_SYN";

    private PhylogenyDecorator() {
    }

    public static void decorate(Phylogeny phylogeny, Map<String, Map<String, String>> map, boolean picky) throws IllegalArgumentException, PhyloXmlDataFormatException {
        PhylogenyNodeIterator iter = phylogeny.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            String name = node.getName();
            if (ForesterUtil.isEmpty(name)) continue;
            if (map.containsKey(name)) {
                Annotation ann;
                Map<String, String> new_values = map.get(name);
                if (new_values == null) continue;
                if (new_values.containsKey(TP_TAXONOMY_CODE)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setTaxonomyCode(new_values.get(TP_TAXONOMY_CODE));
                }
                if (new_values.containsKey(TP_TAXONOMY_ID) && new_values.containsKey(TP_TAXONOMY_ID_PROVIDER)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setIdentifier(new Identifier(new_values.get(TP_TAXONOMY_ID), new_values.get(TP_TAXONOMY_ID_PROVIDER)));
                } else if (new_values.containsKey(TP_TAXONOMY_ID)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setIdentifier(new Identifier(new_values.get(TP_TAXONOMY_ID)));
                }
                if (new_values.containsKey(TP_TAXONOMY_SN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setScientificName(new_values.get(TP_TAXONOMY_SN));
                }
                if (new_values.containsKey(TP_TAXONOMY_CN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setCommonName(new_values.get(TP_TAXONOMY_CN));
                }
                if (new_values.containsKey(TP_TAXONOMY_SYN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().getSynonyms().add(new_values.get(TP_TAXONOMY_SYN));
                }
                if (new_values.containsKey(TP_SEQ_ACCESSION) && new_values.containsKey(TP_SEQ_ACCESSION_SOURCE)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setAccession(new Accession(new_values.get(TP_SEQ_ACCESSION), new_values.get(TP_SEQ_ACCESSION_SOURCE)));
                }
                if (new_values.containsKey(TP_SEQ_ANNOTATION_DESC)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    ann = new Annotation();
                    ann.setDesc(new_values.get(TP_SEQ_ANNOTATION_DESC));
                    node.getNodeData().getSequence().addAnnotation(ann);
                }
                if (new_values.containsKey(TP_SEQ_ANNOTATION_REF)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    ann = new Annotation(new_values.get(TP_SEQ_ANNOTATION_REF));
                    node.getNodeData().getSequence().addAnnotation(ann);
                }
                if (new_values.containsKey(TP_SEQ_SYMBOL)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setSymbol(new_values.get(TP_SEQ_SYMBOL));
                }
                if (new_values.containsKey(TP_SEQ_NAME)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setName(new_values.get(TP_SEQ_NAME));
                }
                if (new_values.containsKey(TP_SEQ_MOL_SEQ)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setMolecularSequence(new_values.get(TP_SEQ_MOL_SEQ));
                }
                if (!new_values.containsKey(TP_NODE_NAME)) continue;
                node.setName(new_values.get(TP_NODE_NAME));
                continue;
            }
            if (!picky) continue;
            throw new IllegalArgumentException("\"" + name + "\" not found in name map");
        }
    }

    public static String decorate(Phylogeny phylogeny, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean extract_bracketed_tax_code, boolean picky, boolean cut_name_after_space, boolean trim_after_tilde, boolean verbose) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        return PhylogenyDecorator.decorate(phylogeny, map, field, extract_bracketed_scientific_name, extract_bracketed_tax_code, picky, null, cut_name_after_space, trim_after_tilde, verbose);
    }

    public static String decorate(Phylogeny phylogeny, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean extract_bracketed_tax_code, boolean picky, Map<String, String> intermediate_map, boolean cut_name_after_space, boolean trim_after_tilde, boolean verbose) throws IllegalArgumentException, PhyloXmlDataFormatException {
        if (extract_bracketed_scientific_name && field == FIELD.TAXONOMY_SCIENTIFIC_NAME) {
            throw new IllegalArgumentException("attempt to extract bracketed scientific name together with data field pointing to scientific name");
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("map is empty");
        }
        int ext_nodes = 0;
        int ext_nodes_updated = 0;
        int int_nodes = 0;
        int int_nodes_updated = 0;
        PhylogenyNodeIterator iter = phylogeny.iteratorPostorder();
        block9: while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isExternal()) {
                ++ext_nodes;
            } else {
                ++int_nodes;
            }
            String name = node.getName();
            if (picky && node.isExternal() && ForesterUtil.isEmpty(name)) {
                throw new IllegalArgumentException("external node with no name present");
            }
            String tilde_annotation = null;
            String orig_name = name;
            if (trim_after_tilde && name.indexOf(126) > 0) {
                int ti = name.indexOf(126);
                tilde_annotation = name.substring(ti);
                name = name.substring(0, ti);
                if (node.isExternal() && ForesterUtil.isEmpty(name)) {
                    throw new IllegalArgumentException("external node with illegal name: " + orig_name);
                }
            }
            if (ForesterUtil.isEmpty(name)) continue;
            if (intermediate_map != null) {
                name = PhylogenyDecorator.extractIntermediate(intermediate_map, name, verbose);
            }
            if (field == FIELD.MOL_SEQ && !map.containsKey(name)) {
                name = orig_name;
            }
            if (map.containsKey(name)) {
                String new_value = map.get(name).trim().replaceAll("/\\s+/", " ");
                if (!ForesterUtil.isEmpty(new_value)) {
                    if (node.isExternal()) {
                        ++ext_nodes_updated;
                    } else {
                        ++int_nodes_updated;
                    }
                    if (extract_bracketed_scientific_name && new_value.endsWith("]")) {
                        new_value = PhylogenyDecorator.extractBracketedScientificNames(node, new_value);
                    } else if (extract_bracketed_tax_code) {
                        if (ParserUtils.TAXOMONY_CODE_PATTERN_BRACKETED.matcher(new_value).find()) {
                            new_value = PhylogenyDecorator.extractBracketedTaxCodes(node, new_value);
                        } else if (picky) {
                            throw new IllegalArgumentException(" could not get taxonomy from \"" + new_value + "\"");
                        }
                    }
                    switch (field) {
                        case MOL_SEQ: {
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            if (!node.getNodeData().isHasSequence()) {
                                node.getNodeData().setSequence(new Sequence());
                            }
                            node.getNodeData().getSequence().setMolecularSequence(new_value);
                            MolecularSequence.TYPE type = ForesterUtil.guessMolecularSequenceType(new_value);
                            if (type == null) continue block9;
                            if (type == MolecularSequence.TYPE.AA) {
                                node.getNodeData().getSequence().setType("protein");
                                continue block9;
                            }
                            if (type == MolecularSequence.TYPE.DNA) {
                                node.getNodeData().getSequence().setType("dna");
                                continue block9;
                            }
                            if (type != MolecularSequence.TYPE.RNA) continue block9;
                            node.getNodeData().getSequence().setType("rna");
                            continue block9;
                        }
                        case SEQUENCE_ANNOTATION_DESC: {
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            if (!node.getNodeData().isHasSequence()) {
                                node.getNodeData().setSequence(new Sequence());
                            }
                            Annotation annotation = new Annotation();
                            annotation.setDesc(new_value);
                            node.getNodeData().getSequence().addAnnotation(annotation);
                            continue block9;
                        }
                        case DOMAIN_STRUCTURE: {
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            if (!node.getNodeData().isHasSequence()) {
                                node.getNodeData().setSequence(new Sequence());
                            }
                            node.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(new_value));
                            continue block9;
                        }
                        case TAXONOMY_CODE: {
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            ForesterUtil.ensurePresenceOfTaxonomy(node);
                            node.getNodeData().getTaxonomy().setTaxonomyCode(new_value);
                            continue block9;
                        }
                        case TAXONOMY_SCIENTIFIC_NAME: {
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            ForesterUtil.ensurePresenceOfTaxonomy(node);
                            node.getNodeData().getTaxonomy().setScientificName(new_value);
                            continue block9;
                        }
                        case SEQUENCE_NAME: {
                            if (trim_after_tilde) {
                                new_value = PhylogenyDecorator.addTildeAnnotation(tilde_annotation, new_value);
                            }
                            if (verbose) {
                                System.out.println(name + ": " + new_value);
                            }
                            if (!node.getNodeData().isHasSequence()) {
                                node.getNodeData().setSequence(new Sequence());
                            }
                            node.getNodeData().getSequence().setName(new_value);
                            continue block9;
                        }
                        case NODE_NAME: {
                            if (verbose) {
                                System.out.print(name + " -> ");
                            }
                            if (cut_name_after_space) {
                                if (verbose) {
                                    System.out.print(new_value + " -> ");
                                }
                                new_value = PhylogenyDecorator.deleteAtFirstSpace(new_value);
                            }
                            if (trim_after_tilde) {
                                new_value = PhylogenyDecorator.addTildeAnnotation(tilde_annotation, new_value);
                            }
                            if (verbose) {
                                System.out.println(new_value);
                            }
                            node.setName(new_value);
                            continue block9;
                        }
                        default: {
                            throw new RuntimeException("unknown field \"" + (Object)((Object)field) + "\"");
                        }
                    }
                }
                throw new IllegalArgumentException("node name \"" + name + "\" maps to empty value");
            }
            if (!picky) continue;
            throw new IllegalArgumentException("node name \"" + name + "\" not found in map");
        }
        return "updated " + ext_nodes_updated + "/" + ext_nodes + " external nodes, updated " + int_nodes_updated + "/" + int_nodes + " internal nodes";
    }

    public static Map<String, Map<String, String>> parseMappingTable(File mapping_table_file) throws IOException {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        BasicTable<String> mapping_table = null;
        mapping_table = BasicTableParser.parse(mapping_table_file, '\t', false, false);
        for (int row = 0; row < mapping_table.getNumberOfRows(); ++row) {
            HashMap<String, String> row_map = new HashMap<String, String>();
            String name = null;
            for (int col = 0; col < mapping_table.getNumberOfColumns(); ++col) {
                String table_cell = mapping_table.getValue(col, row);
                if (col == 0) {
                    name = table_cell;
                    continue;
                }
                if (table_cell == null) continue;
                String key = table_cell.substring(0, table_cell.indexOf(58));
                String val = table_cell.substring(table_cell.indexOf(58) + 1, table_cell.length());
                row_map.put(key, val);
            }
            map.put(name, row_map);
        }
        return map;
    }

    private static final String addTildeAnnotation(String tilde_annotation, String new_value) {
        if (ForesterUtil.isEmpty(tilde_annotation)) {
            return new_value;
        }
        return new_value + tilde_annotation;
    }

    private static String deleteAtFirstSpace(String name) {
        int first_space = name.indexOf(" ");
        if (first_space > 1) {
            return name.substring(0, first_space).trim();
        }
        return name;
    }

    private static String extractBracketedScientificNames(PhylogenyNode node, String new_value) {
        int i = new_value.lastIndexOf("[");
        String scientific_name = new_value.substring(i + 1, new_value.length() - 1);
        ForesterUtil.ensurePresenceOfTaxonomy(node);
        node.getNodeData().getTaxonomy().setScientificName(scientific_name);
        return new_value.substring(0, i - 1).trim();
    }

    private static String extractBracketedTaxCodes(PhylogenyNode node, String new_value) {
        StringBuilder sb = new StringBuilder();
        sb.append(new_value);
        String tc = PhylogenyDecorator.extractBracketedTaxCodes(sb);
        if (!ForesterUtil.isEmpty(tc)) {
            ForesterUtil.ensurePresenceOfTaxonomy(node);
            try {
                node.getNodeData().getTaxonomy().setTaxonomyCode(tc);
            }
            catch (PhyloXmlDataFormatException e) {
                throw new IllegalArgumentException("illegal format for taxonomy code: " + tc);
            }
            return sb.toString().trim();
        }
        return new_value;
    }

    private static String extractBracketedTaxCodes(StringBuilder sb) {
        Matcher m = ParserUtils.TAXOMONY_CODE_PATTERN_BRACKETED.matcher(sb);
        if (m.find()) {
            String tc = m.group(1);
            sb.delete(m.start(1) - 1, m.end(1) + 1);
            return tc;
        }
        return null;
    }

    private static String extractIntermediate(Map<String, String> intermediate_map, String name, boolean verbose) {
        String new_name = null;
        if (verbose) {
            System.out.print(name + " => ");
        }
        if (intermediate_map.containsKey(name)) {
            new_name = intermediate_map.get(name);
            if (ForesterUtil.isEmpty(new_name)) {
                throw new IllegalArgumentException("\"" + name + "\" maps to null or empty string in secondary map");
            }
        } else {
            throw new IllegalArgumentException("\"" + name + "\" not found in name secondary map");
        }
        if (verbose) {
            System.out.println(new_name + "  ");
        }
        return new_name;
    }

    public static enum FIELD {
        DOMAIN_STRUCTURE,
        MOL_SEQ,
        NODE_NAME,
        SEQUENCE_ANNOTATION_DESC,
        SEQUENCE_NAME,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME;

    }
}

