/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.forester.util.ForesterUtil;

public class BasicTable<E> {
    private int _max_col;
    private int _max_row;
    private Map<String, Map<String, E>> _rows;

    public BasicTable() {
        this.init();
    }

    public int findRow(String first_col_value) throws IllegalArgumentException {
        int result = -1;
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            if (!this.getValueAsString(0, i).equals(first_col_value)) continue;
            if (result >= 0) {
                throw new IllegalArgumentException("\"" + first_col_value + "\" is not unique");
            }
            result = i;
        }
        return result;
    }

    public Map<String, E> getColumnsAsMap(int key_col, int value_col) throws IllegalArgumentException {
        HashMap<String, E> map = new HashMap<String, E>();
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            String key = (String)this.getValue(key_col, row);
            E value = this.getValue(value_col, row);
            if (key == null || value == null) continue;
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("attempt to use non-unique table value as key [" + key + "]");
            }
            map.put(key, value);
        }
        return map;
    }

    public Map<String, Double> getColumnsAsMapDouble(int key_col, int value_col) throws IllegalArgumentException, IOException {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            String key = (String)this.getValue(key_col, row);
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getValueAsString(value_col, row));
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
            if (key == null) continue;
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("attempt to use non-unique table value as key [" + key + "]");
            }
            map.put(key, value);
        }
        return map;
    }

    public int getNumberOfColumns() {
        return this._max_col + 1;
    }

    public int getNumberOfRows() {
        return this._max_row + 1;
    }

    public final String getRowAsString(int row, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int col = 0; col < this.getNumberOfColumns(); ++col) {
            sb.append(this.getValue(col, row).toString());
            if (col >= this.getNumberOfColumns() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public E getValue(int col, int row) throws IllegalArgumentException {
        if (row > this.getNumberOfRows() - 1 || row < 0) {
            throw new IllegalArgumentException("value for row (" + row + ") is out of range [number of rows: " + this.getNumberOfRows() + "]");
        }
        if (col >= this.getNumberOfColumns() || row < 0) {
            throw new IllegalArgumentException("value for column (" + col + ") is out of range [number of columns: " + this.getNumberOfColumns() + "]");
        }
        Map<String, E> row_map = this.getRow(row);
        if (row_map == null || row_map.size() < 1) {
            return null;
        }
        return row_map.get("" + col);
    }

    public String getValueAsString(int col, int row) throws IllegalArgumentException {
        if (this.getValue(col, row) != null) {
            return this.getValue(col, row).toString();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getNumberOfRows() <= 0;
    }

    public void setValue(int col, int row, E value) {
        if (row < 0 || col < 0) {
            throw new IllegalArgumentException("attempt to use negative values for row or column");
        }
        if (row > this.getNumberOfRows() - 1) {
            this.setMaxRow(row);
        }
        if (col > this.getNumberOfColumns() - 1) {
            this.setMaxCol(col);
        }
        String row_key = "" + row;
        Map<Object, Object> row_map = null;
        if (this.getRows().containsKey(row_key)) {
            row_map = this.getRows().get(row_key);
        } else {
            row_map = new HashMap();
            this.getRows().put(row_key, row_map);
        }
        row_map.put("" + col, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getNumberOfColumns(); ++col) {
                sb.append(this.getValue(col, row));
                if (col >= this.getNumberOfColumns() - 1) continue;
                sb.append(" ");
            }
            if (row >= this.getNumberOfRows() - 1) continue;
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private Map<String, E> getRow(int row) {
        return this.getRows().get("" + row);
    }

    private Map<String, Map<String, E>> getRows() {
        return this._rows;
    }

    private void init() {
        this._rows = new HashMap<String, Map<String, E>>();
        this.setMaxCol(-1);
        this.setMaxRow(-1);
    }

    private void setMaxCol(int max_col) {
        this._max_col = max_col;
    }

    private void setMaxRow(int max_row) {
        this._max_row = max_row;
    }
}

