/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CommandProcessBuilder {
    public static Process execute(List<String> command, File working_dir) throws InterruptedException, IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        if (working_dir != null) {
            if (!working_dir.exists()) {
                throw new IllegalArgumentException("directory [" + working_dir.getAbsolutePath() + "] does not exist");
            }
            if (!working_dir.isDirectory()) {
                throw new IllegalArgumentException("[" + working_dir.getAbsolutePath() + "] is not a directory");
            }
            if (!working_dir.canWrite()) {
                throw new IllegalArgumentException("cannot write to [" + working_dir.getAbsolutePath() + "]");
            }
            builder.directory(working_dir);
        }
        Process process = builder.start();
        return process;
    }

    public static void main(String[] args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(System.getenv("windir") + "\\system32\\tree.com");
        command.add("/A");
        System.out.println("Directory : " + System.getenv("temp"));
        try {
            String line;
            Process p = CommandProcessBuilder.execute(command, new File(System.getenv("temp")));
            InputStream is = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            System.out.println("OK.");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

