/*
 * Decompiled with CFR 0.152.
 */
package rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractBaseRest {
    protected static String BASE_URL = "http://localhost:{SERVER_PORT}/api";
    protected RestTemplate restTemplate = new RestTemplate();
    protected HttpHeaders httpHeaders = new HttpHeaders();
    protected GsonBuilder builder = new GsonBuilder();
    protected Gson gson = this.builder.create();
    protected static final String USERS_PATH = "/users";
    protected static final String EXERCISES_PATH = "/exercises";
    protected static final String LOG_PATH = "/log";
    protected HttpEntity<String> entity;

    public AbstractBaseRest() {
        this.buildHeaders().buildBaseURL();
    }

    private AbstractBaseRest buildHeaders() {
        this.httpHeaders.set("Content-Type", "application/json");
        return this;
    }

    private AbstractBaseRest buildBaseURL() {
        String serverPortArgument = System.getProperty("server.port");
        BASE_URL = serverPortArgument == null ? BASE_URL.replace("{SERVER_PORT}", "8080") : BASE_URL.replace("{SERVER_PORT}", serverPortArgument);
        return this;
    }

    protected ResponseEntity<String> post(String path, HttpEntity<String> entity) {
        return this.restTemplate.exchange(BASE_URL + path, HttpMethod.POST, entity, String.class, new Object[0]);
    }

    protected HttpEntity<String> buildEntity(String string) {
        return new HttpEntity((Object)string, (MultiValueMap)this.httpHeaders);
    }

    protected <T> String toJson(T type) {
        return this.gson.toJson(type);
    }
}

