/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jose4j.base64url.SimplePEMEncoder;
import org.jose4j.lang.JoseException;

public class X509Util {
    private static final String FACTORY_TYPE = "X.509";
    private CertificateFactory certFactory;

    public X509Util() {
        try {
            this.certFactory = CertificateFactory.getInstance(FACTORY_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Couldn't find X.509 CertificateFactory!?!", e);
        }
    }

    public String toPem(X509Certificate x509Certificate) {
        try {
            byte[] der = x509Certificate.getEncoded();
            return SimplePEMEncoder.encode(der);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Unexpected problem getting encoded certificate.", e);
        }
    }

    public X509Certificate fromBase64Der(String b64EncodedDer) throws JoseException {
        byte[] der = SimplePEMEncoder.decode(b64EncodedDer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(der);
        try {
            Certificate certificate = this.certFactory.generateCertificate(byteArrayInputStream);
            return (X509Certificate)certificate;
        }
        catch (CertificateException e) {
            throw new JoseException("Unable to convert " + b64EncodedDer + " value to X509Certificate: " + e, e);
        }
    }
}

