/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class HttpsJwks {
    private static Log log = LogFactory.getLog(HttpsJwks.class);
    private String location;
    private long defaultCacheDuration = 3600L;
    private SimpleGet simpleHttpGet = new Get();
    private Cache cache = new Cache(Collections.emptyList(), 0L);

    public HttpsJwks(String location) {
        this.location = location;
    }

    public void setDefaultCacheDuration(long defaultCacheDuration) {
        this.defaultCacheDuration = defaultCacheDuration;
    }

    public void setSimpleHttpGet(SimpleGet simpleHttpGet) {
        this.simpleHttpGet = simpleHttpGet;
    }

    public String getLocation() {
        return this.location;
    }

    public List<JsonWebKey> getJsonWebKeys() throws JoseException, IOException {
        if (this.cache.getExp() < System.currentTimeMillis()) {
            this.refresh();
        }
        return this.cache.getKeys();
    }

    public void refresh() throws JoseException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing/loading JWKS from " + this.location));
        }
        SimpleResponse simpleResponse = this.simpleHttpGet.get(this.location);
        JsonWebKeySet jwks = new JsonWebKeySet(simpleResponse.getBody());
        List<JsonWebKey> keys = jwks.getJsonWebKeys();
        long cacheLife = HttpsJwks.getCacheLife(simpleResponse);
        if (cacheLife <= 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will use default cache duration of " + this.defaultCacheDuration + " seconds for content from " + this.location));
            }
            cacheLife = this.defaultCacheDuration;
        }
        long exp = System.currentTimeMillis() + cacheLife * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updated JWKS content from " + this.location + " will be cached for " + cacheLife + " seconds until " + new Date(exp) + " -> " + keys));
        }
        this.cache = new Cache(keys, exp);
    }

    static long getDateHeaderValue(SimpleResponse response, String headerName, long defaultValue) {
        List<String> values = HttpsJwks.getHeaderValues(response, headerName);
        for (String value : values) {
            try {
                if (!value.endsWith("GMT")) {
                    value = value + " GMT";
                }
                return Date.parse(value);
            }
            catch (Exception e) {
            }
        }
        return defaultValue;
    }

    private static List<String> getHeaderValues(SimpleResponse response, String headerName) {
        List<String> values = response.getHeaderValues(headerName);
        return values == null ? Collections.emptyList() : values;
    }

    static long getExpires(SimpleResponse response) {
        return HttpsJwks.getDateHeaderValue(response, "expires", 0L);
    }

    static long getCacheLife(SimpleResponse response) {
        return HttpsJwks.getCacheLife(response, System.currentTimeMillis());
    }

    static long getCacheLife(SimpleResponse response, long currentTime) {
        long expires = HttpsJwks.getExpires(response);
        long life = (expires - currentTime) / 1000L;
        List<String> values = HttpsJwks.getHeaderValues(response, "cache-control");
        for (String value : values) {
            try {
                value = value == null ? "" : value.toLowerCase();
                int indexOfMaxAge = value.indexOf("max-age");
                int indexOfComma = value.indexOf(44, indexOfMaxAge);
                int end = indexOfComma == -1 ? value.length() : indexOfComma;
                String part = value.substring(indexOfMaxAge, end);
                part = part.substring(part.indexOf(61) + 1);
                part = part.trim();
                life = Long.parseLong(part);
                break;
            }
            catch (Exception e) {
            }
        }
        return life;
    }

    private static class Cache {
        private List<JsonWebKey> keys;
        private long exp;

        private Cache(List<JsonWebKey> keys, long exp) {
            this.keys = keys;
            this.exp = exp;
        }

        private List<JsonWebKey> getKeys() {
            return this.keys;
        }

        private long getExp() {
            return this.exp;
        }
    }
}

