/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.tojsonstring;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.bitbucket.cowwoc.preconditions.Preconditions;
import org.bitbucket.cowwoc.tojsonstring.BraceStyle;

public final class ToJsonString {
    private final Map<String, Object> map = Maps.newLinkedHashMap();
    private Optional<String> className = Optional.empty();
    private BraceStyle braceStyle = BraceStyle.NEW_LINE;
    private int indentSize = 2;

    public ToJsonString setName(Optional<String> className) throws NullPointerException {
        Preconditions.requireThat(className, (String)"className").isNotNull();
        this.className = className;
        return this;
    }

    public ToJsonString setName(Class<?> clazz) throws NullPointerException {
        Preconditions.requireThat(clazz, (String)"clazz").isNotNull();
        return this.setName(Optional.of(clazz.getName()));
    }

    public ToJsonString setIndentSize(int indentSize) throws IllegalArgumentException {
        Preconditions.requireThat((Number)indentSize, (String)"indentSize").isNotNegative();
        this.indentSize = indentSize;
        return this;
    }

    public ToJsonString setBraceStyle(BraceStyle braceStyle) throws NullPointerException {
        Preconditions.requireThat((Object)((Object)braceStyle), (String)"braceStyle may not be null").isNotNull();
        this.braceStyle = braceStyle;
        return this;
    }

    public ToJsonString putAllFields(Object obj) throws NullPointerException, IllegalArgumentException {
        Preconditions.requireThat((Object)obj, (String)"obj may not be null").isNotNull();
        AccessController.doPrivileged(() -> {
            try {
                for (Field field : obj.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    this.put(field.getName(), field.get(obj));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        return this;
    }

    public ToJsonString put(String key, Object value) {
        Preconditions.requireThat((String)key, (String)"key may not be null").isNotNull();
        this.map.put(key, value);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        result.append(this.className.orElse(""));
        switch (this.braceStyle) {
            case NEW_LINE: {
                result.append("\n{\n");
                break;
            }
            case SAME_LINE: {
                result.append(" {\n");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected braceStyle: " + (Object)((Object)this.braceStyle)));
            }
        }
        String separator = "";
        String indent = Strings.repeat((String)" ", (int)this.indentSize);
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            result.append(separator).append(indent).append("\"").append(entry.getKey()).append("\": ");
            Object value = entry.getValue();
            if (value instanceof String) {
                result.append("\"");
            }
            if (value == null) {
                result.append("null");
            } else if (value.getClass().isArray()) {
                String arrayValue;
                if (value instanceof Object[]) {
                    arrayValue = Arrays.toString((Object[])value);
                } else if (value instanceof byte[]) {
                    arrayValue = Arrays.toString((byte[])value);
                } else if (value instanceof short[]) {
                    arrayValue = Arrays.toString((short[])value);
                } else if (value instanceof int[]) {
                    arrayValue = Arrays.toString((int[])value);
                } else if (value instanceof long[]) {
                    arrayValue = Arrays.toString((long[])value);
                } else if (value instanceof char[]) {
                    arrayValue = Arrays.toString((char[])value);
                } else if (value instanceof float[]) {
                    arrayValue = Arrays.toString((float[])value);
                } else if (value instanceof double[]) {
                    arrayValue = Arrays.toString((double[])value);
                } else if (value instanceof boolean[]) {
                    arrayValue = Arrays.toString((boolean[])value);
                } else {
                    throw new AssertionError((Object)("Unexpected array type: " + value.getClass().getName()));
                }
                result.append(arrayValue.replace("\n", "\n" + indent));
            } else {
                result.append(value.toString().replace("\n", "\n" + indent));
            }
            if (value instanceof String) {
                result.append("\"");
            }
            separator = ",\n";
        }
        return result.append("\n}").toString();
    }
}

