/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import com.google.common.collect.Range;
import java.math.BigDecimal;
import org.bitbucket.cowwoc.preconditions.NumberPreconditions;
import org.bitbucket.cowwoc.preconditions.Preconditions;

public final class BigDecimalPreconditions
extends NumberPreconditions<BigDecimalPreconditions, BigDecimal> {
    BigDecimalPreconditions(BigDecimal parameter, String name) throws NullPointerException, IllegalArgumentException {
        super(parameter, name);
    }

    public BigDecimalPreconditions hasPrecisionIn(Range<Integer> range) throws NullPointerException, IllegalArgumentException {
        ((Preconditions)Preconditions.requireThat(range, "range")).isNotNull();
        boolean inRange = range.contains((Comparable)Integer.valueOf(((BigDecimal)this.parameter).precision()));
        if (inRange) {
            return this;
        }
        StringBuilder message = new StringBuilder(this.name + ".precision() (" + ((BigDecimal)this.parameter).precision() + ") must be in the range ");
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append("(");
                break;
            }
            case CLOSED: {
                message.append("[");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        message.append(range.lowerEndpoint()).append(", ").append(range.upperEndpoint());
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append(")");
                break;
            }
            case CLOSED: {
                message.append("]");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        throw new IllegalArgumentException(message.toString());
    }

    public BigDecimalPreconditions hasScaleIn(Range<Integer> range) throws NullPointerException, IllegalArgumentException {
        ((Preconditions)Preconditions.requireThat(range, "range")).isNotNull();
        boolean inRange = range.contains((Comparable)Integer.valueOf(((BigDecimal)this.parameter).scale()));
        if (inRange) {
            return this;
        }
        StringBuilder message = new StringBuilder(this.name + ".scale() (" + ((BigDecimal)this.parameter).scale() + ") must " + "be in the range ");
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append("(");
                break;
            }
            case CLOSED: {
                message.append("[");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        message.append(range.lowerEndpoint()).append(", ").append(range.upperEndpoint());
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append(")");
                break;
            }
            case CLOSED: {
                message.append("]");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        throw new IllegalArgumentException(message.toString());
    }
}

