/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import com.google.common.collect.Range;
import java.math.BigDecimal;
import org.bitbucket.cowwoc.preconditions.Preconditions;

public class NumberPreconditions<S extends NumberPreconditions<S, T>, T extends Number>
extends Preconditions<S, T> {
    NumberPreconditions(T parameter, String name) throws NullPointerException, IllegalArgumentException {
        super(parameter, name);
    }

    public S isIn(Range<T> range) throws NullPointerException, IllegalArgumentException {
        ((Preconditions)Preconditions.requireThat(range, "range")).isNotNull();
        boolean inRange = range.contains((Comparable)this.parameter);
        if (inRange) {
            return (S)((NumberPreconditions)this.self);
        }
        StringBuilder message = new StringBuilder(this.name + " (" + this.parameter + ") must be in the range ");
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append("(");
                break;
            }
            case CLOSED: {
                message.append("[");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        message.append(range.lowerEndpoint()).append(", ").append(range.upperEndpoint());
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append(")");
                break;
            }
            case CLOSED: {
                message.append("]");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        throw new IllegalArgumentException(message.toString());
    }

    public S isNegative() throws IllegalArgumentException {
        if (((Number)this.parameter).longValue() >= 0L) {
            throw new IllegalArgumentException(this.name + " must be negative");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isNotNegative() throws IllegalArgumentException {
        if (((Number)this.parameter).longValue() < 0L) {
            throw new IllegalArgumentException(this.name + " may not be negative");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isZero() throws IllegalArgumentException {
        if (this.parameter instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)this.parameter;
            if (decimal.signum() != 0) {
                throw new IllegalArgumentException(this.name + " must be zero");
            }
            return (S)((NumberPreconditions)this.self);
        }
        if (((Number)this.parameter).longValue() != 0L) {
            throw new IllegalArgumentException(this.name + " must be zero");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isNotZero() throws IllegalArgumentException {
        if (this.parameter instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)this.parameter;
            if (decimal.signum() == 0) {
                throw new IllegalArgumentException(this.name + " may not be zero");
            }
            return (S)((NumberPreconditions)this.self);
        }
        if (((Number)this.parameter).longValue() == 0L) {
            throw new IllegalArgumentException(this.name + " may not be zero");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isPositive() throws IllegalArgumentException {
        if (((Number)this.parameter).longValue() <= 0L) {
            throw new IllegalArgumentException(this.name + " must be positive");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isNotPositive() throws IllegalArgumentException {
        if (((Number)this.parameter).longValue() > 0L) {
            throw new IllegalArgumentException(this.name + " may not be positive");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isLessThan(T value, String name) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) >= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + name + " (" + value + ")");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isLessThan(T value) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) >= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + value);
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isLessThanOrEqualTo(T value, String name) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) > 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + "or equal to " + name + " (" + value + ")");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isLessThanOrEqualTo(T value) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) > 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + "or equal to " + value);
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isGreaterThan(T value, String name) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) <= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + name + " (" + value + ")");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isGreaterThan(T value) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) <= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + value);
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isGreaterThanOrEqualTo(T value, String name) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) < 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + "or equal to " + name + " (" + value + ")");
        }
        return (S)((NumberPreconditions)this.self);
    }

    public S isGreaterThanOrEqualTo(T value) throws IllegalArgumentException {
        if (((Comparable)((Object)((Number)this.parameter))).compareTo(value) < 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + "or equal to " + value);
        }
        return (S)((NumberPreconditions)this.self);
    }
}

