/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.bitbucket.cowwoc.preconditions.Preconditions;

public final class PathPreconditions
extends Preconditions<PathPreconditions, Path> {
    PathPreconditions(Path parameter, String name) throws NullPointerException, IllegalArgumentException {
        super(parameter, name);
    }

    public PathPreconditions exists() throws IllegalArgumentException {
        if (!Files.exists((Path)this.parameter, new LinkOption[0])) {
            throw new IllegalArgumentException(this.name + " refers to a non-existent path: " + ((Path)this.parameter).toAbsolutePath());
        }
        return this;
    }

    public PathPreconditions isRegularFile(LinkOption ... options) throws IllegalArgumentException, IOException {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes((Path)this.parameter, BasicFileAttributes.class, options);
        }
        catch (NoSuchFileException e) {
            throw new IllegalArgumentException(this.name + " refers to a non-existent path: " + ((Path)this.parameter).toAbsolutePath(), e);
        }
        if (!attrs.isRegularFile()) {
            throw new IllegalArgumentException(this.name + " must refer to a file. Was: " + ((Path)this.parameter).toAbsolutePath());
        }
        return this;
    }

    public PathPreconditions isDirectory(LinkOption ... options) throws IllegalArgumentException, IOException {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes((Path)this.parameter, BasicFileAttributes.class, options);
        }
        catch (NoSuchFileException e) {
            throw new IllegalArgumentException(this.name + " refers to a non-existent path: " + ((Path)this.parameter).toAbsolutePath(), e);
        }
        if (!attrs.isDirectory()) {
            throw new IllegalArgumentException(this.name + " must refer to a directory. Was: " + ((Path)this.parameter).toAbsolutePath());
        }
        return this;
    }

    public PathPreconditions isRelative() throws IllegalArgumentException {
        if (((Path)this.parameter).isAbsolute()) {
            throw new IllegalArgumentException(this.name + " must refer to a relative path. Was: " + this.parameter);
        }
        return this;
    }

    public PathPreconditions isAbsolute() throws IllegalArgumentException {
        if (!((Path)this.parameter).isAbsolute()) {
            throw new IllegalArgumentException(this.name + " must refer to an absolute path. Was: " + this.parameter);
        }
        return this;
    }
}

