/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Path;
import java.time.Year;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bitbucket.cowwoc.preconditions.BigDecimalPreconditions;
import org.bitbucket.cowwoc.preconditions.ClassPreconditions;
import org.bitbucket.cowwoc.preconditions.CollectionPreconditions;
import org.bitbucket.cowwoc.preconditions.MapPreconditions;
import org.bitbucket.cowwoc.preconditions.NumberPreconditions;
import org.bitbucket.cowwoc.preconditions.OptionalPreconditions;
import org.bitbucket.cowwoc.preconditions.PathPreconditions;
import org.bitbucket.cowwoc.preconditions.StringPreconditions;
import org.bitbucket.cowwoc.preconditions.UriPreconditions;
import org.bitbucket.cowwoc.preconditions.YearPreconditions;

public class Preconditions<S extends Preconditions<S, T>, T> {
    protected final S self;
    protected T parameter;
    protected final String name;

    public static <S extends Preconditions<S, T>, T> S requireThat(T parameter, String name) throws NullPointerException, IllegalArgumentException {
        Preconditions<S, T> self = new Preconditions<S, T>(parameter, name);
        return (S)self;
    }

    public static <E> CollectionPreconditions<E> requireThat(Collection<E> parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new CollectionPreconditions<E>(parameter, name);
    }

    public static <S extends NumberPreconditions<S, T>, T extends Number> NumberPreconditions<S, T> requireThat(T parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new NumberPreconditions(parameter, name);
    }

    public static BigDecimalPreconditions requireThat(BigDecimal parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new BigDecimalPreconditions(parameter, name);
    }

    public static <K, V> MapPreconditions<K, V> requireThat(Map<K, V> parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new MapPreconditions<K, V>(parameter, name);
    }

    public static PathPreconditions requireThat(Path parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new PathPreconditions(parameter, name);
    }

    public static StringPreconditions requireThat(String parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new StringPreconditions(parameter, name);
    }

    public static UriPreconditions requireThat(URI parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new UriPreconditions(parameter, name);
    }

    public static <T> ClassPreconditions<T> requireThat(Class<T> parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new ClassPreconditions<T>(parameter, name);
    }

    public static YearPreconditions requireThat(Year parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new YearPreconditions(parameter, name);
    }

    public static OptionalPreconditions requireThat(Optional<?> parameter, String name) throws NullPointerException, IllegalArgumentException {
        return new OptionalPreconditions(parameter, name);
    }

    protected Preconditions(T parameter, String name) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name may not be null");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name may not be empty");
        }
        Preconditions self = this;
        this.self = self;
        this.parameter = parameter;
        this.name = name;
    }

    public S isNotNull() throws NullPointerException {
        if (this.parameter == null) {
            throw new NullPointerException(this.name + " may not be null");
        }
        return this.self;
    }

    public S stateIsNotNull() throws IllegalStateException {
        if (this.parameter == null) {
            throw new IllegalStateException(this.name + " may not be null");
        }
        return this.self;
    }

    public S isEqualTo(T value) throws IllegalArgumentException {
        if (!Objects.equals(this.parameter, value)) {
            throw new IllegalArgumentException(this.name + " must be equal to " + value + ". Was: " + this.parameter);
        }
        return this.self;
    }

    public S isInstanceOf(Class<?> type) throws NullPointerException, IllegalArgumentException {
        if (this.parameter == null) {
            throw new NullPointerException("parameter may not be null");
        }
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (!type.isInstance(this.parameter)) {
            throw new IllegalArgumentException(this.name + " must be an instance of " + type + ". Was: " + this.parameter.getClass());
        }
        return this.self;
    }
}

