/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.bitbucket.cowwoc.preconditions.Preconditions;

public final class StringPreconditions
extends Preconditions<StringPreconditions, String> {
    private static final Pattern emailPattern = Pattern.compile("[^@]+@[^@]+");

    StringPreconditions(String parameter, String name) throws NullPointerException, IllegalArgumentException {
        super(parameter, name);
    }

    public StringPreconditions isEmpty() throws IllegalArgumentException {
        if (!((String)this.parameter).isEmpty()) {
            throw new IllegalArgumentException(this.name + " must be empty");
        }
        return this;
    }

    public StringPreconditions isNotEmpty() throws IllegalArgumentException {
        if (((String)this.parameter).isEmpty()) {
            throw new IllegalArgumentException(this.name + " may not be empty");
        }
        return this;
    }

    public StringPreconditions trim() {
        this.parameter = ((String)this.parameter).trim();
        return this;
    }

    public StringPreconditions lengthIn(Range<Integer> range) throws NullPointerException, IllegalArgumentException {
        if (this.parameter == null) {
            throw new NullPointerException("parameter may not be null");
        }
        if (range == null) {
            throw new NullPointerException("range may not be null");
        }
        boolean inRange = range.contains((Comparable)Integer.valueOf(((String)this.parameter).length()));
        if (inRange) {
            return this;
        }
        Range canonical = range.canonical(DiscreteDomain.integers());
        throw new IllegalArgumentException(this.name + "'s length must be in the " + "range [" + canonical.lowerEndpoint() + ", " + ((Integer)canonical.upperEndpoint() - 1) + "], was " + ((String)this.parameter).length() + ". " + this.name + ": \"" + (String)this.parameter + "\"");
    }

    public StringPreconditions hasMinimumLength(int minLength) throws IllegalArgumentException {
        if (((String)this.parameter).length() < minLength) {
            throw new IllegalArgumentException(this.name + " may not be shorter than " + minLength + " characters, was: " + ((String)this.parameter).length() + ". " + this.name + ": \"" + (String)this.parameter + "\"");
        }
        return this;
    }

    public StringPreconditions hasLength(int length) throws IllegalArgumentException {
        if (((String)this.parameter).length() != length) {
            throw new IllegalArgumentException(this.name + "'s length must be equal to " + length + " characters, was " + ((String)this.parameter).length() + ". " + this.name + ": \"" + (String)this.parameter + "\"");
        }
        return this;
    }

    public StringPreconditions hasMaximumLength(int maxLength) throws IllegalArgumentException {
        if (((String)this.parameter).length() > maxLength) {
            throw new IllegalArgumentException(this.name + " may not be longer than " + maxLength + " characters, was: " + ((String)this.parameter).length() + ". " + this.name + ": \"" + (String)this.parameter + "\"");
        }
        return this;
    }

    public StringPreconditions isEmailFormat() throws IllegalArgumentException {
        if (!emailPattern.matcher((CharSequence)this.parameter).matches()) {
            throw new IllegalArgumentException(this.name + " does not contain a valid email format: " + (String)this.parameter);
        }
        return this;
    }

    public StringPreconditions isIpAddressFormat() throws IllegalArgumentException {
        ((StringPreconditions)this.isNotNull()).isNotEmpty();
        char firstCharacter = ((String)this.parameter).charAt(0);
        if (Character.digit(firstCharacter, 16) == -1 && firstCharacter != ':') {
            throw new IllegalArgumentException(this.name + " does not contain a valid IP address format: " + (String)this.parameter);
        }
        try {
            InetAddress.getByName((String)this.parameter);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(this.name + " does not contain a valid IP address format: " + (String)this.parameter, e);
        }
        return this;
    }

    public StringPreconditions startsWith(String prefix) throws IllegalArgumentException {
        if (!((String)this.parameter).startsWith(prefix)) {
            throw new IllegalArgumentException(this.name + " must start with: " + prefix);
        }
        return this;
    }

    public StringPreconditions doesNotStartWith(String prefix) throws IllegalArgumentException {
        if (((String)this.parameter).startsWith(prefix)) {
            throw new IllegalArgumentException(this.name + " must not start with: " + prefix);
        }
        return this;
    }

    public StringPreconditions endsWith(String suffix) throws IllegalArgumentException {
        if (!((String)this.parameter).endsWith(suffix)) {
            throw new IllegalArgumentException(this.name + " must end with: " + suffix);
        }
        return this;
    }

    public StringPreconditions doesNotEndWith(String suffix) throws IllegalArgumentException {
        if (((String)this.parameter).endsWith(suffix)) {
            throw new IllegalArgumentException(this.name + " must not end with: " + suffix);
        }
        return this;
    }
}

