/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.preconditions;

import com.google.common.collect.Range;
import java.time.Year;
import org.bitbucket.cowwoc.preconditions.Preconditions;

public class YearPreconditions
extends Preconditions<YearPreconditions, Year> {
    YearPreconditions(Year parameter, String name) throws NullPointerException, IllegalArgumentException {
        super(parameter, name);
    }

    public YearPreconditions isIn(Range<Year> range) throws NullPointerException, IllegalArgumentException {
        ((Preconditions)Preconditions.requireThat(range, "range")).isNotNull();
        boolean inRange = range.contains((Comparable)this.parameter);
        if (inRange) {
            return (YearPreconditions)this.self;
        }
        StringBuilder message = new StringBuilder(this.name + " (" + this.parameter + ") must be in the range ");
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append("(");
                break;
            }
            case CLOSED: {
                message.append("[");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        message.append(range.lowerEndpoint()).append(", ").append(range.upperEndpoint());
        switch (range.lowerBoundType()) {
            case OPEN: {
                message.append(")");
                break;
            }
            case CLOSED: {
                message.append("]");
                break;
            }
            default: {
                throw new AssertionError((Object)range.lowerBoundType().name());
            }
        }
        throw new IllegalArgumentException(message.toString());
    }

    public YearPreconditions isLessThan(Year value, String name) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) >= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + name + " (" + value + ")");
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isLessThan(Year value) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) >= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + value);
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isLessThanOrEqualTo(Year value, String name) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) > 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + "or equal to " + name + " (" + value + ")");
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isLessThanOrEqualTo(Year value) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) > 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be less than " + "or equal to " + value);
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isGreaterThan(Year value, String name) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) <= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + name + " (" + value + ")");
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isGreaterThan(Year value) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) <= 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + value);
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isGreaterThanOrEqualTo(Year value, String name) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) < 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + "or equal to " + name + " (" + value + ")");
        }
        return (YearPreconditions)this.self;
    }

    public YearPreconditions isGreaterThanOrEqualTo(Year value) throws IllegalArgumentException {
        if (((Year)this.parameter).compareTo(value) < 0) {
            throw new IllegalArgumentException(this.name + " (" + this.parameter + ") must be greater than " + "or equal to " + value);
        }
        return (YearPreconditions)this.self;
    }
}

